/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.record.script;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.record.script.AbstractScriptedRecordFactory;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;

@Tags(value={"record", "recordFactory", "script", "invoke", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Allows the user to provide a scripted RecordReaderFactory instance in order to read/parse/generate records from an incoming flow file.")
@DynamicProperty(name="Script Engine Binding property", value="Binding property value passed to Script Runner", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class ScriptedReader
extends AbstractScriptedRecordFactory<RecordReaderFactory>
implements RecordReaderFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        super.onEnabled(context);
        if (this.scriptRunner == null) throw new ProcessException("Error creating ScriptRunner");
        ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
        Invocable invocable = (Invocable)((Object)scriptEngine);
        if (this.configurationContext == null) return;
        try {
            Object obj = scriptEngine.get("reader");
            if (obj == null) throw new ScriptException("No ScriptedReader was defined by the script.");
            try {
                invocable.invokeMethod(obj, "onEnabled", context);
                return;
            }
            catch (NoSuchMethodException nsme) {
                if (!this.getLogger().isDebugEnabled()) return;
                this.getLogger().debug("Configured script for ScriptedReader does not contain an onEnabled() method.");
            }
            return;
        }
        catch (ScriptException se) {
            throw new ProcessException("Error executing onEnabled(context) method", (Throwable)se);
        }
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws MalformedRecordException, IOException, SchemaNotFoundException {
        if (this.recordFactory.get() != null) {
            try {
                return ((RecordReaderFactory)this.recordFactory.get()).createRecordReader(variables, in, inputLength, logger);
            }
            catch (UndeclaredThrowableException ute) {
                this.scriptRunner = null;
                this.scriptingComponentHelper.scriptRunnerQ.clear();
                throw new IOException(ute.getCause());
            }
        }
        return null;
    }

    @Override
    protected boolean reloadScript(String scriptBody) {
        HashSet<ValidationResult> results;
        block9: {
            results = new HashSet<ValidationResult>();
            try {
                this.scriptingComponentHelper.setupScriptRunners(1, scriptBody, this.getLogger());
                this.scriptRunner = (ScriptRunner)this.scriptingComponentHelper.scriptRunnerQ.poll();
                if (this.scriptRunner == null) {
                    throw new ProcessException("No script runner available!");
                }
                ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
                if (!(scriptEngine instanceof Invocable)) break block9;
                Invocable invocable = (Invocable)((Object)scriptEngine);
                this.scriptRunner.run(scriptEngine.getBindings(100));
                Object obj = this.scriptRunner.getScriptEngine().get("reader");
                if (obj != null) {
                    block11: {
                        ComponentLog logger;
                        block10: {
                            logger = this.getLogger();
                            try {
                                invocable.invokeMethod(obj, "setLogger", logger);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block10;
                                logger.debug("Configured script RecordReaderFactory does not contain a setLogger method.");
                            }
                        }
                        if (this.configurationContext != null) {
                            try {
                                invocable.invokeMethod(obj, "setConfigurationContext", this.configurationContext);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block11;
                                logger.debug("Configured script RecordReaderFactory does not contain a setConfigurationContext method.");
                            }
                        }
                    }
                    RecordReaderFactory scriptedReader = invocable.getInterface(obj, RecordReaderFactory.class);
                    this.recordFactory.set(scriptedReader);
                    break block9;
                }
                throw new ScriptException("No RecordReader was defined by the script.");
            }
            catch (Exception ex) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to load script: " + ex.getLocalizedMessage();
                logger.error(message, (Throwable)ex);
                results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + ex.getLocalizedMessage()).input(this.scriptingComponentHelper.getScriptPath()).build());
            }
        }
        this.validationResults.set(results);
        return results.isEmpty();
    }
}

