/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script;

import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.Invocable;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.script.ScriptRunnerFactory;
import org.apache.nifi.script.ScriptingComponentUtils;
import org.apache.nifi.util.StringUtils;

public class ScriptingComponentHelper {
    private static final String UNKNOWN_VERSION = "UNKNOWN";
    private static final List<String> DEPRECATED_LANGUAGE_NAMES = Arrays.asList("ECMAScript", "lua", "ruby", "python");
    private static final DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(ScriptingComponentHelper.class);
    public PropertyDescriptor SCRIPT_ENGINE;
    public final AtomicBoolean isInitialized = new AtomicBoolean(false);
    public Map<String, ScriptEngineFactory> scriptEngineFactoryMap;
    private String scriptEngineName;
    private String scriptPath;
    private String scriptBody;
    private List<PropertyDescriptor> descriptors;
    private List<AllowableValue> engineAllowableValues;
    private ResourceReferences modules;
    public BlockingQueue<ScriptRunner> scriptRunnerQ = null;

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getScriptBody() {
        return this.scriptBody;
    }

    public void setScriptBody(String scriptBody) {
        this.scriptBody = scriptBody;
    }

    public String[] getModules() {
        return this.modules.asLocations().toArray(new String[0]);
    }

    public void setModules(ResourceReferences modules) {
        this.modules = modules;
    }

    public List<PropertyDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public List<AllowableValue> getScriptEngineAllowableValues() {
        return this.engineAllowableValues;
    }

    public void setDescriptors(List<PropertyDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        Map propertyMap = validationContext.getProperties();
        if (StringUtils.isEmpty((String)((String)propertyMap.get(ScriptingComponentUtils.SCRIPT_FILE))) == StringUtils.isEmpty((String)((String)propertyMap.get(ScriptingComponentUtils.SCRIPT_BODY)))) {
            results.add(new ValidationResult.Builder().subject("Script Body or Script File").valid(false).explanation("exactly one of Script File or Script Body must be set").build());
        }
        return results;
    }

    public void createResources() {
        this.createResources(true);
    }

    public void createResources(boolean requireInvocable) {
        this.descriptors = new ArrayList<PropertyDescriptor>();
        System.setProperty("org.jruby.embed.localvariable.behavior", "persistent");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> scriptEngineFactories = scriptEngineManager.getEngineFactories();
        if (scriptEngineFactories != null) {
            this.scriptEngineFactoryMap = new HashMap<String, ScriptEngineFactory>(scriptEngineFactories.size());
            LinkedList<AllowableValue> engineList = new LinkedList<AllowableValue>();
            for (ScriptEngineFactory factory : scriptEngineFactories) {
                if (requireInvocable && !(factory.getScriptEngine() instanceof Invocable)) continue;
                AllowableValue scriptEngineAllowableValue = this.getScriptLanguageAllowableValue(factory);
                engineList.add(scriptEngineAllowableValue);
                this.scriptEngineFactoryMap.put(factory.getLanguageName(), factory);
            }
            engineList.sort((o1, o2) -> {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getValue().compareTo(o2.getValue());
            });
            this.engineAllowableValues = engineList;
            AllowableValue[] engines = engineList.toArray(new AllowableValue[0]);
            PropertyDescriptor.Builder enginePropertyBuilder = new PropertyDescriptor.Builder().name("Script Engine").required(true).description("Language Engine for executing scripts").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE);
            if (engineList.isEmpty()) {
                enginePropertyBuilder.description("No Script Engines found");
            } else {
                enginePropertyBuilder.allowableValues(engines);
                enginePropertyBuilder.defaultValue(engines[0].getValue());
            }
            this.SCRIPT_ENGINE = enginePropertyBuilder.build();
            this.descriptors.add(this.SCRIPT_ENGINE);
        }
        this.descriptors.add(ScriptingComponentUtils.SCRIPT_FILE);
        this.descriptors.add(ScriptingComponentUtils.SCRIPT_BODY);
        this.descriptors.add(ScriptingComponentUtils.MODULES);
        this.isInitialized.set(true);
    }

    public static boolean isFile(String path) {
        return path != null && Files.isRegularFile(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public void setupScriptRunners(int numberOfScriptEngines, String scriptToRun, ComponentLog log) {
        this.setupScriptRunners(true, numberOfScriptEngines, scriptToRun, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupScriptRunners(boolean newQ, int numberOfScriptEngines, String scriptToRun, ComponentLog log) {
        if (newQ) {
            this.scriptRunnerQ = new LinkedBlockingQueue<ScriptRunner>(numberOfScriptEngines);
        }
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader scriptEngineModuleClassLoader;
            if (StringUtils.isBlank((String)this.scriptEngineName)) {
                throw new IllegalArgumentException("The script engine name cannot be null");
            }
            String[] locations = this.modules == null ? new String[]{} : this.modules.asLocations().toArray(new String[0]);
            URL[] additionalClasspathURLs = ScriptRunnerFactory.getInstance().getModuleURLsForClasspath(this.scriptEngineName, locations, log);
            ClassLoader classLoader = scriptEngineModuleClassLoader = additionalClasspathURLs != null ? new URLClassLoader(additionalClasspathURLs, originalContextClassLoader) : originalContextClassLoader;
            if (scriptEngineModuleClassLoader != null) {
                Thread.currentThread().setContextClassLoader(scriptEngineModuleClassLoader);
            }
            try {
                for (int i = 0; i < numberOfScriptEngines; ++i) {
                    ScriptEngineFactory factory = this.scriptEngineFactoryMap.get(this.scriptEngineName);
                    ScriptRunner scriptRunner = ScriptRunnerFactory.getInstance().createScriptRunner(factory, scriptToRun, locations);
                    if (this.scriptRunnerQ.offer(scriptRunner)) continue;
                    log.error("Error adding script engine {}", new Object[]{scriptRunner.getScriptEngineName()});
                }
            }
            catch (ScriptException se) {
                throw new ProcessException("Could not instantiate script engines", (Throwable)se);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    public void setupVariables(PropertyContext context) {
        this.scriptEngineName = context.getProperty(this.SCRIPT_ENGINE).getValue();
        this.scriptPath = context.getProperty(ScriptingComponentUtils.SCRIPT_FILE).evaluateAttributeExpressions().getValue();
        this.scriptBody = context.getProperty(ScriptingComponentUtils.SCRIPT_BODY).getValue();
        this.modules = "python".equalsIgnoreCase(this.scriptEngineName) ? context.getProperty(ScriptingComponentUtils.MODULES).evaluateAttributeExpressions().asResources() : context.getProperty(ScriptingComponentUtils.MODULES).evaluateAttributeExpressions().asResources().flattenRecursively();
        if (DEPRECATED_LANGUAGE_NAMES.contains(this.scriptEngineName)) {
            deprecationLogger.warn("Support for Script Engine Language [{}] is deprecated", new Object[]{this.scriptEngineName});
        }
    }

    public void stop() {
        if (this.scriptRunnerQ != null) {
            this.scriptRunnerQ.clear();
        }
    }

    private AllowableValue getScriptLanguageAllowableValue(ScriptEngineFactory factory) {
        String languageName = factory.getLanguageName();
        String languageVersion = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)factory.getLanguageVersion(), (CharSequence)UNKNOWN_VERSION);
        String engineVersion = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)factory.getEngineVersion(), (CharSequence)UNKNOWN_VERSION);
        String description = String.format("%s %s [%s %s]", languageName, languageVersion, factory.getEngineName(), engineVersion);
        String displayName = DEPRECATED_LANGUAGE_NAMES.contains(languageName) ? String.format("%s DEPRECATED", languageName) : languageName;
        return new AllowableValue(languageName, displayName, description);
    }
}

