/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.script.impl.ClojureScriptRunner;
import org.apache.nifi.script.impl.GenericScriptRunner;
import org.apache.nifi.script.impl.GroovyScriptRunner;
import org.apache.nifi.script.impl.JavascriptScriptRunner;
import org.apache.nifi.script.impl.JythonScriptRunner;

public class ScriptRunnerFactory {
    private static final ScriptRunnerFactory INSTANCE = new ScriptRunnerFactory();

    private ScriptRunnerFactory() {
    }

    public static ScriptRunnerFactory getInstance() {
        return INSTANCE;
    }

    public ScriptRunner createScriptRunner(ScriptEngineFactory scriptEngineFactory, String scriptToRun, String[] modulePaths) throws ScriptException {
        ScriptEngine scriptEngine = scriptEngineFactory.getScriptEngine();
        String scriptEngineName = scriptEngineFactory.getLanguageName();
        if ("Groovy".equals(scriptEngineName)) {
            return new GroovyScriptRunner(scriptEngine, scriptToRun, null);
        }
        if ("python".equals(scriptEngineName)) {
            return new JythonScriptRunner(scriptEngine, scriptToRun, modulePaths);
        }
        if ("Clojure".equals(scriptEngineName)) {
            return new ClojureScriptRunner(scriptEngine, scriptToRun, null);
        }
        if ("ECMAScript".equals(scriptEngineName)) {
            return new JavascriptScriptRunner(scriptEngine, scriptToRun, null);
        }
        return new GenericScriptRunner(scriptEngine, scriptToRun, null);
    }

    public URL[] getModuleURLsForClasspath(String scriptEngineName, String[] modulePaths, ComponentLog log) {
        if (!("Clojure".equals(scriptEngineName) || "Groovy".equals(scriptEngineName) || "ECMAScript".equals(scriptEngineName))) {
            return new URL[0];
        }
        LinkedList<URL> additionalClasspath = new LinkedList<URL>();
        if (modulePaths == null) {
            return new URL[0];
        }
        for (String modulePathString : modulePaths) {
            File modulePath = new File(modulePathString);
            if (modulePath.exists()) {
                File[] jarFiles;
                try {
                    additionalClasspath.add(modulePath.toURI().toURL());
                }
                catch (MalformedURLException mue) {
                    log.warn("{} is not a valid file/folder, ignoring", new Object[]{modulePath.getAbsolutePath(), mue});
                }
                if (!modulePath.isDirectory() || (jarFiles = modulePath.listFiles((dir, name) -> name != null && name.endsWith(".jar"))) == null) continue;
                for (File jarFile : jarFiles) {
                    try {
                        additionalClasspath.add(jarFile.toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        log.warn("{} is not a valid file/folder, ignoring", new Object[]{modulePath.getAbsolutePath(), mue});
                    }
                }
                continue;
            }
            log.warn("{} does not exist, ignoring", new Object[]{modulePath.getAbsolutePath()});
        }
        return additionalClasspath.toArray(new URL[0]);
    }
}

