/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.script.impl.ValidationContextAdapter;

public class FilteredPropertiesValidationContextAdapter
extends ValidationContextAdapter {
    private HashMap<PropertyDescriptor, String> properties = new HashMap();

    public FilteredPropertiesValidationContextAdapter(ValidationContext validationContext, Set<PropertyDescriptor> removedProperties) {
        super(validationContext);
        Map<PropertyDescriptor, String> parentProperties = super.getProperties();
        if (parentProperties != null) {
            for (Map.Entry<PropertyDescriptor, String> propertyEntry : parentProperties.entrySet()) {
                if (removedProperties.contains(propertyEntry.getKey())) continue;
                this.properties.put(propertyEntry.getKey(), propertyEntry.getValue());
            }
        }
    }

    @Override
    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    @Override
    public Map<PropertyDescriptor, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        if (this.properties.keySet().contains(descriptor)) {
            return super.getProperty(descriptor);
        }
        return null;
    }
}

