/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.script.ScriptEvaluator;
import org.apache.nifi.processors.script.ScriptedTransformRecord;
import org.apache.nifi.serialization.record.Record;

class PythonScriptEvaluator
implements ScriptEvaluator {
    private final ScriptEngine scriptEngine;
    private final CompiledScript compiledScript;
    private final Bindings bindings;

    PythonScriptEvaluator(ScriptEngine scriptEngine, CompiledScript compiledScript, FlowFile flowFile, ComponentLog componentLog) {
        this.compiledScript = compiledScript;
        this.scriptEngine = scriptEngine;
        this.bindings = ScriptedTransformRecord.setupBindings(scriptEngine);
        this.bindings.put("attributes", (Object)flowFile.getAttributes());
        this.bindings.put("log", (Object)componentLog);
    }

    @Override
    public Object evaluate(Record record, long index) throws ScriptException {
        this.bindings.put("record", (Object)record);
        this.bindings.put("recordIndex", (Object)index);
        this.compiledScript.eval(this.bindings);
        return this.scriptEngine.get("_");
    }
}

