/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import java.util.Optional;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.util.text.DateTimeMatcher;

public class TimeValueInference {
    private final Optional<DataType> dateDataType;
    private final Optional<DataType> timeDataType;
    private final Optional<DataType> timestampDataType;
    private final DateTimeMatcher dateMatcher;
    private final DateTimeMatcher timeMatcher;
    private final DateTimeMatcher timestampMatcher;

    public TimeValueInference(String dateFormat, String timeFormat, String timestampFormat) {
        this.dateDataType = Optional.of(RecordFieldType.DATE.getDataType(dateFormat));
        this.timeDataType = Optional.of(RecordFieldType.TIME.getDataType(timeFormat));
        this.timestampDataType = Optional.of(RecordFieldType.TIMESTAMP.getDataType(timestampFormat));
        this.dateMatcher = DateTimeMatcher.compile((String)dateFormat);
        this.timeMatcher = DateTimeMatcher.compile((String)timeFormat);
        this.timestampMatcher = DateTimeMatcher.compile((String)timestampFormat);
    }

    public String getDateFormat() {
        return this.dateDataType.map(DataType::getFormat).orElse(null);
    }

    public String getTimeFormat() {
        return this.timeDataType.map(DataType::getFormat).orElse(null);
    }

    public String getTimestampFormat() {
        return this.timestampDataType.map(DataType::getFormat).orElse(null);
    }

    public Optional<DataType> getDataType(String value) {
        if (this.timestampMatcher.matches(value)) {
            return this.timestampDataType;
        }
        if (this.dateMatcher.matches(value)) {
            return this.dateDataType;
        }
        if (this.timeMatcher.matches(value)) {
            return this.timeDataType;
        }
        return Optional.empty();
    }
}

