/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.rethinkdb;

import com.rethinkdb.gen.ast.Insert;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.rethinkdb.AbstractRethinkDBProcessor;
import org.apache.nifi.processors.rethinkdb.DeleteRethinkDB;
import org.apache.nifi.processors.rethinkdb.GetRethinkDB;
import org.json.simple.parser.JSONParser;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@EventDriven
@SupportsBatching
@Tags(value={"rethinkdb", "stream", "insert", "update", "write", "put"})
@CapabilityDescription(value="Processor to write the JSON content of a FlowFile to RethinkDB (https://www.rethinkdb.com/). The flow file should contain either JSON Object an array of JSON documents")
@WritesAttributes(value={@WritesAttribute(attribute="rethinkdb.error.message", description="RethinkDB error message"), @WritesAttribute(attribute="rethinkdb.insert.errors", description="Error count while inserting documents"), @WritesAttribute(attribute="rethinkdb.insert.deleted", description="Number of documents deleted"), @WritesAttribute(attribute="rethinkdb.insert.generated_keys", description="Keys generated on inserting documents"), @WritesAttribute(attribute="rethinkdb.insert.inserted", description="Number of documents inserted"), @WritesAttribute(attribute="rethinkdb.insert.replaced", description="Number of documents replaced"), @WritesAttribute(attribute="rethinkdb.insert.skipped", description="Number of documents skipped because they already existed"), @WritesAttribute(attribute="rethinkdb.insert.unchanged", description="Number of documents unchanged since they already existed"), @WritesAttribute(attribute="rethinkdb.insert.first_error", description="First error while inserting documents"), @WritesAttribute(attribute="rethinkdb.insert.warnings", description="Warning message in case of large number of ids being returned on insertion")})
@SeeAlso(value={GetRethinkDB.class, DeleteRethinkDB.class})
@DeprecationNotice(reason="RethinkDB 2.4 requires API changes that would alter the configuration and behavior of this Processor")
public class PutRethinkDB
extends AbstractRethinkDBProcessor {
    public static AllowableValue CONFLICT_STRATEGY_UPDATE = new AllowableValue("update", "Update", "Update the document having same id with new values");
    public static AllowableValue CONFLICT_STRATEGY_REPLACE = new AllowableValue("replace", "Replace", "Replace the document with having same id new document");
    public static AllowableValue CONFLICT_STRATEGY_ERROR = new AllowableValue("error", "Error", "Return error if the document with same id exists");
    protected static final PropertyDescriptor CONFLICT_STRATEGY = new PropertyDescriptor.Builder().name("rethinkdb-conflict-strategy").displayName("Conflict strategy").description("Conflict strategy to be used in case of inserting existing document.").required(true).defaultValue(CONFLICT_STRATEGY_UPDATE.getValue()).allowableValues(new AllowableValue[]{CONFLICT_STRATEGY_UPDATE, CONFLICT_STRATEGY_REPLACE, CONFLICT_STRATEGY_ERROR}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    public static final String RETHINKDB_INSERT_RESULT = "rethinkdb.insert.result";
    public static final String RETHINKDB_INSERT_RESULT_ERROR_KEY = "rethinkdb.insert.errors";
    public static final String RETHINKDB_INSERT_RESULT_DELETED_KEY = "rethinkdb.insert.deleted";
    public static final String RETHINKDB_INSERT_RESULT_GENERATED_KEYS_KEY = "rethinkdb.insert.generated_keys";
    public static final String RETHINKDB_INSERT_RESULT_INSERTED_KEY = "rethinkdb.insert.inserted";
    public static final String RETHINKDB_INSERT_RESULT_REPLACED_KEY = "rethinkdb.insert.replaced";
    public static final String RETHINKDB_INSERT_RESULT_SKIPPED_KEY = "rethinkdb.insert.skipped";
    public static final String RETHINKDB_INSERT_RESULT_UNCHANGED_KEY = "rethinkdb.insert.unchanged";
    public static final String RETHINKDB_INSERT_RESULT_FIRST_ERROR_KEY = "rethinkdb.insert.first_error";
    public static final String RETHINKDB_INSERT_RESULT_WARNINGS_KEY = "rethinkdb.insert.warnings";
    public final String CONFLICT_OPTION_KEY = "conflict";

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.maxDocumentsSize = context.getProperty(MAX_DOCUMENTS_SIZE).asDataSize(DataUnit.B).longValue();
        super.onScheduled(context);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        if (flowFile.getSize() == 0L) {
            this.getLogger().error("Empty message");
            flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", "Empty message size " + flowFile.getSize());
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        if (flowFile.getSize() > this.maxDocumentsSize) {
            this.getLogger().error("Message size exceeded {} max allowed is {}", new Object[]{flowFile.getSize(), this.maxDocumentsSize});
            flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", "Max message size exceeded " + flowFile.getSize());
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        Charset charset = Charset.forName(context.getProperty(CHARSET).evaluateAttributeExpressions(flowFile).getValue());
        String conflictStrategy = context.getProperty(CONFLICT_STRATEGY).evaluateAttributeExpressions(flowFile).getValue();
        String durability = context.getProperty(DURABILITY).evaluateAttributeExpressions(flowFile).getValue();
        try {
            long startTimeMillis = System.currentTimeMillis();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            session.exportTo(flowFile, (OutputStream)baos);
            String documents = new String(baos.toByteArray(), charset);
            JSONParser parser = new JSONParser();
            Object jsonDocuments = parser.parse(documents);
            Insert insert = this.getRdbTable().insert(jsonDocuments).optArg("conflict", (Object)conflictStrategy).optArg("durability", (Object)durability);
            HashMap<String, Object> result = this.runInsert(insert);
            long endTimeMillis = System.currentTimeMillis();
            this.getLogger().debug("Json documents {} inserted Result: {}", new Object[]{documents, result});
            flowFile = this.populateAttributes(session, flowFile, result);
            if ((Long)result.get("errors") != 0L) {
                this.getLogger().error("There were errors while inserting data documents {} result {}", new Object[]{documents, result});
                session.transfer(flowFile, REL_FAILURE);
            } else {
                session.transfer(flowFile, REL_SUCCESS);
                session.getProvenanceReporter().send(flowFile, "rethinkdb://" + this.databaseName + "/" + this.tableName, endTimeMillis - startTimeMillis);
            }
        }
        catch (Exception exception) {
            this.getLogger().error("Failed to insert into RethinkDB due to {}", new Object[]{exception.getLocalizedMessage(), exception});
            flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", String.valueOf(exception.getMessage()));
            session.transfer(flowFile, REL_FAILURE);
            context.yield();
        }
    }

    private FlowFile populateAttributes(ProcessSession session, FlowFile flowFile, HashMap<String, Object> result) {
        HashMap<String, String> resultAttributes = new HashMap<String, String>();
        resultAttributes.put(RETHINKDB_INSERT_RESULT, result.toString());
        resultAttributes.put(RETHINKDB_INSERT_RESULT_ERROR_KEY, String.valueOf(result.get("errors")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_DELETED_KEY, String.valueOf(result.get("deleted")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_GENERATED_KEYS_KEY, String.valueOf(result.get("generated_keys")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_INSERTED_KEY, String.valueOf(result.get("inserted")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_REPLACED_KEY, String.valueOf(result.get("replaced")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_SKIPPED_KEY, String.valueOf(result.get("skipped")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_UNCHANGED_KEY, String.valueOf(result.get("unchanged")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_FIRST_ERROR_KEY, String.valueOf(result.get("first_error")));
        resultAttributes.put(RETHINKDB_INSERT_RESULT_WARNINGS_KEY, String.valueOf(result.get("warnings")));
        flowFile = session.putAllAttributes(flowFile, resultAttributes);
        return flowFile;
    }

    protected HashMap<String, Object> runInsert(Insert insert) {
        return (HashMap)insert.run(this.rethinkDbConnection);
    }

    @Override
    @OnStopped
    public void close() {
        super.close();
    }

    static {
        HashSet<Relationship> tempRelationships = new HashSet<Relationship>();
        tempRelationships.add(REL_SUCCESS);
        tempRelationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(tempRelationships);
        ArrayList<PropertyDescriptor> tempDescriptors = new ArrayList<PropertyDescriptor>();
        tempDescriptors.add(DB_NAME);
        tempDescriptors.add(DB_HOST);
        tempDescriptors.add(DB_PORT);
        tempDescriptors.add(USERNAME);
        tempDescriptors.add(PASSWORD);
        tempDescriptors.add(TABLE_NAME);
        tempDescriptors.add(CHARSET);
        tempDescriptors.add(CONFLICT_STRATEGY);
        tempDescriptors.add(DURABILITY);
        tempDescriptors.add(MAX_DOCUMENTS_SIZE);
        propertyDescriptors = Collections.unmodifiableList(tempDescriptors);
    }
}

