/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.rethinkdb;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.rethinkdb.AbstractRethinkDBProcessor;
import org.apache.nifi.processors.rethinkdb.DeleteRethinkDB;
import org.apache.nifi.processors.rethinkdb.PutRethinkDB;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@EventDriven
@Tags(value={"rethinkdb", "get", "read", "fetch"})
@CapabilityDescription(value="Processor to get a JSON document from RethinkDB (https://www.rethinkdb.com/) using the document id. The FlowFile will contain the retrieved document")
@WritesAttributes(value={@WritesAttribute(attribute="rethinkdb.error.message", description="RethinkDB error message")})
@SeeAlso(value={PutRethinkDB.class, DeleteRethinkDB.class})
@DeprecationNotice(reason="RethinkDB 2.4 requires API changes that would alter the configuration and behavior of this Processor")
public class GetRethinkDB
extends AbstractRethinkDBProcessor {
    public static AllowableValue READ_MODE_SINGLE = new AllowableValue("single", "Single", "Read values from memory from primary replica (Default)");
    public static AllowableValue READ_MODE_MAJORITY = new AllowableValue("majority", "Majority", "Read values committed to disk on majority of replicas");
    public static AllowableValue READ_MODE_OUTDATED = new AllowableValue("outdated", "Outdated", "Read values from memory from an arbitrary replica ");
    protected static final PropertyDescriptor READ_MODE = new PropertyDescriptor.Builder().name("rethinkdb-read-mode").displayName("Read Mode").description("Read mode used for consistency").required(true).defaultValue(READ_MODE_SINGLE.getValue()).allowableValues(new AllowableValue[]{READ_MODE_SINGLE, READ_MODE_MAJORITY, READ_MODE_OUTDATED}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    protected String READ_MODE_KEY = "read_mode";
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    protected Gson gson = new Gson();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.maxDocumentsSize = context.getProperty(MAX_DOCUMENTS_SIZE).asDataSize(DataUnit.B).longValue();
        super.onScheduled(context);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Charset charset = Charset.forName(context.getProperty(CHARSET).evaluateAttributeExpressions(flowFile).getValue());
        String id = context.getProperty(RETHINKDB_DOCUMENT_ID).evaluateAttributeExpressions(flowFile).getValue();
        String readMode = context.getProperty(READ_MODE).evaluateAttributeExpressions(flowFile).getValue();
        if (StringUtils.isEmpty((CharSequence)id)) {
            this.getLogger().error("Document Id cannot be empty");
            flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", "Document Id cannot be empty");
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        try {
            long startTimeMillis = System.currentTimeMillis();
            Map<String, Object> document = this.getDocument(id, readMode);
            if (document == null) {
                this.getLogger().debug("Document with id '" + id + "' not found");
                flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", "Document with id '" + id + "' not found");
                session.transfer(flowFile, REL_NOT_FOUND);
                return;
            }
            String json = this.gson.toJson(document);
            byte[] documentBytes = json.getBytes(charset);
            if ((long)documentBytes.length > this.maxDocumentsSize) {
                this.getLogger().error("Document too big with size " + documentBytes.length + " and max limit is " + this.maxDocumentsSize);
                flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", "Document too big size " + documentBytes.length + " bytes");
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(documentBytes);
            session.importFrom((InputStream)bais, flowFile);
            long endTimeMillis = System.currentTimeMillis();
            this.getLogger().debug("Json document {} retrieved Result: {}", new Object[]{id, document});
            session.transfer(flowFile, REL_SUCCESS);
            session.getProvenanceReporter().fetch(flowFile, "rethinkdb://" + this.databaseName + "/" + this.tableName + "/" + id, endTimeMillis - startTimeMillis);
        }
        catch (Exception exception) {
            this.getLogger().error("Failed to get document from RethinkDB due to error {}", new Object[]{exception.getLocalizedMessage(), exception});
            flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", exception.getMessage());
            session.transfer(flowFile, REL_FAILURE);
            context.yield();
        }
    }

    protected Map<String, Object> getDocument(String id, String readMode) {
        return (Map)this.getRdbTable().optArg(this.READ_MODE_KEY, (Object)readMode).get((Object)id).run(this.rethinkDbConnection);
    }

    @Override
    @OnStopped
    public void close() {
        super.close();
    }

    static {
        HashSet<Relationship> tempRelationships = new HashSet<Relationship>();
        tempRelationships.add(REL_SUCCESS);
        tempRelationships.add(REL_FAILURE);
        tempRelationships.add(REL_NOT_FOUND);
        relationships = Collections.unmodifiableSet(tempRelationships);
        ArrayList<PropertyDescriptor> tempDescriptors = new ArrayList<PropertyDescriptor>();
        tempDescriptors.add(DB_NAME);
        tempDescriptors.add(DB_HOST);
        tempDescriptors.add(DB_PORT);
        tempDescriptors.add(USERNAME);
        tempDescriptors.add(PASSWORD);
        tempDescriptors.add(TABLE_NAME);
        tempDescriptors.add(CHARSET);
        tempDescriptors.add(RETHINKDB_DOCUMENT_ID);
        tempDescriptors.add(READ_MODE);
        tempDescriptors.add(MAX_DOCUMENTS_SIZE);
        propertyDescriptors = Collections.unmodifiableList(tempDescriptors);
    }
}

