/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.rethinkdb;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.rethinkdb.AbstractRethinkDBProcessor;
import org.apache.nifi.processors.rethinkdb.GetRethinkDB;
import org.apache.nifi.processors.rethinkdb.PutRethinkDB;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@EventDriven
@Tags(value={"rethinkdb", "delete", "remove"})
@CapabilityDescription(value="Processor to remove a JSON document from RethinkDB (https://www.rethinkdb.com/) using the document id.")
@WritesAttributes(value={@WritesAttribute(attribute="rethinkdb.error.message", description="RethinkDB error message"), @WritesAttribute(attribute="rethinkdb.delete.errors", description="Error count while delete documents"), @WritesAttribute(attribute="rethinkdb.delete.deleted", description="Number of documents deleted"), @WritesAttribute(attribute="rethinkdb.delete.inserted", description="Number of documents inserted"), @WritesAttribute(attribute="rethinkdb.delete.replaced", description="Number of documents replaced"), @WritesAttribute(attribute="rethinkdb.delete.skipped", description="Number of documents skipped"), @WritesAttribute(attribute="rethinkdb.delete.unchanged", description="Number of documents unchanged since they already existed")})
@SeeAlso(value={PutRethinkDB.class, GetRethinkDB.class})
@DeprecationNotice(reason="RethinkDB 2.4 requires API changes that would alter the configuration and behavior of this Processor")
public class DeleteRethinkDB
extends AbstractRethinkDBProcessor {
    public static AllowableValue RETURN_CHANGES_TRUE = new AllowableValue("true", "True", "Return changed document");
    public static AllowableValue RETURN_CHANGES_FALSE = new AllowableValue("false", "False", "Do not return changed document");
    protected static final PropertyDescriptor RETURN_CHANGES = new PropertyDescriptor.Builder().name("rethinkdb-return-result").displayName("Return deleted value").description("Return old value which were deleted").required(true).defaultValue(RETURN_CHANGES_TRUE.getValue()).allowableValues(new AllowableValue[]{RETURN_CHANGES_TRUE, RETURN_CHANGES_FALSE}).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    public static final String RETHINKDB_DELETE_RESULT_ERROR_KEY = "rethinkdb.delete.errors";
    public static final String RETHINKDB_DELETE_RESULT_DELETED_KEY = "rethinkdb.delete.deleted";
    public static final String RETHINKDB_DELETE_RESULT_INSERTED_KEY = "rethinkdb.delete.inserted";
    public static final String RETHINKDB_DELETE_RESULT_REPLACED_KEY = "rethinkdb.delete.replaced";
    public static final String RETHINKDB_DELETE_RESULT_SKIPPED_KEY = "rethinkdb.delete.skipped";
    public static final String RETHINKDB_DELETE_RESULT_UNCHANGED_KEY = "rethinkdb.delete.unchanged";
    public static final String RESULT_CHANGES_KEY = "changes";
    public static final String RETURN_CHANGES_OPTION_KEY = "return_changes";
    protected Gson gson = new Gson();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        super.onScheduled(context);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        Charset charset = Charset.forName(context.getProperty(CHARSET).evaluateAttributeExpressions(flowFile).getValue());
        String id = context.getProperty(RETHINKDB_DOCUMENT_ID).evaluateAttributeExpressions(flowFile).getValue();
        String durablity = context.getProperty(DURABILITY).evaluateAttributeExpressions(flowFile).getValue();
        Boolean returnChanges = context.getProperty(RETURN_CHANGES).evaluateAttributeExpressions(flowFile).asBoolean();
        if (StringUtils.isEmpty((CharSequence)id)) {
            this.getLogger().error("Document Id cannot be empty");
            flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", "Document Id cannot be empty");
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        try {
            long startTimeMillis = System.currentTimeMillis();
            Map<String, Object> result = this.deleteDocument(id, durablity, returnChanges);
            long endTimeMillis = System.currentTimeMillis();
            this.getLogger().debug("Json document {} deleted Result: {}", new Object[]{id, result});
            flowFile = this.populateAttributes(session, flowFile, result);
            Long deletedCount = (long)((Long)result.get("deleted"));
            if (deletedCount == 0L) {
                this.getLogger().debug("Deleted count should be 1 but was " + deletedCount + " for document with id '" + id + "'");
                flowFile = this.populateAttributes(session, flowFile, result);
                flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", "Deleted count should be 1 but was " + deletedCount + " for document with id '" + id + "'");
                session.transfer(flowFile, REL_NOT_FOUND);
                return;
            }
            if (returnChanges.booleanValue()) {
                String json = this.gson.toJson(((List)result.get(RESULT_CHANGES_KEY)).get(0));
                byte[] documentBytes = json.getBytes(charset);
                ByteArrayInputStream bais = new ByteArrayInputStream(documentBytes);
                session.importFrom((InputStream)bais, flowFile);
                session.getProvenanceReporter().modifyContent(flowFile, "rethinkdb://" + this.databaseName + "/" + this.tableName + "/" + id, endTimeMillis - startTimeMillis);
            }
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception exception) {
            this.getLogger().error("Failed to delete document from RethinkDB due to error {}", new Object[]{exception.getLocalizedMessage(), exception});
            flowFile = session.putAttribute(flowFile, "rethinkdb.error.message", exception.getMessage());
            session.transfer(flowFile, REL_FAILURE);
            context.yield();
        }
    }

    private FlowFile populateAttributes(ProcessSession session, FlowFile flowFile, Map<String, Object> result) {
        HashMap<String, String> resultAttributes = new HashMap<String, String>();
        resultAttributes.put(RETHINKDB_DELETE_RESULT_ERROR_KEY, String.valueOf(result.get("errors")));
        resultAttributes.put(RETHINKDB_DELETE_RESULT_DELETED_KEY, String.valueOf(result.get("deleted")));
        resultAttributes.put(RETHINKDB_DELETE_RESULT_INSERTED_KEY, String.valueOf(result.get("inserted")));
        resultAttributes.put(RETHINKDB_DELETE_RESULT_REPLACED_KEY, String.valueOf(result.get("replaced")));
        resultAttributes.put(RETHINKDB_DELETE_RESULT_SKIPPED_KEY, String.valueOf(result.get("skipped")));
        resultAttributes.put(RETHINKDB_DELETE_RESULT_UNCHANGED_KEY, String.valueOf(result.get("unchanged")));
        flowFile = session.putAllAttributes(flowFile, resultAttributes);
        return flowFile;
    }

    protected Map<String, Object> deleteDocument(String id, String durablity, Boolean returnChanges) {
        return (Map)this.getRdbTable().get((Object)id).delete().optArg("durability", (Object)durablity).optArg(RETURN_CHANGES_OPTION_KEY, (Object)returnChanges).run(this.rethinkDbConnection);
    }

    @Override
    @OnStopped
    public void close() {
        super.close();
    }

    static {
        HashSet<Relationship> tempRelationships = new HashSet<Relationship>();
        tempRelationships.add(REL_SUCCESS);
        tempRelationships.add(REL_FAILURE);
        tempRelationships.add(REL_NOT_FOUND);
        relationships = Collections.unmodifiableSet(tempRelationships);
        ArrayList<PropertyDescriptor> tempDescriptors = new ArrayList<PropertyDescriptor>();
        tempDescriptors.add(DB_NAME);
        tempDescriptors.add(DB_HOST);
        tempDescriptors.add(DB_PORT);
        tempDescriptors.add(USERNAME);
        tempDescriptors.add(PASSWORD);
        tempDescriptors.add(TABLE_NAME);
        tempDescriptors.add(CHARSET);
        tempDescriptors.add(RETHINKDB_DOCUMENT_ID);
        tempDescriptors.add(RETURN_CHANGES);
        tempDescriptors.add(DURABILITY);
        propertyDescriptors = Collections.unmodifiableList(tempDescriptors);
    }
}

