/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

@Tags(value={"schema", "registry", "avro", "json", "csv"})
@CapabilityDescription(value="Provides a service for registering and accessing schemas. You can register a schema as a dynamic property where 'name' represents the schema name and 'value' represents the textual representation of the actual schema following the syntax and semantics of Avro's Schema format.")
@DynamicProperty(name="Schema name", value="Schema Content", description="Adds a named schema using the JSON string representation of an Avro schema", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class AvroSchemaRegistry
extends AbstractControllerService
implements SchemaRegistry {
    private static final Set<SchemaField> schemaFields = EnumSet.of(SchemaField.SCHEMA_NAME, SchemaField.SCHEMA_TEXT, SchemaField.SCHEMA_TEXT_FORMAT);
    private final ConcurrentMap<String, RecordSchema> recordSchemas = new ConcurrentHashMap<String, RecordSchema>();
    static final PropertyDescriptor VALIDATE_FIELD_NAMES = new PropertyDescriptor.Builder().name("avro-reg-validated-field-names").displayName("Validate Field Names").description("Whether or not to validate the field names in the Avro schema based on Avro naming rules. If set to true, all field names must be valid Avro names, which must begin with [A-Za-z_], and subsequently contain only [A-Za-z0-9_]. If set to false, no validation will be performed on the field names.").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    private List<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        super.init(config);
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.add(VALIDATE_FIELD_NAMES);
        this.propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isDynamic()) {
            if (newValue == null) {
                this.recordSchemas.remove(descriptor.getName());
            } else {
                try {
                    Schema avroSchema = new Schema.Parser().setValidate(false).parse(newValue);
                    SchemaIdentifier schemaId = SchemaIdentifier.builder().name(descriptor.getName()).build();
                    RecordSchema recordSchema = AvroTypeUtil.createSchema((Schema)avroSchema, (String)newValue, (SchemaIdentifier)schemaId);
                    this.recordSchemas.put(descriptor.getName(), recordSchema);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        boolean strict = validationContext.getProperty(VALIDATE_FIELD_NAMES).asBoolean();
        validationContext.getProperties().entrySet().stream().filter(entry -> ((PropertyDescriptor)entry.getKey()).isDynamic()).forEach(entry -> {
            String subject = ((PropertyDescriptor)entry.getKey()).getDisplayName();
            String input = (String)entry.getValue();
            try {
                Schema avroSchema = new Schema.Parser().setValidate(strict).parse(input);
                AvroTypeUtil.createSchema((Schema)avroSchema, (String)input, (SchemaIdentifier)SchemaIdentifier.EMPTY);
            }
            catch (Exception e) {
                results.add(new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Not a valid Avro Schema: " + e.getMessage()).build());
            }
        });
        return results;
    }

    private RecordSchema retrieveSchemaByName(String schemaName) throws SchemaNotFoundException {
        RecordSchema recordSchema = (RecordSchema)this.recordSchemas.get(schemaName);
        if (recordSchema == null) {
            throw new SchemaNotFoundException("Unable to find schema with name '" + schemaName + "'");
        }
        return recordSchema;
    }

    public RecordSchema retrieveSchema(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        Optional schemaName = schemaIdentifier.getName();
        if (schemaName.isPresent()) {
            return this.retrieveSchemaByName((String)schemaName.get());
        }
        throw new SchemaNotFoundException("This Schema Registry only supports retrieving a schema by name.");
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return schemaFields;
    }
}

