/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.services;

import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.json.schema.JsonSchema;
import org.apache.nifi.json.schema.SchemaVersion;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.JsonSchemaRegistryComponent;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.JsonSchemaRegistry;

@Tags(value={"schema", "registry", "json"})
@CapabilityDescription(value="Provides a service for registering and accessing JSON schemas. One can register a schema as a dynamic property where 'name' represents the schema name and 'value' represents the textual representation of the actual schema following the syntax and semantics of the JSON Schema format. Empty schemas and schemas only consisting of whitespace are not acceptable schemas.The registry is heterogeneous registry as it can store schemas of different schema draft versions. By default the registry is configured to store schemas of Draft 2020-12. When a schema is added, the version which is currently is set, is what the schema is saved as.")
@DynamicProperty(name="Schema Name", value="Schema Content", description="Adds a named schema using the JSON string representation of a JSON schema", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class StandardJsonSchemaRegistry
extends AbstractControllerService
implements JsonSchemaRegistry,
JsonSchemaRegistryComponent {
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Collections.singletonList(SCHEMA_VERSION);
    private final ConcurrentMap<String, JsonSchema> jsonSchemas = new ConcurrentHashMap<String, JsonSchema>();
    private final ConcurrentMap<SchemaVersion, JsonSchemaFactory> schemaFactories = Arrays.stream(SchemaVersion.values()).collect(Collectors.toConcurrentMap(Function.identity(), schemaDraftVersion -> JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)((SpecVersion.VersionFlag)SpecVersion.VersionFlag.fromId((String)schemaDraftVersion.getUri()).get()))));
    private volatile SchemaVersion schemaVersion = SchemaVersion.valueOf((String)SCHEMA_VERSION.getDefaultValue());

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (SCHEMA_VERSION.getName().equals(descriptor.getName()) && !newValue.equals(oldValue)) {
            this.schemaVersion = SchemaVersion.valueOf((String)newValue);
        } else if (descriptor.isDynamic() && StringUtils.isBlank((CharSequence)newValue)) {
            this.jsonSchemas.remove(descriptor.getName());
        } else if (descriptor.isDynamic() && StringUtils.isNotBlank((CharSequence)newValue)) {
            try {
                String schemaName = descriptor.getName();
                JsonSchemaFactory jsonSchemaFactory = (JsonSchemaFactory)this.schemaFactories.get(this.schemaVersion);
                jsonSchemaFactory.getSchema(newValue);
                this.jsonSchemas.put(schemaName, new JsonSchema(this.schemaVersion, newValue));
            }
            catch (Exception e) {
                this.getLogger().debug("Exception thrown when changing value of schema name '{}' from '{}' to '{}'", new Object[]{descriptor.getName(), oldValue, newValue, e});
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        boolean noSchemasConfigured = validationContext.getProperties().keySet().stream().noneMatch(PropertyDescriptor::isDynamic);
        if (noSchemasConfigured) {
            results.add(new ValidationResult.Builder().subject("Supported Dynamic Property Descriptor").valid(false).explanation("There must be at least one JSON schema specified").build());
        } else {
            this.schemaVersion = SchemaVersion.valueOf((String)validationContext.getProperty(JsonSchemaRegistryComponent.SCHEMA_VERSION).getValue());
            validationContext.getProperties().entrySet().stream().filter(entry -> ((PropertyDescriptor)entry.getKey()).isDynamic() && !this.jsonSchemas.containsKey(((PropertyDescriptor)entry.getKey()).getName())).forEach(entry -> {
                String subject = ((PropertyDescriptor)entry.getKey()).getName();
                String input = (String)entry.getValue();
                if (StringUtils.isNotBlank((CharSequence)input)) {
                    try {
                        JsonSchemaFactory jsonSchemaFactory = (JsonSchemaFactory)this.schemaFactories.get(this.schemaVersion);
                        jsonSchemaFactory.getSchema(input);
                    }
                    catch (Exception e) {
                        results.add(new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Not a valid JSON Schema: " + e.getMessage()).build());
                    }
                }
            });
        }
        return results;
    }

    public JsonSchema retrieveSchema(String schemaName) throws SchemaNotFoundException {
        JsonSchema jsonSchema = (JsonSchema)this.jsonSchemas.get(schemaName);
        if (jsonSchema == null) {
            throw new SchemaNotFoundException("Unable to find schema with name '" + schemaName + "'");
        }
        return jsonSchema;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    }
}

