/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.services;

import org.apache.avro.Schema;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class AvroSchemaValidator
implements Validator {
    public ValidationResult validate(String subject, String input, ValidationContext context) {
        if (context.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(true).explanation("Expression Language is present").build();
        }
        try {
            Schema avroSchema = new Schema.Parser().parse(input);
            AvroTypeUtil.createSchema((Schema)avroSchema, (String)input, (SchemaIdentifier)SchemaIdentifier.EMPTY);
            return new ValidationResult.Builder().input(input).subject(subject).valid(true).explanation("Schema is valid").build();
        }
        catch (Exception e) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Not a valid Avro Schema: " + e.getMessage()).build();
        }
    }
}

