/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.redis.state;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.AbstractConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.redis.RedisType;
import org.apache.nifi.redis.state.RedisStateMap;
import org.apache.nifi.redis.state.RedisStateMapJsonSerDe;
import org.apache.nifi.redis.state.RedisStateMapSerDe;
import org.apache.nifi.redis.util.RedisAction;
import org.apache.nifi.redis.util.RedisUtils;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

public class RedisStateProvider
extends AbstractConfigurableComponent
implements StateProvider {
    static final int ENCODING_VERSION = 1;
    public static final PropertyDescriptor KEY_PREFIX = new PropertyDescriptor.Builder().name("Key Prefix").displayName("Key Prefix").description("The prefix for each key stored by this state provider. When sharing a single Redis across multiple NiFi instances, setting a unique value for the Key Prefix will make it easier to identify which instances the keys came from.").required(true).defaultValue("nifi/components/").addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    public static final PropertyDescriptor ENABLE_TLS = new PropertyDescriptor.Builder().name("Enable TLS").displayName("Enable TLS").description("If true, the Redis connection will be configured to use TLS, using the keystore and truststore settings configured in nifi.properties.  This means that a TLS-enabled Redis connection is only possible if the Apache NiFi instance is running in secure mode. If this property is false, an insecure Redis connection will be used even if the Apache NiFi instance is secure.").required(true).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    static final List<PropertyDescriptor> STATE_PROVIDER_PROPERTIES;
    private String identifier;
    private String keyPrefix;
    private ComponentLog logger;
    private PropertyContext context;
    private SSLContext sslContext;
    private volatile boolean enabled;
    private volatile JedisConnectionFactory connectionFactory;
    private final RedisStateMapSerDe serDe = new RedisStateMapJsonSerDe();

    public final void initialize(StateProviderInitializationContext context) {
        this.context = context;
        if (context.getProperty(ENABLE_TLS).asBoolean().booleanValue()) {
            this.sslContext = context.getSSLContext();
        }
        this.identifier = context.getIdentifier();
        this.logger = context.getLogger();
        Object keyPrefix = context.getProperty(KEY_PREFIX).getValue();
        if (!((String)keyPrefix).endsWith("/")) {
            keyPrefix = (String)keyPrefix + "/";
        }
        this.keyPrefix = keyPrefix;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return STATE_PROVIDER_PROPERTIES;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean enableTls;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(RedisUtils.validate(validationContext));
        RedisType redisType = RedisType.fromDisplayName((String)validationContext.getProperty(RedisUtils.REDIS_MODE).getValue());
        if (redisType == RedisType.CLUSTER) {
            results.add(new ValidationResult.Builder().subject(RedisUtils.REDIS_MODE.getDisplayName()).valid(false).explanation(RedisUtils.REDIS_MODE.getDisplayName() + " is configured in clustered mode, and this service requires a non-clustered Redis").build());
        }
        if ((enableTls = validationContext.getProperty(ENABLE_TLS).asBoolean().booleanValue()) && this.sslContext == null) {
            results.add(new ValidationResult.Builder().subject(ENABLE_TLS.getDisplayName()).valid(false).explanation(ENABLE_TLS.getDisplayName() + " is set to 'true', but Apache NiFi is not secured.  This state provider can only use a TLS-enabled connection if a keystore and truststore are provided in nifi.properties.").build());
        }
        return results;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void shutdown() {
        if (this.connectionFactory != null) {
            this.connectionFactory.destroy();
            this.connectionFactory = null;
        }
    }

    public void setState(Map<String, String> state, String componentId) throws IOException {
        this.verifyEnabled();
        StateMap currStateMap = this.getState(componentId);
        boolean updated = false;
        for (int attempted = 0; !updated && attempted < 20; ++attempted) {
            updated = this.replace(currStateMap, state, componentId, true);
        }
        if (!updated) {
            throw new IOException("Unable to update state due to concurrent modifications");
        }
    }

    public StateMap getState(String componentId) throws IOException {
        return this.withConnection(redisConnection -> {
            byte[] key = this.getComponentKey(componentId).getBytes(StandardCharsets.UTF_8);
            byte[] value = redisConnection.get(key);
            RedisStateMap stateMap = this.serDe.deserialize(value);
            if (stateMap == null) {
                return new RedisStateMap.Builder().encodingVersion(1).build();
            }
            return stateMap;
        });
    }

    public boolean replace(StateMap oldValue, Map<String, String> newValue, String componentId) throws IOException {
        return this.replace(oldValue, newValue, componentId, false);
    }

    private boolean replace(StateMap oldValue, Map<String, String> newValue, String componentId, boolean allowReplaceMissing) throws IOException {
        return this.withConnection(redisConnection -> {
            List results;
            long currVersion;
            boolean replaced = false;
            byte[] key = this.getComponentKey(componentId).getBytes(StandardCharsets.UTF_8);
            redisConnection.watch((byte[][])new byte[][]{key});
            long prevVersion = oldValue == null ? -1L : oldValue.getVersion();
            byte[] currValue = redisConnection.get(key);
            RedisStateMap currStateMap = this.serDe.deserialize(currValue);
            long l = currVersion = currStateMap == null ? -1L : currStateMap.getVersion();
            if (!allowReplaceMissing && currVersion == -1L) {
                redisConnection.unwatch();
                return false;
            }
            redisConnection.multi();
            if (prevVersion == currVersion) {
                RedisStateMap newStateMap = new RedisStateMap.Builder().version(currVersion + 1L).encodingVersion(1).stateValues(newValue).build();
                redisConnection.getSet(key, this.serDe.serialize(newStateMap));
            }
            if ((results = redisConnection.exec()).size() > 0) {
                replaced = true;
            }
            return replaced;
        });
    }

    public void clear(String componentId) throws IOException {
        boolean updated = false;
        for (int attempted = 0; !updated && attempted < 20; ++attempted) {
            StateMap currStateMap = this.getState(componentId);
            updated = this.replace(currStateMap, Collections.emptyMap(), componentId, true);
            String result = updated ? "successful" : "unsuccessful";
            this.logger.debug("Attempt # {} to clear state for component {} was {}", new Object[]{attempted + 1, componentId, result});
        }
        if (!updated) {
            throw new IOException("Unable to update state due to concurrent modifications");
        }
    }

    public void onComponentRemoved(String componentId) throws IOException {
        this.withConnection(redisConnection -> {
            byte[] key = this.getComponentKey(componentId).getBytes(StandardCharsets.UTF_8);
            redisConnection.del((byte[][])new byte[][]{key});
            return true;
        });
    }

    public Scope[] getSupportedScopes() {
        return new Scope[]{Scope.CLUSTER};
    }

    private String getComponentKey(String componentId) {
        return this.keyPrefix + componentId;
    }

    private void verifyEnabled() throws IOException {
        if (!this.isEnabled()) {
            throw new IOException("Cannot update or retrieve cluster state because node is no longer connected to a cluster.");
        }
    }

    synchronized RedisConnection getRedis() {
        if (this.connectionFactory == null) {
            this.connectionFactory = RedisUtils.createConnectionFactory(this.context, this.logger, this.sslContext);
        }
        return this.connectionFactory.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withConnection(RedisAction<T> action) throws IOException {
        RedisConnection redisConnection = null;
        try {
            redisConnection = this.getRedis();
            T t = action.execute(redisConnection);
            return t;
        }
        finally {
            if (redisConnection != null) {
                try {
                    redisConnection.close();
                }
                catch (Exception e) {
                    this.logger.warn("Error closing connection: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>(RedisUtils.REDIS_CONNECTION_PROPERTY_DESCRIPTORS);
        props.add(KEY_PREFIX);
        props.add(ENABLE_TLS);
        STATE_PROVIDER_PROPERTIES = Collections.unmodifiableList(props);
    }
}

