/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.pattern;

import java.util.List;
import java.util.Objects;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.pattern.PartialFunctions;
import org.apache.nifi.processor.util.pattern.Put;
import org.apache.nifi.processor.util.pattern.RoutingResult;

public class PutGroup<FC, C extends AutoCloseable, FFG extends PartialFunctions.FlowFileGroup>
extends Put<FC, C> {
    private GroupFlowFiles<FC, C, FFG> groupFlowFiles;
    private PutFlowFiles<FC, C, FFG> putFlowFiles;

    public PutGroup() {
        this.putFlowFile = (context, session, functionContext, connection, inputFlowFile, result) -> {
            throw new UnsupportedOperationException();
        };
    }

    @Override
    protected void validateCompositePattern() {
        super.validateCompositePattern();
        Objects.requireNonNull(this.groupFlowFiles, "GroupFlowFiles function is required.");
    }

    @Override
    public void putFlowFile(Put.PutFlowFile<FC, C> putFlowFile) {
        throw new UnsupportedOperationException("PutFlowFile can not be used with PutGroup pattern. Specify PutFlowFiles instead.");
    }

    public void groupFetchedFlowFiles(GroupFlowFiles<FC, C, FFG> f) {
        this.groupFlowFiles = f;
    }

    public void putFlowFiles(PutFlowFiles<FC, C, FFG> f) {
        this.putFlowFiles = f;
    }

    @Override
    protected void putFlowFiles(ProcessContext context, ProcessSession session, FC functionContext, C connection, List<FlowFile> flowFiles, RoutingResult result) throws ProcessException {
        List<FFG> flowFileGroups = this.groupFlowFiles.apply(context, session, functionContext, connection, flowFiles, result);
        for (PartialFunctions.FlowFileGroup group : flowFileGroups) {
            this.putFlowFiles.apply(context, session, functionContext, connection, group, result);
        }
    }

    @FunctionalInterface
    public static interface GroupFlowFiles<FC, C, FFG> {
        public List<FFG> apply(ProcessContext var1, ProcessSession var2, FC var3, C var4, List<FlowFile> var5, RoutingResult var6) throws ProcessException;
    }

    @FunctionalInterface
    public static interface PutFlowFiles<FC, C, FFG> {
        public void apply(ProcessContext var1, ProcessSession var2, FC var3, C var4, FFG var5, RoutingResult var6) throws ProcessException;
    }
}

