/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.protobuf.schema;

import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.EnumDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.services.protobuf.FieldType;

public class ProtoSchemaParser {
    private final Schema schema;

    public ProtoSchemaParser(Schema schema) {
        this.schema = schema;
    }

    public RecordSchema createSchema(String messageTypeName) {
        MessageType messageType = (MessageType)this.schema.getType(messageTypeName);
        Objects.requireNonNull(messageType, String.format("Message type with name [%s] not found in the provided proto files", messageTypeName));
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        recordFields.addAll(this.processFields(messageType.getDeclaredFields()));
        recordFields.addAll(this.processFields(messageType.getExtensionFields()));
        recordFields.addAll(this.processOneOfFields(messageType));
        return new SimpleRecordSchema(recordFields);
    }

    private List<RecordField> processOneOfFields(MessageType messageType) {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        for (OneOf oneOf : messageType.getOneOfs()) {
            for (Field field : oneOf.getFields()) {
                DataType dataType = this.getDataTypeForField(field.getType());
                recordFields.add(new RecordField(field.getName(), dataType, (Object)field.getDefault(), true));
            }
        }
        return recordFields;
    }

    private List<RecordField> processFields(List<Field> fields) {
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>();
        for (Field field : fields) {
            DataType dataType = this.getDataTypeForField(field.getType());
            if (field.isRepeated()) {
                dataType = RecordFieldType.ARRAY.getArrayDataType(dataType);
            }
            recordFields.add(new RecordField(field.getName(), dataType, (Object)field.getDefault(), !field.isRequired()));
        }
        return recordFields;
    }

    private DataType getDataTypeForField(ProtoType protoType) {
        if (protoType.isScalar()) {
            return this.getDataTypeForScalarField(protoType);
        }
        return this.getDataTypeForCompositeField(protoType);
    }

    private DataType getDataTypeForCompositeField(ProtoType protoType) {
        if (protoType.isMap()) {
            DataType valueType = this.getDataTypeForField(protoType.getValueType());
            return new MapDataType(valueType);
        }
        Type fieldType = this.schema.getType(protoType);
        if (fieldType instanceof MessageType) {
            RecordSchema recordSchema = this.createSchema(protoType.toString());
            return new RecordDataType(recordSchema);
        }
        if (fieldType instanceof EnumType) {
            return new EnumDataType(((EnumType)fieldType).getConstants().stream().map(EnumConstant::getName).collect(Collectors.toList()));
        }
        throw new IllegalStateException("Unknown proto type: " + fieldType);
    }

    private DataType getDataTypeForScalarField(ProtoType protoType) {
        switch (FieldType.findValue(protoType.getSimpleName())) {
            case DOUBLE: {
                return RecordFieldType.DOUBLE.getDataType();
            }
            case FLOAT: {
                return RecordFieldType.FLOAT.getDataType();
            }
            case INT32: 
            case SFIXED32: {
                return RecordFieldType.INT.getDataType();
            }
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                return RecordFieldType.LONG.getDataType();
            }
            case UINT64: 
            case FIXED64: {
                return RecordFieldType.BIGINT.getDataType();
            }
            case BOOL: {
                return RecordFieldType.BOOLEAN.getDataType();
            }
            case STRING: {
                return RecordFieldType.STRING.getDataType();
            }
            case BYTES: {
                return RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.BYTE.getDataType());
            }
        }
        throw new IllegalArgumentException();
    }
}

