/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.services.protobuf.converter;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UnknownFieldSet;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.services.protobuf.FieldType;
import org.apache.nifi.services.protobuf.converter.ProtoField;
import org.apache.nifi.services.protobuf.converter.ValueReader;
import org.apache.nifi.services.protobuf.schema.ProtoSchemaParser;

public class ProtobufDataConverter {
    public static final String MAP_KEY_FIELD_NAME = "key";
    public static final String MAP_VALUE_FIELD_NAME = "value";
    public static final String ANY_TYPE_URL_FIELD_NAME = "type_url";
    public static final String ANY_VALUE_FIELD_NAME = "value";
    public static final String ANY_MESSAGE_TYPE = "google.protobuf.Any";
    private final Schema schema;
    private final String rootMessageType;
    private final RecordSchema rootRecordSchema;
    private final boolean coerceTypes;
    private final boolean dropUnknownFields;
    private boolean containsAnyField = false;

    public ProtobufDataConverter(Schema schema, String messageType, RecordSchema recordSchema, boolean coerceTypes, boolean dropUnknownFields) {
        this.schema = schema;
        this.rootMessageType = messageType;
        this.rootRecordSchema = recordSchema;
        this.coerceTypes = coerceTypes;
        this.dropUnknownFields = dropUnknownFields;
    }

    public MapRecord createRecord(InputStream data) throws IOException {
        MessageType rootMessageType = (MessageType)this.schema.getType(this.rootMessageType);
        Objects.requireNonNull(rootMessageType, String.format("Message with name [%s] not found in the provided proto files", this.rootMessageType));
        MapRecord record = this.createRecord(rootMessageType, ByteString.readFrom((InputStream)data), this.rootRecordSchema);
        if (this.containsAnyField) {
            record.regenerateSchema();
        }
        return record;
    }

    private MapRecord createRecord(MessageType messageType, ByteString data, RecordSchema recordSchema) throws InvalidProtocolBufferException {
        UnknownFieldSet unknownFieldSet = UnknownFieldSet.parseFrom((ByteString)data);
        if (ANY_MESSAGE_TYPE.equals(messageType.getType().toString())) {
            this.containsAnyField = true;
            return this.handleAnyField(unknownFieldSet);
        }
        Map<String, Object> fieldValues = this.processMessageFields(messageType, unknownFieldSet);
        return new MapRecord(recordSchema, fieldValues, false, this.dropUnknownFields);
    }

    private Map<String, Object> processMessageFields(MessageType messageType, UnknownFieldSet unknownFieldSet) throws InvalidProtocolBufferException {
        HashMap<String, Object> recordValues = new HashMap<String, Object>();
        for (Field field : messageType.getDeclaredFields()) {
            this.collectFieldValue(recordValues, new ProtoField(field), unknownFieldSet.getField(field.getTag()));
        }
        for (Field field : messageType.getExtensionFields()) {
            this.collectFieldValue(recordValues, new ProtoField(field), unknownFieldSet.getField(field.getTag()));
        }
        for (OneOf oneOf : messageType.getOneOfs()) {
            for (Field field : oneOf.getFields()) {
                this.collectFieldValue(recordValues, new ProtoField(field), unknownFieldSet.getField(field.getTag()));
            }
        }
        return recordValues;
    }

    private void collectFieldValue(Map<String, Object> fieldNameToConvertedValue, ProtoField protoField, UnknownFieldSet.Field unknownField) throws InvalidProtocolBufferException {
        Optional<Object> fieldValue = this.convertFieldValues(protoField, unknownField);
        fieldValue.ifPresent(value -> fieldNameToConvertedValue.put(protoField.getFieldName(), value));
    }

    private Optional<Object> convertFieldValues(ProtoField protoField, UnknownFieldSet.Field unknownField) throws InvalidProtocolBufferException {
        if (!unknownField.getLengthDelimitedList().isEmpty()) {
            if (protoField.isRepeatable() && !this.isLengthDelimitedType(protoField)) {
                return Optional.of(this.convertRepeatedFields(protoField, unknownField.getLengthDelimitedList()));
            }
            return Optional.of(this.convertLengthDelimitedFields(protoField, unknownField.getLengthDelimitedList()));
        }
        if (!unknownField.getFixed32List().isEmpty()) {
            return Optional.of(this.convertFixed32Fields(protoField, unknownField.getFixed32List()));
        }
        if (!unknownField.getFixed64List().isEmpty()) {
            return Optional.of(this.convertFixed64Fields(protoField, unknownField.getFixed64List()));
        }
        if (!unknownField.getVarintList().isEmpty()) {
            return Optional.of(this.convertVarintFields(protoField, unknownField.getVarintList()));
        }
        return Optional.empty();
    }

    private Object convertRepeatedFields(ProtoField protoField, List<ByteString> fieldValues) {
        CodedInputStream inputStream = fieldValues.get(0).newCodedInput();
        ProtoType protoType = protoField.getProtoType();
        if (protoType.isScalar()) {
            ValueReader<CodedInputStream, Object> valueReader;
            switch (FieldType.findValue(protoType.getSimpleName())) {
                case BOOL: {
                    valueReader = CodedInputStream::readBool;
                    break;
                }
                case INT32: {
                    valueReader = CodedInputStream::readInt32;
                    break;
                }
                case UINT32: {
                    valueReader = value -> Integer.toUnsignedLong(value.readUInt32());
                    break;
                }
                case SINT32: {
                    valueReader = CodedInputStream::readSInt32;
                    break;
                }
                case INT64: {
                    valueReader = CodedInputStream::readInt64;
                    break;
                }
                case UINT64: {
                    valueReader = value -> new BigInteger(TextFormat.unsignedToString((long)value.readUInt64()));
                    break;
                }
                case SINT64: {
                    valueReader = CodedInputStream::readSInt64;
                    break;
                }
                case FIXED32: {
                    valueReader = value -> Integer.toUnsignedLong(value.readFixed32());
                    break;
                }
                case SFIXED32: {
                    valueReader = CodedInputStream::readSFixed32;
                    break;
                }
                case FIXED64: {
                    valueReader = value -> new BigInteger(TextFormat.unsignedToString((long)value.readFixed64()));
                    break;
                }
                case SFIXED64: {
                    valueReader = CodedInputStream::readSFixed64;
                    break;
                }
                case FLOAT: {
                    valueReader = CodedInputStream::readFloat;
                    break;
                }
                case DOUBLE: {
                    valueReader = CodedInputStream::readDouble;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected type [%s] was received for field [%s]", protoType.getSimpleName(), protoField.getFieldName()));
                }
            }
            return this.resolveFieldValue(protoField, this.processRepeatedValues(inputStream, valueReader), value -> value);
        }
        List<Integer> values = this.processRepeatedValues(inputStream, CodedInputStream::readEnum);
        return this.resolveFieldValue(protoField, values, value -> this.convertEnum((Integer)value, protoType));
    }

    private Object convertLengthDelimitedFields(ProtoField protoField, List<ByteString> values) throws InvalidProtocolBufferException {
        Function<ByteString, Object> valueConverter;
        block6: {
            ProtoType protoType;
            block5: {
                protoType = protoField.getProtoType();
                if (!protoType.isScalar()) break block5;
                switch (FieldType.findValue(protoType.getSimpleName())) {
                    case STRING: {
                        valueConverter = ByteString::toStringUtf8;
                        break block6;
                    }
                    case BYTES: {
                        valueConverter = ByteString::toByteArray;
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Incompatible value was received for field [%s], [%s] is not LengthDelimited field type", protoField.getFieldName(), protoType.getSimpleName()));
                    }
                }
            }
            if (protoType.isMap()) {
                return this.createMap(protoType, values);
            }
            MessageType messageType = (MessageType)this.schema.getType(protoType);
            Objects.requireNonNull(messageType, String.format("Message type with name [%s] not found in the provided proto files", protoType));
            valueConverter = value -> {
                try {
                    Optional<DataType> recordDataType = this.rootRecordSchema.getDataType(protoField.getFieldName());
                    if (protoField.isRepeatable()) {
                        ArrayDataType arrayDataType = (ArrayDataType)recordDataType.get();
                        recordDataType = Optional.ofNullable(arrayDataType.getElementType());
                    }
                    RecordSchema recordSchema = recordDataType.map(dataType -> ((RecordDataType)dataType).getChildSchema()).orElse(this.generateRecordSchema(messageType.getType().toString()));
                    return this.createRecord(messageType, (ByteString)value, recordSchema);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new IllegalStateException("Failed to create record from the provided input data for field " + protoField.getFieldName(), e);
                }
            };
        }
        return this.resolveFieldValue(protoField, values, valueConverter);
    }

    private Object convertFixed32Fields(ProtoField protoField, List<Integer> values) {
        Function<Integer, Object> valueConverter;
        String typeName = protoField.getProtoType().getSimpleName();
        switch (FieldType.findValue(typeName)) {
            case FIXED32: {
                valueConverter = Integer::toUnsignedLong;
                break;
            }
            case SFIXED32: {
                valueConverter = value -> value;
                break;
            }
            case FLOAT: {
                valueConverter = Float::intBitsToFloat;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Incompatible value was received for field [%s], [%s] is not Fixed32 field type", protoField.getFieldName(), typeName));
            }
        }
        return this.resolveFieldValue(protoField, values, valueConverter);
    }

    private Object convertFixed64Fields(ProtoField protoField, List<Long> values) {
        Function<Long, Object> valueConverter;
        String typeName = protoField.getProtoType().getSimpleName();
        switch (FieldType.findValue(typeName)) {
            case FIXED64: {
                valueConverter = value -> new BigInteger(TextFormat.unsignedToString((long)value));
                break;
            }
            case SFIXED64: {
                valueConverter = value -> value;
                break;
            }
            case DOUBLE: {
                valueConverter = Double::longBitsToDouble;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Incompatible value was received for field [%s], [%s] is not Fixed64 field type", protoField.getFieldName(), typeName));
            }
        }
        return this.resolveFieldValue(protoField, values, valueConverter);
    }

    private Object convertVarintFields(ProtoField protoField, List<Long> values) {
        Function<Long, Object> valueConverter;
        block9: {
            ProtoType protoType;
            block8: {
                protoType = protoField.getProtoType();
                if (!protoType.isScalar()) break block8;
                switch (FieldType.findValue(protoType.getSimpleName())) {
                    case BOOL: {
                        valueConverter = value -> value.equals(1L);
                        break block9;
                    }
                    case INT32: 
                    case SFIXED32: {
                        valueConverter = Long::intValue;
                        break block9;
                    }
                    case UINT32: 
                    case INT64: 
                    case SFIXED64: {
                        valueConverter = value -> value;
                        break block9;
                    }
                    case UINT64: {
                        valueConverter = value -> new BigInteger(TextFormat.unsignedToString((long)value));
                        break block9;
                    }
                    case SINT32: {
                        valueConverter = value -> CodedInputStream.decodeZigZag32((int)value.intValue());
                        break block9;
                    }
                    case SINT64: {
                        valueConverter = CodedInputStream::decodeZigZag64;
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Incompatible value was received for field [%s], [%s] is not Varint field type", protoField.getFieldName(), protoType.getSimpleName()));
                    }
                }
            }
            valueConverter = value -> this.convertEnum(value.intValue(), protoType);
        }
        return this.resolveFieldValue(protoField, values, valueConverter);
    }

    private <T> Object resolveFieldValue(ProtoField protoField, List<T> values, Function<T, Object> valueConverter) {
        Optional recordField;
        List resultValues = values.stream().map(valueConverter).collect(Collectors.toList());
        if (this.coerceTypes && (recordField = this.rootRecordSchema.getField(protoField.getFieldName())).isPresent()) {
            DataType dataType;
            if (protoField.isRepeatable()) {
                ArrayDataType arrayDataType = (ArrayDataType)((RecordField)recordField.get()).getDataType();
                dataType = arrayDataType.getElementType();
            } else {
                dataType = ((RecordField)recordField.get()).getDataType();
            }
            resultValues = resultValues.stream().map(value -> DataTypeUtils.convertType((Object)value, (DataType)dataType, (String)((RecordField)recordField.get()).getFieldName())).collect(Collectors.toList());
        }
        if (!protoField.isRepeatable()) {
            return resultValues.get(0);
        }
        return resultValues.toArray();
    }

    private Map<String, Object> createMap(ProtoType protoType, List<ByteString> data) throws InvalidProtocolBufferException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        for (ByteString entry : data) {
            UnknownFieldSet unknownFieldSet = UnknownFieldSet.parseFrom((ByteString)entry);
            HashMap<String, Object> mapEntry = new HashMap<String, Object>();
            this.collectFieldValue(mapEntry, new ProtoField(MAP_KEY_FIELD_NAME, protoType.getKeyType()), unknownFieldSet.getField(1));
            this.collectFieldValue(mapEntry, new ProtoField("value", protoType.getValueType()), unknownFieldSet.getField(2));
            mapResult.put(String.valueOf(mapEntry.get(MAP_KEY_FIELD_NAME)), mapEntry.get("value"));
        }
        return mapResult;
    }

    private String convertEnum(Integer value, ProtoType protoType) {
        EnumType enumType = (EnumType)this.schema.getType(protoType);
        Objects.requireNonNull(enumType, String.format("Enum with name [%s] not found in the provided proto files", protoType));
        return enumType.constant(value.intValue()).getName();
    }

    private MapRecord handleAnyField(UnknownFieldSet unknownFieldSet) throws InvalidProtocolBufferException {
        HashMap<String, Object> recordValues = new HashMap<String, Object>();
        this.collectFieldValue(recordValues, new ProtoField(ANY_TYPE_URL_FIELD_NAME, ProtoType.STRING), unknownFieldSet.getField(1));
        this.collectFieldValue(recordValues, new ProtoField("value", ProtoType.BYTES), unknownFieldSet.getField(2));
        String typeName = String.valueOf(recordValues.get(ANY_TYPE_URL_FIELD_NAME));
        UnknownFieldSet anyFieldSet = UnknownFieldSet.parseFrom((byte[])((byte[])recordValues.get("value")));
        MessageType messageType = (MessageType)this.schema.getType(this.getQualifiedTypeName(typeName));
        Objects.requireNonNull(messageType, String.format("Message type with name [%s] not found in the provided proto files", typeName));
        return new MapRecord(this.generateRecordSchema(typeName), this.processMessageFields(messageType, anyFieldSet), false, this.dropUnknownFields);
    }

    private RecordSchema generateRecordSchema(String typeName) {
        ProtoSchemaParser schemaParser = new ProtoSchemaParser(this.schema);
        return schemaParser.createSchema(this.getQualifiedTypeName(typeName));
    }

    private String getQualifiedTypeName(String typeName) {
        return typeName.substring(typeName.lastIndexOf(47) + 1);
    }

    private <T> List<T> processRepeatedValues(CodedInputStream input, ValueReader<CodedInputStream, T> valueReader) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            while (input.getBytesUntilLimit() > 0) {
                result.add(valueReader.apply(input));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse repeated field", e);
        }
        return result;
    }

    private boolean isLengthDelimitedType(ProtoField protoField) {
        boolean lengthDelimitedScalarType = false;
        ProtoType protoType = protoField.getProtoType();
        if (protoType.isScalar()) {
            FieldType fieldType = FieldType.findValue(protoType.getSimpleName());
            lengthDelimitedScalarType = fieldType.equals((Object)FieldType.STRING) || fieldType.equals((Object)FieldType.BYTES);
        }
        return lengthDelimitedScalarType || this.schema.getType(protoType) instanceof MessageType;
    }
}

