/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.nifi.util.mapr.MapRComponentsUtils;

public final class MapRPropertiesUtils {
    public static final String MAPR_HADOOP_PROPERTY_PROVIDER = "$HadoopProvider";
    public static final String SERVER_TRUSTSTORE_PASSWORD = "ssl.server.truststore.password";
    public static final String SERVER_TRUSTSTORE_LOCATION = "ssl.server.truststore.location";
    public static final String SERVER_TRUSTSTORE_TYPE = "ssl.server.truststore.type";
    public static final String SERVER_KEYSTORE_KEY_PASSWORD = "ssl.server.keystore.keypassword";
    public static final String SERVER_KEYSTORE_PASSWORD = "ssl.server.keystore.password";
    public static final String SERVER_KEYSTORE_LOCATION = "ssl.server.keystore.location";
    public static final String SERVER_KEYSTORE_TYPE = "ssl.server.keystore.type";
    private static final String PASSWORD_SUFFIX = "password";
    private static final String HADOOP_COMPONENT_NAME = "hadoop";
    private static final java.nio.file.Path HADOOP_CONF_PATH = MapRPropertiesUtils.getHadoopConfFolder();
    private static final String HADOOP_HOME_PROPERTY = "hadoop.home.dir";
    private static final String HADOOP_CONF_INTERNAL_PATH = "etc/hadoop";
    private static final String HADOOP_CONF_CORE_SITE_XML = "core-site.xml";
    private static final String HADOOP_CONF_SSL_SERVER_XML = "ssl-server.xml";
    private static final String HADOOP_CONF_SSL_CLIENT_XML = "ssl-client.xml";
    private static final String HADOOP_CONF_HDFS_SITE_XML = "hdfs-site.xml";
    private static volatile Configuration hadoopConf = null;
    private static final Map<String, String> mapNifiToHadoopProperties = new HashMap<String, String>();
    private static final List<String> hadoopClientConfigs = new ArrayList<String>();

    public static List<String> getHadoopClientConfigs() {
        return new ArrayList<String>(hadoopClientConfigs);
    }

    public static String getHadoopProperty(String key) {
        String hadoopKey = mapNifiToHadoopProperties.get(key);
        if (hadoopKey == null) {
            throw new RuntimeException(String.format("No mapping for property '%s'", key));
        }
        if (hadoopKey.toLowerCase().endsWith(PASSWORD_SUFFIX)) {
            try {
                return MapRPropertiesUtils.getPassword(hadoopKey);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to get property '%s'", hadoopKey), e);
            }
        }
        return MapRPropertiesUtils.getProperty(hadoopKey);
    }

    public static String getProperty(String property) {
        return MapRPropertiesUtils.getHadoopConf().get(property);
    }

    public static String getPassword(String property) throws IOException {
        char[] data = MapRPropertiesUtils.getHadoopConf().getPassword(property);
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    private static synchronized Configuration getHadoopConf() {
        if (hadoopConf == null) {
            hadoopConf = new Configuration();
            hadoopConf.addResource(new Path(HADOOP_CONF_PATH.toString(), HADOOP_CONF_CORE_SITE_XML));
            hadoopConf.addResource(new Path(HADOOP_CONF_PATH.toString(), HADOOP_CONF_SSL_SERVER_XML));
        }
        return hadoopConf;
    }

    private static java.nio.file.Path getHadoopConfFolder() {
        java.nio.file.Path hadoopFolder;
        try {
            hadoopFolder = MapRComponentsUtils.getComponentFolder((String)HADOOP_COMPONENT_NAME);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MapRPropertiesUtils.setHadoopHomeIfNotSet(hadoopFolder.toString());
        return hadoopFolder.resolve(HADOOP_CONF_INTERNAL_PATH);
    }

    private static void setHadoopHomeIfNotSet(String hadoopFolder) {
        String defaultHadoopHome = System.getProperty(HADOOP_HOME_PROPERTY, "");
        if (defaultHadoopHome.isEmpty()) {
            System.setProperty(HADOOP_HOME_PROPERTY, hadoopFolder);
        }
    }

    static {
        mapNifiToHadoopProperties.put("nifi.security.keystore", SERVER_KEYSTORE_LOCATION);
        mapNifiToHadoopProperties.put("nifi.security.keystoreType", SERVER_KEYSTORE_TYPE);
        mapNifiToHadoopProperties.put("nifi.security.keystorePasswd", SERVER_KEYSTORE_PASSWORD);
        mapNifiToHadoopProperties.put("nifi.security.keyPasswd", SERVER_KEYSTORE_KEY_PASSWORD);
        mapNifiToHadoopProperties.put("nifi.security.truststore", SERVER_TRUSTSTORE_LOCATION);
        mapNifiToHadoopProperties.put("nifi.security.truststoreType", SERVER_TRUSTSTORE_TYPE);
        mapNifiToHadoopProperties.put("nifi.security.truststorePasswd", SERVER_TRUSTSTORE_PASSWORD);
        hadoopClientConfigs.add(HADOOP_CONF_PATH.resolve(HADOOP_CONF_HDFS_SITE_XML).toString());
        hadoopClientConfigs.add(HADOOP_CONF_PATH.resolve(HADOOP_CONF_SSL_CLIENT_XML).toString());
    }
}

