/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hpe;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpePropertiesURLClassLoader
extends URLClassLoader {
    private static final String STANDARD_DIRECTORY = "lib/hpe-properties";
    private static final ClassLoader CONTEXT_CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    private static final Logger logger = LoggerFactory.getLogger(HpePropertiesURLClassLoader.class);

    public HpePropertiesURLClassLoader() {
        this(CONTEXT_CLASS_LOADER);
    }

    public HpePropertiesURLClassLoader(ClassLoader parentClassLoader) {
        super(HpePropertiesURLClassLoader.getPropertyProtectionUrls(), parentClassLoader);
    }

    private static URL[] getPropertyProtectionUrls() {
        Path standardDirectory = Paths.get(STANDARD_DIRECTORY, new String[0]);
        if (Files.exists(standardDirectory, new LinkOption[0])) {
            URL[] uRLArray;
            block9: {
                Stream<Path> files = Files.list(standardDirectory);
                try {
                    uRLArray = (URL[])files.map(Path::toUri).map(uri -> {
                        try {
                            return uri.toURL();
                        }
                        catch (MalformedURLException e) {
                            throw new UncheckedIOException(String.format("Processing HPE properties libraries failed [%s]", standardDirectory), e);
                        }
                    }).toArray(URL[]::new);
                    if (files == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(String.format("Loading HPE properties libraries failed [%s]", standardDirectory), e);
                    }
                }
                files.close();
            }
            return uRLArray;
        }
        logger.error("HPE configuration libraries directory [{}] not found", (Object)standardDirectory);
        return new URL[0];
    }
}

