/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.nifi.properties.ApplicationPropertiesProtector;
import org.apache.nifi.properties.ProtectedProperties;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.SensitivePropertyProtector;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProtectedNiFiProperties
extends NiFiProperties
implements ProtectedProperties<NiFiProperties>,
SensitivePropertyProtector<ProtectedNiFiProperties, NiFiProperties> {
    private static final Logger logger = LoggerFactory.getLogger(ProtectedNiFiProperties.class);
    private SensitivePropertyProtector<ProtectedNiFiProperties, NiFiProperties> propertyProtectionDelegate;
    private NiFiProperties applicationProperties;
    public static final String ADDITIONAL_SENSITIVE_PROPERTIES_KEY = "nifi.sensitive.props.additional.keys";
    public static final List<String> DEFAULT_SENSITIVE_PROPERTIES = new ArrayList<String>(Arrays.asList("nifi.security.keyPasswd", "nifi.security.keystorePasswd", "nifi.security.truststorePasswd", "nifi.sensitive.props.key", "nifi.provenance.repository.encryption.key", "nifi.provenance.repository.encryption.key.provider.password", "nifi.flowfile.repository.encryption.key.provider.password", "nifi.content.repository.encryption.key.provider.password", "nifi.repository.encryption.key.provider.keystore.password", "nifi.security.user.oidc.client.secret"));

    public ProtectedNiFiProperties() {
        this(new NiFiProperties());
    }

    public ProtectedNiFiProperties(NiFiProperties props) {
        this.applicationProperties = props;
        this.propertyProtectionDelegate = new ApplicationPropertiesProtector((ProtectedProperties)this);
        logger.debug("Loaded {} properties (including {} protection schemes) into ProtectedNiFiProperties", (Object)this.getApplicationProperties().getPropertyKeys().size(), (Object)this.getProtectedPropertyKeys().size());
    }

    public ProtectedNiFiProperties(Properties rawProps) {
        this(new NiFiProperties(rawProps));
    }

    public String getAdditionalSensitivePropertiesKeys() {
        return this.getProperty(this.getAdditionalSensitivePropertiesKeysName());
    }

    public String getAdditionalSensitivePropertiesKeysName() {
        return ADDITIONAL_SENSITIVE_PROPERTIES_KEY;
    }

    public List<String> getDefaultSensitiveProperties() {
        return DEFAULT_SENSITIVE_PROPERTIES;
    }

    public NiFiProperties getApplicationProperties() {
        if (this.applicationProperties == null) {
            this.applicationProperties = new NiFiProperties();
        }
        return this.applicationProperties;
    }

    public NiFiProperties createApplicationProperties(Properties rawProperties) {
        return new NiFiProperties(rawProperties);
    }

    public String getProperty(String key) {
        return this.getApplicationProperties().getProperty(key);
    }

    public Set<String> getPropertyKeys() {
        return this.propertyProtectionDelegate.getPropertyKeys();
    }

    public int size() {
        return this.propertyProtectionDelegate.size();
    }

    public Set<String> getPropertyKeysIncludingProtectionSchemes() {
        return this.propertyProtectionDelegate.getPropertyKeysIncludingProtectionSchemes();
    }

    public List<String> getSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getSensitivePropertyKeys();
    }

    public List<String> getPopulatedSensitivePropertyKeys() {
        return this.propertyProtectionDelegate.getPopulatedSensitivePropertyKeys();
    }

    public boolean hasProtectedKeys() {
        return this.propertyProtectionDelegate.hasProtectedKeys();
    }

    public Map<String, String> getProtectedPropertyKeys() {
        return this.propertyProtectionDelegate.getProtectedPropertyKeys();
    }

    public boolean isPropertySensitive(String key) {
        return this.propertyProtectionDelegate.isPropertySensitive(key);
    }

    public boolean isPropertyProtected(String key) {
        return this.propertyProtectionDelegate.isPropertyProtected(key);
    }

    public NiFiProperties getUnprotectedProperties() throws SensitivePropertyProtectionException {
        return (NiFiProperties)this.propertyProtectionDelegate.getUnprotectedProperties();
    }

    public void addSensitivePropertyProvider(SensitivePropertyProvider sensitivePropertyProvider) {
        this.propertyProtectionDelegate.addSensitivePropertyProvider(sensitivePropertyProvider);
    }

    public static int countProtectedProperties(NiFiProperties plainProperties) {
        return new ProtectedNiFiProperties(plainProperties).getProtectedPropertyKeys().size();
    }

    public static int countSensitiveProperties(NiFiProperties plainProperties) {
        return new ProtectedNiFiProperties(plainProperties).getSensitivePropertyKeys().size();
    }

    public String toString() {
        return String.format("%s Size [%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.size());
    }
}

