/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.excel.CellFieldTypeReader;
import org.apache.nifi.excel.ExcelReader;
import org.apache.nifi.excel.ExcelRecordReaderConfiguration;
import org.apache.nifi.excel.ExcelUtils;
import org.apache.nifi.excel.RowIterator;
import org.apache.nifi.excel.StandardCellFieldTypeReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schema.inference.FieldTypeInference;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;

public class ExcelHeaderSchemaStrategy
implements SchemaAccessStrategy {
    private static final Set<SchemaField> schemaFields = EnumSet.noneOf(SchemaField.class);
    static final int NUM_ROWS_TO_DETERMINE_TYPES = 10;
    static final AllowableValue USE_STARTING_ROW = new AllowableValue("Use Starting Row", "Use Starting Row", "The configured first row of the Excel file is a header line that contains the names of the columns. The schema will be derived by using the column names in the header and the following 10 rows to determine the type(s) of each column");
    private final PropertyContext context;
    private final ComponentLog logger;
    private final CellFieldTypeReader cellFieldTypeReader;
    private final DataFormatter dataFormatter;

    public ExcelHeaderSchemaStrategy(PropertyContext context, ComponentLog logger, TimeValueInference timeValueInference) {
        this.context = context;
        this.logger = logger;
        this.cellFieldTypeReader = new StandardCellFieldTypeReader(timeValueInference);
        this.dataFormatter = new DataFormatter();
    }

    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException {
        if (this.context == null) {
            throw new SchemaNotFoundException("Schema Access Strategy intended only for validation purposes and cannot obtain schema");
        }
        String requiredSheetsDelimited = this.context.getProperty(ExcelReader.REQUIRED_SHEETS).evaluateAttributeExpressions(variables).getValue();
        List<String> requiredSheets = ExcelReader.getRequiredSheets(requiredSheetsDelimited);
        Integer rawFirstRow = this.context.getProperty(ExcelReader.STARTING_ROW).evaluateAttributeExpressions(variables).asInteger();
        int firstRow = rawFirstRow == null ? NumberUtils.toInt((String)ExcelReader.STARTING_ROW.getDefaultValue()) : rawFirstRow;
        int zeroBasedFirstRow = ExcelReader.getZeroBasedIndex(firstRow);
        String password = this.context.getProperty(ExcelReader.PASSWORD).getValue();
        ExcelRecordReaderConfiguration configuration = new ExcelRecordReaderConfiguration.Builder().withRequiredSheets(requiredSheets).withFirstRow(zeroBasedFirstRow).withPassword(password).build();
        RowIterator rowIterator = new RowIterator(contentStream, configuration, this.logger);
        LinkedHashMap<String, FieldTypeInference> typeMap = new LinkedHashMap<String, FieldTypeInference>();
        List<String> fieldNames = null;
        int index = 0;
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            if (index == 0) {
                fieldNames = this.getFieldNames(firstRow, row);
            } else {
                if (index > 10) break;
                this.inferSchema(row, fieldNames, typeMap);
            }
            ++index;
        }
        if (typeMap.isEmpty()) {
            String message = String.format("Failed to infer schema from empty first %d rows", 10);
            throw new SchemaNotFoundException(message);
        }
        return this.createSchema(typeMap);
    }

    private List<String> getFieldNames(int firstRowIndex, Row row) throws SchemaNotFoundException {
        if (!ExcelUtils.hasCells(row)) {
            throw new SchemaNotFoundException(String.format("Field names could not be determined from configured header row %s, as this row has no cells with data", firstRowIndex));
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int index = 0; index < row.getLastCellNum(); ++index) {
            Cell cell = row.getCell(index);
            String fieldName = this.dataFormatter.formatCellValue(cell);
            if (fieldName == null || fieldName.isEmpty()) {
                fieldNames.add("column_" + index);
                continue;
            }
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    private void inferSchema(Row row, List<String> fieldNames, Map<String, FieldTypeInference> typeMap) throws SchemaNotFoundException {
        if (ExcelUtils.hasCells(row)) {
            if (row.getLastCellNum() > fieldNames.size()) {
                throw new SchemaNotFoundException(String.format("Row %s has %s cells, more than the expected %s number of field names", row.getRowNum(), row.getLastCellNum(), fieldNames.size()));
            }
            IntStream.range(0, row.getLastCellNum()).forEach(index -> {
                Cell cell = row.getCell(index);
                String fieldName = (String)fieldNames.get(index);
                this.cellFieldTypeReader.inferCellFieldType(cell, fieldName, typeMap);
            });
        }
    }

    private RecordSchema createSchema(Map<String, FieldTypeInference> inferences) {
        List recordFields = inferences.entrySet().stream().map(entry -> new RecordField((String)entry.getKey(), ((FieldTypeInference)entry.getValue()).toDataType(), true)).collect(Collectors.toList());
        return new SimpleRecordSchema(recordFields);
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return schemaFields;
    }
}

