/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.excel.ExcelRecordReaderConfiguration;
import org.apache.nifi.excel.ExcelUtils;
import org.apache.nifi.excel.RowIterator;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;

public class ExcelRecordReader
implements RecordReader {
    private final RowIterator rowIterator;
    private final RecordSchema schema;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;
    private final String dateFormat;
    private final String timeFormat;
    private final String timestampFormat;

    public ExcelRecordReader(ExcelRecordReaderConfiguration configuration, InputStream inputStream, ComponentLog logger) throws MalformedRecordException {
        this.schema = configuration.getSchema();
        if (StringUtils.isEmpty((CharSequence)configuration.getDateFormat())) {
            this.dateFormat = null;
            this.LAZY_DATE_FORMAT = null;
        } else {
            this.dateFormat = configuration.getDateFormat();
            this.LAZY_DATE_FORMAT = () -> DataTypeUtils.getDateFormat((String)this.dateFormat);
        }
        if (StringUtils.isEmpty((CharSequence)configuration.getTimeFormat())) {
            this.timeFormat = null;
            this.LAZY_TIME_FORMAT = null;
        } else {
            this.timeFormat = configuration.getTimeFormat();
            this.LAZY_TIME_FORMAT = () -> DataTypeUtils.getDateFormat((String)this.timeFormat);
        }
        if (StringUtils.isEmpty((CharSequence)configuration.getTimestampFormat())) {
            this.timestampFormat = null;
            this.LAZY_TIMESTAMP_FORMAT = null;
        } else {
            this.timestampFormat = configuration.getTimestampFormat();
            this.LAZY_TIMESTAMP_FORMAT = () -> DataTypeUtils.getDateFormat((String)this.timestampFormat);
        }
        try {
            this.rowIterator = new RowIterator(inputStream, configuration, logger);
        }
        catch (RuntimeException e) {
            throw new MalformedRecordException("Read initial Record from Excel XLSX failed", (Throwable)e);
        }
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws MalformedRecordException {
        Row currentRow = null;
        try {
            if (this.rowIterator.hasNext()) {
                currentRow = this.rowIterator.next();
                Map<String, Object> currentRowValues = this.getCurrentRowValues(currentRow, coerceTypes, dropUnknownFields);
                return new MapRecord(this.schema, currentRowValues);
            }
        }
        catch (Exception e) {
            String exceptionMessage = "Read next Record from Excel XLSX failed";
            if (currentRow != null) {
                exceptionMessage = String.format("%s on row %s in sheet %s", exceptionMessage, currentRow.getRowNum(), currentRow.getSheet().getSheetName());
            }
            throw new MalformedRecordException(exceptionMessage, (Throwable)e);
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public void close() throws IOException {
        this.rowIterator.close();
    }

    private Map<String, Object> getCurrentRowValues(Row currentRow, boolean coerceTypes, boolean dropUnknownFields) {
        List recordFields = this.schema.getFields();
        LinkedHashMap<String, Object> currentRowValues = new LinkedHashMap<String, Object>();
        if (ExcelUtils.hasCells(currentRow)) {
            IntStream.range(0, currentRow.getLastCellNum()).forEach(index -> {
                Cell cell = currentRow.getCell(index);
                if (index >= recordFields.size()) {
                    if (!dropUnknownFields) {
                        Object cellValue = ExcelRecordReader.getCellValue(cell);
                        currentRowValues.put("unknown_field_index_" + index, cellValue);
                    }
                } else {
                    RecordField recordField = (RecordField)recordFields.get(index);
                    String fieldName = recordField.getFieldName();
                    DataType dataType = recordField.getDataType();
                    Object cellValue = ExcelRecordReader.getCellValue(cell);
                    Object value = coerceTypes ? this.convert(cellValue, dataType, fieldName) : this.convertSimpleIfPossible(cellValue, dataType, fieldName);
                    currentRowValues.put(fieldName, value);
                }
            });
        }
        return currentRowValues;
    }

    private static Object getCellValue(Cell cell) {
        Object cellValue;
        if (cell == null) {
            cellValue = null;
        } else {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case _NONE: 
                case BLANK: 
                case ERROR: 
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    cellValue = DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() : Double.valueOf(cell.getNumericCellValue());
                    break;
                }
                case BOOLEAN: {
                    cellValue = cell.getBooleanCellValue();
                    break;
                }
                case FORMULA: {
                    cellValue = ExcelRecordReader.getFormulaCellValue(cell);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return cellValue;
    }

    private static Object getFormulaCellValue(Cell cell) {
        CellType formulaResultType = cell.getCachedFormulaResultType();
        switch (formulaResultType) {
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case ERROR: 
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() : Double.valueOf(cell.getNumericCellValue());
            }
        }
        return null;
    }

    private Object convert(Object value, DataType dataType, String fieldName) {
        if (value == null || dataType == null) {
            return value;
        }
        return DataTypeUtils.convertType((Object)value, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
    }

    private Object convertSimpleIfPossible(Object value, DataType dataType, String fieldName) {
        if (value == null || dataType == null) {
            return value;
        }
        switch (dataType.getFieldType()) {
            case STRING: {
                return value;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case BYTE: 
            case CHAR: 
            case SHORT: {
                if (!DataTypeUtils.isCompatibleDataType((Object)value, (DataType)dataType)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
            case DATE: {
                if (!DataTypeUtils.isDateTypeCompatible((Object)value, (String)this.dateFormat)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
            case TIME: {
                if (!DataTypeUtils.isTimeTypeCompatible((Object)value, (String)this.timeFormat)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
            case TIMESTAMP: {
                if (!DataTypeUtils.isTimestampTypeCompatible((Object)value, (String)this.timestampFormat)) break;
                return DataTypeUtils.convertType((Object)value, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
        }
        return value;
    }
}

