/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.poi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.csv.CSVUtils;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Tags(value={"excel", "csv", "poi"})
@CapabilityDescription(value="Consumes a Microsoft Excel document and converts each worksheet to csv. Each sheet from the incoming Excel document will generate a new Flowfile that will be output from this processor. Each output Flowfile's contents will be formatted as a csv file where the each row from the excel sheet is output as a newline in the csv file. This processor is currently only capable of processing .xlsx (XSSF 2007 OOXML file format) Excel documents and not older .xls (HSSF '97(-2007) file format) documents. This processor also expects well formatted CSV content and will not escape cell's containing invalid content such as newlines or additional commas.")
@WritesAttributes(value={@WritesAttribute(attribute="sheetname", description="The name of the Excel sheet that this particular row of data came from in the Excel document"), @WritesAttribute(attribute="numrows", description="The number of rows in this Excel Sheet"), @WritesAttribute(attribute="sourcefilename", description="The name of the Excel document file that this data originated from"), @WritesAttribute(attribute="convertexceltocsvprocessor.error", description="Error message that was encountered on a per Excel sheet basis. This attribute is only populated if an error was occured while processing the particular sheet. Having the error present at the sheet level will allow for the end user to better understand what syntax errors in their excel doc on a larger scale caused the error.")})
public class ConvertExcelToCSVProcessor
extends AbstractProcessor {
    private static final String CSV_MIME_TYPE = "text/csv";
    public static final String SHEET_NAME = "sheetname";
    public static final String ROW_NUM = "numrows";
    public static final String SOURCE_FILE_NAME = "sourcefilename";
    private static final String DESIRED_SHEETS_DELIMITER = ",";
    private static final String UNKNOWN_SHEET_NAME = "UNKNOWN";
    public static final PropertyDescriptor DESIRED_SHEETS = new PropertyDescriptor.Builder().name("extract-sheets").displayName("Sheets to Extract").description("Comma separated list of Excel document sheet names that should be extracted from the excel document. If this property is left blank then all of the sheets will be extracted from the Excel document. The list of names is case in-sensitive. Any sheets not specified in this value will be ignored.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor ROWS_TO_SKIP = new PropertyDescriptor.Builder().name("excel-extract-first-row").displayName("Number of Rows to Skip").description("The row number of the first row to start processing.Use this to skip over rows of data at the top of your worksheet that are not part of the dataset.Empty rows of data anywhere in the spreadsheet will always be skipped, no matter what this value is set to.").required(true).defaultValue("0").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor COLUMNS_TO_SKIP = new PropertyDescriptor.Builder().name("excel-extract-column-to-skip").displayName("Columns To Skip").description("Comma delimited list of column numbers to skip. Use the columns number and not the letter designation. Use this to skip over columns anywhere in your worksheet that you don't want extracted as part of the record.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor FORMAT_VALUES = new PropertyDescriptor.Builder().name("excel-format-values").displayName("Format Cell Values").description("Should the cell values be written to CSV using the formatting applied in Excel, or should they be printed as raw values.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final Relationship ORIGINAL = new Relationship.Builder().name("original").description("Original Excel document received by this processor").build();
    public static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Excel data converted to csv").build();
    public static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Failed to parse the Excel document").build();
    private List<PropertyDescriptor> descriptors;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(DESIRED_SHEETS);
        descriptors.add(ROWS_TO_SKIP);
        descriptors.add(COLUMNS_TO_SKIP);
        descriptors.add(FORMAT_VALUES);
        descriptors.add(CSVUtils.CSV_FORMAT);
        descriptors.add(CSVUtils.VALUE_SEPARATOR);
        descriptors.add(CSVUtils.INCLUDE_HEADER_LINE);
        descriptors.add(CSVUtils.QUOTE_CHAR);
        descriptors.add(CSVUtils.ESCAPE_CHAR);
        descriptors.add(CSVUtils.COMMENT_MARKER);
        descriptors.add(CSVUtils.NULL_STRING);
        descriptors.add(CSVUtils.TRIM_FIELDS);
        descriptors.add(new PropertyDescriptor.Builder().fromPropertyDescriptor(CSVUtils.QUOTE_MODE).defaultValue(CSVUtils.QUOTE_NONE.getValue()).build());
        descriptors.add(CSVUtils.RECORD_SEPARATOR);
        descriptors.add(CSVUtils.TRAILING_DELIMITER);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(ORIGINAL);
        relationships.add(SUCCESS);
        relationships.add(FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    public void onTrigger(ProcessContext context, final ProcessSession session) throws ProcessException {
        final FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        final String desiredSheetsDelimited = context.getProperty(DESIRED_SHEETS).evaluateAttributeExpressions(flowFile).getValue();
        final boolean formatValues = context.getProperty(FORMAT_VALUES).asBoolean();
        final CSVFormat csvFormat = CSVUtils.createCSVFormat((PropertyContext)context, (Map)flowFile.getAttributes());
        final int firstRow = context.getProperty(ROWS_TO_SKIP).evaluateAttributeExpressions(flowFile).asInteger() - 1;
        String[] sColumnsToSkip = StringUtils.split((String)context.getProperty(COLUMNS_TO_SKIP).evaluateAttributeExpressions(flowFile).getValue(), (String)DESIRED_SHEETS_DELIMITER);
        final ArrayList<Integer> columnsToSkip = new ArrayList<Integer>();
        if (sColumnsToSkip != null && sColumnsToSkip.length > 0) {
            for (String c : sColumnsToSkip) {
                try {
                    columnsToSkip.add(Integer.parseInt(c) - 1);
                }
                catch (NumberFormatException e) {
                    throw new ProcessException("Invalid column in Columns to Skip list.", (Throwable)e);
                }
            }
        }
        try {
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream inputStream) throws IOException {
                    try {
                        OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
                        XSSFReader r = new XSSFReader(pkg);
                        ReadOnlySharedStringsTable sst = new ReadOnlySharedStringsTable(pkg);
                        StylesTable styles = r.getStylesTable();
                        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)r.getSheetsData();
                        if (desiredSheetsDelimited != null) {
                            String[] desiredSheets = StringUtils.split((String)desiredSheetsDelimited, (String)ConvertExcelToCSVProcessor.DESIRED_SHEETS_DELIMITER);
                            if (desiredSheets != null) {
                                block3: while (iter.hasNext()) {
                                    InputStream sheet = iter.next();
                                    String sheetName = iter.getSheetName();
                                    for (int i = 0; i < desiredSheets.length; ++i) {
                                        if (!sheetName.equalsIgnoreCase(desiredSheets[i])) continue;
                                        ExcelSheetReadConfig readConfig = new ExcelSheetReadConfig(columnsToSkip, firstRow, sheetName, formatValues, sst, styles);
                                        ConvertExcelToCSVProcessor.this.handleExcelSheet(session, flowFile, sheet, readConfig, csvFormat);
                                        continue block3;
                                    }
                                }
                            } else {
                                ConvertExcelToCSVProcessor.this.getLogger().debug("Excel document was parsed but no sheets with the specified desired names were found.");
                            }
                        } else {
                            while (iter.hasNext()) {
                                InputStream sheet = iter.next();
                                String sheetName = iter.getSheetName();
                                ExcelSheetReadConfig readConfig = new ExcelSheetReadConfig(columnsToSkip, firstRow, sheetName, formatValues, sst, styles);
                                ConvertExcelToCSVProcessor.this.handleExcelSheet(session, flowFile, sheet, readConfig, csvFormat);
                            }
                        }
                    }
                    catch (InvalidFormatException ife) {
                        ConvertExcelToCSVProcessor.this.getLogger().error("Only .xlsx Excel 2007 OOXML files are supported", (Throwable)ife);
                        throw new UnsupportedOperationException("Only .xlsx Excel 2007 OOXML files are supported", ife);
                    }
                    catch (OpenXML4JException | SAXException e) {
                        ConvertExcelToCSVProcessor.this.getLogger().error("Error occurred while processing Excel document metadata", e);
                    }
                }
            });
            session.transfer(flowFile, ORIGINAL);
        }
        catch (RuntimeException ex) {
            this.getLogger().error("Failed to process incoming Excel document. " + ex.getMessage(), (Throwable)ex);
            FlowFile failedFlowFile = session.putAttribute(flowFile, ConvertExcelToCSVProcessor.class.getName() + ".error", ex.getMessage());
            session.transfer(failedFlowFile, FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExcelSheet(ProcessSession session, FlowFile originalParentFF, final InputStream sheetInputStream, final ExcelSheetReadConfig readConfig, CSVFormat csvFormat) throws IOException {
        FlowFile ff = session.create(originalParentFF);
        try {
            DataFormatter formatter = new DataFormatter();
            final InputSource sheetSource = new InputSource(sheetInputStream);
            final SheetToCSV sheetHandler = new SheetToCSV(readConfig, csvFormat);
            final XMLReader parser = SAXHelper.newXMLReader();
            StylesTable sst = readConfig.getFormatValues() ? readConfig.getStyles() : null;
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)sst, null, (SharedStrings)readConfig.getSharedStringsTable(), (XSSFSheetXMLHandler.SheetContentsHandler)sheetHandler, formatter, false);
            parser.setContentHandler((ContentHandler)handler);
            ff = session.write(ff, new OutputStreamCallback(){

                public void process(OutputStream out) throws IOException {
                    PrintStream outPrint = new PrintStream(out, false, StandardCharsets.UTF_8.name());
                    sheetHandler.setOutput(outPrint);
                    try {
                        parser.parse(sheetSource);
                        sheetInputStream.close();
                        sheetHandler.close();
                        outPrint.close();
                    }
                    catch (SAXException se) {
                        ConvertExcelToCSVProcessor.this.getLogger().error("Error occurred while processing Excel sheet {}", new Object[]{readConfig.getSheetName()}, (Throwable)se);
                    }
                }
            });
            ff = session.putAttribute(ff, SHEET_NAME, readConfig.getSheetName());
            ff = session.putAttribute(ff, ROW_NUM, new Long(sheetHandler.getRowCount()).toString());
            ff = StringUtils.isNotEmpty((CharSequence)originalParentFF.getAttribute(CoreAttributes.FILENAME.key())) ? session.putAttribute(ff, SOURCE_FILE_NAME, originalParentFF.getAttribute(CoreAttributes.FILENAME.key())) : session.putAttribute(ff, SOURCE_FILE_NAME, UNKNOWN_SHEET_NAME);
            ff = session.putAttribute(ff, CoreAttributes.FILENAME.key(), this.updateFilenameToCSVExtension(ff.getAttribute(CoreAttributes.UUID.key()), ff.getAttribute(CoreAttributes.FILENAME.key()), readConfig.getSheetName()));
            ff = session.putAttribute(ff, CoreAttributes.MIME_TYPE.key(), CSV_MIME_TYPE);
            session.transfer(ff, SUCCESS);
        }
        catch (ParserConfigurationException | SAXException saxE) {
            this.getLogger().error("Failed to create instance of Parser.", (Throwable)saxE);
            ff = session.putAttribute(ff, ConvertExcelToCSVProcessor.class.getName() + ".error", saxE.getMessage());
            session.transfer(ff, FAILURE);
        }
        finally {
            sheetInputStream.close();
        }
    }

    private String updateFilenameToCSVExtension(String nifiUUID, String origFileName, String sheetName) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)origFileName)) {
            String ext = FilenameUtils.getExtension((String)origFileName);
            if (StringUtils.isNotEmpty((CharSequence)ext)) {
                stringBuilder.append(StringUtils.replace((String)origFileName, (String)("." + ext), (String)""));
            } else {
                stringBuilder.append(origFileName);
            }
        } else {
            stringBuilder.append(nifiUUID);
        }
        stringBuilder.append("_");
        stringBuilder.append(sheetName);
        stringBuilder.append(".");
        stringBuilder.append("csv");
        return stringBuilder.toString();
    }

    private class ExcelSheetReadConfig {
        private int firstColumn;
        private int lastColumn;
        private int firstRow;
        private int lastRow;
        private int overrideFirstRow;
        private String sheetName;
        private boolean formatValues;
        private ReadOnlySharedStringsTable sst;
        private StylesTable styles;
        private List<Integer> columnsToSkip;

        public String getSheetName() {
            return this.sheetName;
        }

        public int getFirstColumn() {
            return this.firstColumn;
        }

        public void setFirstColumn(int value) {
            this.firstColumn = value;
        }

        public int getLastColumn() {
            return this.lastColumn;
        }

        public void setLastColumn(int lastColumn) {
            this.lastColumn = lastColumn;
        }

        public int getOverrideFirstRow() {
            return this.overrideFirstRow;
        }

        public boolean getFormatValues() {
            return this.formatValues;
        }

        public int getFirstRow() {
            return this.firstRow;
        }

        public void setFirstRow(int value) {
            this.firstRow = value;
        }

        public int getLastRow() {
            return this.lastRow;
        }

        public void setLastRow(int value) {
            this.lastRow = value;
        }

        public List<Integer> getColumnsToSkip() {
            return this.columnsToSkip;
        }

        public ReadOnlySharedStringsTable getSharedStringsTable() {
            return this.sst;
        }

        public StylesTable getStyles() {
            return this.styles;
        }

        public ExcelSheetReadConfig(List<Integer> columnsToSkip, int overrideFirstRow, String sheetName, boolean formatValues, ReadOnlySharedStringsTable sst, StylesTable styles) {
            this.sheetName = sheetName;
            this.columnsToSkip = columnsToSkip;
            this.overrideFirstRow = overrideFirstRow;
            this.formatValues = formatValues;
            this.sst = sst;
            this.styles = styles;
        }
    }

    private class SheetToCSV
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private ExcelSheetReadConfig readConfig;
        CSVFormat csvFormat;
        private boolean firstCellOfRow;
        private boolean skipRow;
        private int currentRow = -1;
        private int currentCol = -1;
        private int rowCount = 0;
        private boolean rowHasValues = false;
        private int skippedColumns = 0;
        private CSVPrinter printer;
        private boolean firstRow = false;
        private ArrayList<Object> fieldValues;

        public int getRowCount() {
            return this.rowCount;
        }

        public void setOutput(PrintStream output) {
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8);
            try {
                this.printer = new CSVPrinter((Appendable)streamWriter, this.csvFormat);
            }
            catch (IOException e) {
                throw new ProcessException("Failed to create CSV Printer.", (Throwable)e);
            }
        }

        public SheetToCSV(ExcelSheetReadConfig readConfig, CSVFormat csvFormat) {
            this.readConfig = readConfig;
            this.csvFormat = csvFormat;
        }

        public void startRow(int rowNum) {
            if (rowNum <= this.readConfig.getOverrideFirstRow()) {
                this.skipRow = true;
                return;
            }
            this.skipRow = false;
            this.firstCellOfRow = true;
            this.firstRow = this.currentRow == -1;
            this.currentRow = rowNum;
            this.currentCol = -1;
            this.rowHasValues = false;
            this.fieldValues = new ArrayList();
        }

        public void endRow(int rowNum) {
            if (this.skipRow) {
                return;
            }
            if (this.firstRow) {
                this.readConfig.setLastColumn(this.currentCol);
            }
            if (!this.rowHasValues) {
                return;
            }
            int columnsToAdd = this.readConfig.getLastColumn() - this.currentCol - this.readConfig.getColumnsToSkip().size();
            for (int i = 0; i < columnsToAdd; ++i) {
                this.fieldValues.add(null);
            }
            try {
                this.printer.printRecord(this.fieldValues);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.rowCount;
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            if (this.skipRow) {
                return;
            }
            if (cellReference == null) {
                cellReference = new CellAddress(this.currentRow, this.currentCol).formatAsString();
            }
            short thisCol = new CellReference(cellReference).getCol();
            if (this.firstRow && this.firstCellOfRow) {
                this.readConfig.setFirstRow(this.currentRow);
                this.readConfig.setFirstColumn(thisCol);
            }
            if (!(this.firstRow || thisCol >= this.readConfig.getFirstColumn() && thisCol <= this.readConfig.getLastColumn())) {
                return;
            }
            if (this.readConfig.getColumnsToSkip().contains(thisCol)) {
                ++this.skippedColumns;
                return;
            }
            int missedCols = thisCol - this.readConfig.getFirstColumn() - (this.currentCol - this.readConfig.getFirstColumn()) - 1;
            if (this.firstCellOfRow) {
                missedCols = thisCol - this.readConfig.getFirstColumn();
            }
            missedCols -= this.skippedColumns;
            if (this.firstCellOfRow) {
                this.firstCellOfRow = false;
            }
            for (int i = 0; i < missedCols; ++i) {
                this.fieldValues.add(null);
            }
            this.currentCol = thisCol;
            this.fieldValues.add(formattedValue);
            this.rowHasValues = true;
            this.skippedColumns = 0;
        }

        public void headerFooter(String s, boolean b, String s1) {
        }

        public void close() throws IOException {
            this.printer.close();
        }
    }
}

