/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.pgp.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Objects;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.pgp.attributes.CompressionAlgorithm;
import org.apache.nifi.processors.pgp.attributes.FileEncoding;
import org.apache.nifi.processors.pgp.exception.PGPProcessException;
import org.apache.nifi.stream.io.StreamUtils;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;

public class EncodingStreamCallback
implements StreamCallback {
    protected static final int OUTPUT_BUFFER_SIZE = 8192;
    private final FileEncoding fileEncoding;
    private final CompressionAlgorithm compressionAlgorithm;
    private final String filename;

    public EncodingStreamCallback(FileEncoding fileEncoding, CompressionAlgorithm compressionAlgorithm, String filename) {
        this.fileEncoding = Objects.requireNonNull(fileEncoding, "File Encoding required");
        this.compressionAlgorithm = Objects.requireNonNull(compressionAlgorithm, "Compression Algorithm required");
        this.filename = Objects.requireNonNull(filename, "Filename required");
    }

    public void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (OutputStream encodingOutputStream = this.getEncodingOutputStream(outputStream);){
            this.processEncoding(inputStream, encodingOutputStream);
        }
        catch (PGPException e) {
            throw new PGPProcessException("PGP Stream Processing Failed", e);
        }
    }

    protected byte[] createOutputBuffer() {
        return new byte[8192];
    }

    protected void processEncoding(InputStream inputStream, OutputStream encodingOutputStream) throws IOException, PGPException {
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(this.compressionAlgorithm.getId());
        try (OutputStream compressedOutputStream = compressedDataGenerator.open(encodingOutputStream, this.createOutputBuffer());){
            this.processCompression(inputStream, compressedOutputStream);
        }
        compressedDataGenerator.close();
    }

    protected void processCompression(InputStream inputStream, OutputStream compressedOutputStream) throws IOException, PGPException {
        PGPLiteralDataGenerator generator = new PGPLiteralDataGenerator();
        try (OutputStream literalOutputStream = this.openLiteralOutputStream(generator, compressedOutputStream);){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)literalOutputStream);
        }
        generator.close();
    }

    protected OutputStream openLiteralOutputStream(PGPLiteralDataGenerator generator, OutputStream compressedOutputStream) throws IOException {
        return generator.open(compressedOutputStream, 'b', this.filename, new Date(), this.createOutputBuffer());
    }

    private OutputStream getEncodingOutputStream(OutputStream outputStream) {
        return FileEncoding.ASCII.equals((Object)this.fileEncoding) ? new ArmoredOutputStream(outputStream) : outputStream;
    }
}

