/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.AsyncLineageSubmission;
import org.apache.nifi.provenance.AsyncQuerySubmission;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.IndexConfiguration;
import org.apache.nifi.provenance.PlaceholderProvenanceEvent;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.RepositoryConfiguration;
import org.apache.nifi.provenance.StandardLineageResult;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.StandardQueryResult;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.provenance.expiration.ExpirationAction;
import org.apache.nifi.provenance.expiration.FileRemovalAction;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.lineage.FlowFileLineage;
import org.apache.nifi.provenance.lineage.Lineage;
import org.apache.nifi.provenance.lineage.LineageComputationType;
import org.apache.nifi.provenance.lucene.DocsReader;
import org.apache.nifi.provenance.lucene.DocumentToEventConverter;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.lucene.IndexSearch;
import org.apache.nifi.provenance.lucene.IndexingAction;
import org.apache.nifi.provenance.lucene.LineageQuery;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.lucene.StandardIndexManager;
import org.apache.nifi.provenance.lucene.UpdateMinimumEventId;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QueryResult;
import org.apache.nifi.provenance.search.QuerySubmission;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.serialization.RecordReaders;
import org.apache.nifi.provenance.serialization.RecordWriter;
import org.apache.nifi.provenance.serialization.RecordWriters;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.provenance.util.NamedThreadFactory;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.RingBuffer;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.util.timebuffer.CountSizeEntityAccess;
import org.apache.nifi.util.timebuffer.EntityAccess;
import org.apache.nifi.util.timebuffer.LongEntityAccess;
import org.apache.nifi.util.timebuffer.TimedBuffer;
import org.apache.nifi.util.timebuffer.TimedCountSize;
import org.apache.nifi.util.timebuffer.TimestampedLong;
import org.apache.nifi.web.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PersistentProvenanceRepository
implements ProvenanceRepository {
    public static final String EVENT_CATEGORY = "Provenance Repository";
    private static final String FILE_EXTENSION = ".prov";
    private static final String TEMP_FILE_SUFFIX = ".prov.part";
    private static final long PURGE_EVENT_MILLISECONDS = 2500L;
    public static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    public static final Pattern INDEX_PATTERN = Pattern.compile("(?:lucene-\\d+-)?index-\\d+");
    public static final int MAX_UNDELETED_QUERY_RESULTS = 10;
    public static final int MAX_INDEXING_FAILURE_COUNT = 5;
    public static final int MAX_JOURNAL_ROLLOVER_RETRIES = 5;
    private static final float PURGE_OLD_EVENTS_HIGH_WATER = 0.9f;
    private static final float PURGE_OLD_EVENTS_LOW_WATER = 0.88f;
    private static final float ROLLOVER_HIGH_WATER = 0.99f;
    private static final Logger logger = LoggerFactory.getLogger(PersistentProvenanceRepository.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(PersistentProvenanceRepository.class);
    private final long maxPartitionMillis;
    private final long maxPartitionBytes;
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final AtomicReference<SortedMap<Long, Path>> idToPathMap = new AtomicReference();
    private final AtomicBoolean recoveryFinished = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile long firstEventTimestamp = 0L;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final Lock writeLock = this.rwLock.writeLock();
    private final Lock readLock = this.rwLock.readLock();
    private RecordWriter[] writers;
    private final AtomicLong streamStartTime = new AtomicLong(System.currentTimeMillis());
    private final RepositoryConfiguration configuration;
    private final IndexConfiguration indexConfig;
    private final IndexManager indexManager;
    private final boolean alwaysSync;
    private final int rolloverCheckMillis;
    private final int maxAttributeChars;
    private final ScheduledExecutorService scheduledExecService;
    private final ScheduledExecutorService rolloverExecutor;
    private final ExecutorService queryExecService;
    private final List<ExpirationAction> expirationActions = new ArrayList<ExpirationAction>();
    private final ConcurrentMap<String, AsyncQuerySubmission> querySubmissionMap = new ConcurrentHashMap<String, AsyncQuerySubmission>();
    private final ConcurrentMap<String, AsyncLineageSubmission> lineageSubmissionMap = new ConcurrentHashMap<String, AsyncLineageSubmission>();
    private final AtomicLong writerIndex = new AtomicLong(0L);
    private final AtomicLong storageDirectoryIndex = new AtomicLong(0L);
    private final AtomicLong bytesWrittenSinceRollover = new AtomicLong(0L);
    private final AtomicInteger recordsWrittenSinceRollover = new AtomicInteger(0);
    private final AtomicInteger rolloverCompletions = new AtomicInteger(0);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicInteger dirtyWriterCount = new AtomicInteger(0);
    private final RingBuffer<ProvenanceEventRecord> latestRecords = new RingBuffer(1000);
    private EventReporter eventReporter;
    private Authorizer authorizer;
    private ProvenanceAuthorizableFactory resourceFactory;
    private final TimedBuffer<TimedCountSize> updateCounts = new TimedBuffer(TimeUnit.SECONDS, 300, (EntityAccess)new CountSizeEntityAccess());
    private final TimedBuffer<TimestampedLong> backpressurePauseMillis = new TimedBuffer(TimeUnit.SECONDS, 300, (EntityAccess)new LongEntityAccess());

    public PersistentProvenanceRepository() {
        this.maxPartitionMillis = 0L;
        this.maxPartitionBytes = 0L;
        this.writers = null;
        this.configuration = null;
        this.indexConfig = null;
        this.indexManager = null;
        this.alwaysSync = false;
        this.rolloverCheckMillis = 0;
        this.maxAttributeChars = 0;
        this.scheduledExecService = null;
        this.rolloverExecutor = null;
        this.queryExecService = null;
        this.eventReporter = null;
        this.authorizer = null;
        this.resourceFactory = null;
    }

    public PersistentProvenanceRepository(NiFiProperties nifiProperties) throws IOException {
        this(RepositoryConfiguration.create(nifiProperties), 10000);
    }

    public PersistentProvenanceRepository(RepositoryConfiguration configuration, int rolloverCheckMillis) throws IOException {
        deprecationLogger.warn("{} should be replaced with WriteAheadProvenanceRepository for [{}] in nifi.properties", new Object[]{this.getClass().getSimpleName(), "nifi.provenance.repository.implementation"});
        if (configuration.getStorageDirectories().isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one storage directory");
        }
        this.configuration = configuration;
        this.maxAttributeChars = configuration.getMaxAttributeChars();
        for (File file : configuration.getStorageDirectories().values()) {
            Path storageDirectory = file.toPath();
            Path journalDirectory = storageDirectory.resolve("journals");
            if (!Files.exists(journalDirectory, new LinkOption[0])) {
                Files.createDirectories(journalDirectory, new FileAttribute[0]);
                continue;
            }
            if (Files.isDirectory(journalDirectory, new LinkOption[0])) continue;
            throw new IllegalArgumentException("Storage Location " + journalDirectory + " is not a directory");
        }
        this.maxPartitionMillis = configuration.getMaxEventFileLife(TimeUnit.MILLISECONDS);
        this.maxPartitionBytes = configuration.getMaxEventFileCapacity();
        this.indexConfig = new IndexConfiguration(configuration);
        this.indexManager = new StandardIndexManager(configuration);
        this.alwaysSync = configuration.isAlwaysSync();
        this.rolloverCheckMillis = rolloverCheckMillis;
        this.scheduledExecService = Executors.newScheduledThreadPool(3, new NamedThreadFactory("Provenance Maintenance Thread"));
        this.queryExecService = Executors.newFixedThreadPool(configuration.getQueryThreadPoolSize(), new NamedThreadFactory("Provenance Query Thread"));
        int numRolloverThreads = configuration.getStorageDirectories().size() * 2;
        this.rolloverExecutor = Executors.newScheduledThreadPool(numRolloverThreads, new NamedThreadFactory("Provenance Repository Rollover Thread"));
    }

    protected IndexManager getIndexManager() {
        return this.indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(final EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory, IdentifierLookup idLookup) throws IOException {
        this.writeLock.lock();
        try {
            if (this.initialized.getAndSet(true)) {
                return;
            }
            this.eventReporter = eventReporter;
            this.authorizer = authorizer;
            this.resourceFactory = resourceFactory;
            this.recover();
            if (this.configuration.isAllowRollover()) {
                this.writers = this.createWriters(this.configuration, this.idGenerator.get());
            }
            if (this.configuration.isAllowRollover()) {
                this.scheduledExecService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        if (PersistentProvenanceRepository.this.needToRollover()) {
                            PersistentProvenanceRepository.this.writeLock.lock();
                            try {
                                logger.debug("Obtained write lock to perform periodic rollover");
                                if (PersistentProvenanceRepository.this.needToRollover()) {
                                    try {
                                        PersistentProvenanceRepository.this.rollover(false);
                                    }
                                    catch (Exception e) {
                                        logger.error("Failed to roll over Provenance Event Log due to {}", (Object)e.toString());
                                        logger.error("", (Throwable)e);
                                        eventReporter.reportEvent(Severity.ERROR, PersistentProvenanceRepository.EVENT_CATEGORY, "Failed to roll over Provenance Event Log due to " + e.toString());
                                    }
                                }
                            }
                            finally {
                                PersistentProvenanceRepository.this.writeLock.unlock();
                            }
                        }
                    }
                }, this.rolloverCheckMillis, this.rolloverCheckMillis, TimeUnit.MILLISECONDS);
                this.expirationActions.add(new UpdateMinimumEventId(this.indexConfig));
                this.expirationActions.add(new FileRemovalAction());
                this.scheduledExecService.scheduleWithFixedDelay(new RemoveExpiredQueryResults(), 30L, 3L, TimeUnit.SECONDS);
                this.scheduledExecService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PersistentProvenanceRepository.this.purgeOldEvents();
                        }
                        catch (Exception e) {
                            logger.error("Failed to purge old events from Provenance Repo due to {}", (Object)e.toString());
                            if (logger.isDebugEnabled()) {
                                logger.error("", (Throwable)e);
                            }
                            eventReporter.reportEvent(Severity.ERROR, PersistentProvenanceRepository.EVENT_CATEGORY, "Failed to purge old events from Provenance Repo due to " + e.toString());
                        }
                    }
                }, 2500L, 2500L, TimeUnit.MILLISECONDS);
            }
            this.firstEventTimestamp = this.determineFirstEventTimestamp();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected RecordWriter[] createWriters(RepositoryConfiguration config, long initialRecordId) throws IOException {
        ArrayList<File> storageDirectories = new ArrayList<File>(config.getStorageDirectories().values());
        RecordWriter[] writers = new RecordWriter[config.getJournalCount()];
        for (int i = 0; i < config.getJournalCount(); ++i) {
            File storageDirectory = (File)storageDirectories.get(i % storageDirectories.size());
            File journalDirectory = new File(storageDirectory, "journals");
            File journalFile = new File(journalDirectory, String.valueOf(initialRecordId) + ".journal." + i);
            writers[i] = RecordWriters.newSchemaRecordWriter(journalFile, this.idGenerator, false, false);
            writers[i].writeHeader(initialRecordId);
        }
        logger.info("Created new Provenance Event Writers for events starting with ID {}", (Object)initialRecordId);
        return writers;
    }

    public int getMaxAttributeCharacters() {
        return this.maxAttributeChars;
    }

    public StandardProvenanceEventRecord.Builder eventBuilder() {
        return new StandardProvenanceEventRecord.Builder();
    }

    public void registerEvent(ProvenanceEventRecord event) {
        this.persistRecord(Collections.singleton(event));
    }

    public void registerEvents(Iterable<ProvenanceEventRecord> events) {
        this.persistRecord(events);
    }

    public boolean isAuthorized(ProvenanceEventRecord event, NiFiUser user) {
        Authorizable eventAuthorizable;
        if (this.authorizer == null || user == null) {
            return true;
        }
        try {
            eventAuthorizable = this.resourceFactory.createProvenanceDataAuthorizable(event.getComponentId());
        }
        catch (ResourceNotFoundException rnfe) {
            return false;
        }
        AuthorizationResult result = eventAuthorizable.checkAuthorization(this.authorizer, RequestAction.READ, user);
        return AuthorizationResult.Result.Approved.equals((Object)result.getResult());
    }

    public void authorize(ProvenanceEventRecord event, NiFiUser user) {
        if (this.authorizer == null || user == null) {
            return;
        }
        Authorizable eventAuthorizable = this.resourceFactory.createProvenanceDataAuthorizable(event.getComponentId());
        eventAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
    }

    public List<ProvenanceEventRecord> filterUnauthorizedEvents(List<ProvenanceEventRecord> events, NiFiUser user) {
        return events.stream().filter(event -> this.isAuthorized((ProvenanceEventRecord)event, user)).collect(Collectors.toList());
    }

    public Set<ProvenanceEventRecord> replaceUnauthorizedWithPlaceholders(Set<ProvenanceEventRecord> events, NiFiUser user) {
        return events.stream().map(event -> this.isAuthorized((ProvenanceEventRecord)event, user) ? event : new PlaceholderProvenanceEvent(event)).collect(Collectors.toSet());
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords) throws IOException {
        return this.getEvents(firstRecordId, maxRecords, null);
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords, NiFiUser user) throws IOException {
        ArrayList<ProvenanceEventRecord> records = new ArrayList<ProvenanceEventRecord>(maxRecords);
        List<Path> paths = this.getPathsForId(firstRecordId);
        if (paths == null || paths.isEmpty()) {
            return records;
        }
        for (Path path : paths) {
            try (RecordReader reader2 = RecordReaders.newRecordReader(path.toFile(), this.getAllLogFiles(), this.maxAttributeChars);){
                StandardProvenanceEventRecord record;
                Integer blockIndex;
                TocReader tocReader;
                if (records.isEmpty() && (tocReader = reader2.getTocReader()) != null && (blockIndex = tocReader.getBlockIndexForEventId(firstRecordId)) != null) {
                    reader2.skipToBlock(blockIndex);
                }
                while (records.size() < maxRecords && (record = reader2.nextRecord()) != null) {
                    if (record.getEventId() < firstRecordId || !this.isAuthorized((ProvenanceEventRecord)record, user)) continue;
                    records.add((ProvenanceEventRecord)record);
                }
            }
            catch (EOFException | FileNotFoundException reader2) {
            }
            catch (IOException ioe) {
                logger.error("Failed to read Provenance Event File {} due to {}", (Object)path.toFile(), (Object)ioe.toString());
                logger.error("", (Throwable)ioe);
                this.eventReporter.reportEvent(Severity.ERROR, EVENT_CATEGORY, "Failed to read Provenance Event File " + path.toFile() + " due to " + ioe.toString());
            }
            if (records.size() < maxRecords) continue;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieving up to {} records starting at Event ID {}; returning {} events", new Object[]{maxRecords, firstRecordId, records.size()});
        }
        return records;
    }

    private List<Path> getPathsForId(long id) {
        SortedMap<Long, Path> map = this.idToPathMap.get();
        ArrayList<Path> paths = new ArrayList<Path>();
        Iterator<Map.Entry<Long, Path>> itr = map.entrySet().iterator();
        if (!itr.hasNext()) {
            return paths;
        }
        Map.Entry<Long, Path> lastEntry = itr.next();
        while (itr.hasNext()) {
            Map.Entry<Long, Path> entry = itr.next();
            Long startIndex = entry.getKey();
            if (startIndex >= id) {
                paths.add(lastEntry.getValue());
                paths.add(entry.getValue());
                while (itr.hasNext()) {
                    paths.add(itr.next().getValue());
                }
                return paths;
            }
            lastEntry = entry;
        }
        if (lastEntry != null) {
            paths.add(lastEntry.getValue());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Looking for Event ID {}, searching in paths: {}", (Object)id, paths);
        }
        return paths;
    }

    public RepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public Set<String> getContainerNames() {
        return new HashSet<String>(this.configuration.getStorageDirectories().keySet());
    }

    public long getContainerCapacity(String containerName) throws IOException {
        Map<String, File> map = this.configuration.getStorageDirectories();
        File container = map.get(containerName);
        if (container != null) {
            long capacity = FileUtils.getContainerCapacity((Path)container.toPath());
            if (capacity == 0L) {
                throw new IOException("System returned total space of the partition for " + containerName + " is zero byte. Nifi can not create a zero sized provenance repository.");
            }
            return capacity;
        }
        throw new IllegalArgumentException("There is no defined container with name " + containerName);
    }

    public String getContainerFileStoreName(String containerName) {
        Map<String, File> map = this.configuration.getStorageDirectories();
        File container = map.get(containerName);
        if (container == null) {
            return null;
        }
        try {
            return Files.getFileStore(container.toPath()).name();
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getContainerUsableSpace(String containerName) throws IOException {
        Map<String, File> map = this.configuration.getStorageDirectories();
        File container = map.get(containerName);
        if (container != null) {
            return FileUtils.getContainerUsableSpace((Path)container.toPath());
        }
        throw new IllegalArgumentException("There is no defined container with name " + containerName);
    }

    private void recover() throws IOException {
        long maxId = -1L;
        long maxIndexedId = -1L;
        long minIndexedId = Long.MAX_VALUE;
        ArrayList<File> filesToRecover = new ArrayList<File>();
        for (File file : this.configuration.getStorageDirectories().values()) {
            File[] matchingFiles = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String filename = pathname.getName();
                    if (!filename.contains(PersistentProvenanceRepository.FILE_EXTENSION) || filename.endsWith(PersistentProvenanceRepository.TEMP_FILE_SUFFIX)) {
                        return false;
                    }
                    String baseFilename = filename.substring(0, filename.indexOf("."));
                    return NUMBER_PATTERN.matcher(baseFilename).matches();
                }
            });
            for (File matchingFile : matchingFiles) {
                filesToRecover.add(matchingFile);
            }
        }
        TreeMap<Long, Path> sortedPathMap = new TreeMap<Long, Path>(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return Long.compare(o1, o2);
            }
        });
        File maxIdFile = null;
        for (File file : filesToRecover) {
            String filename = file.getName();
            String baseName = filename.substring(0, filename.indexOf("."));
            long firstId = Long.parseLong(baseName);
            sortedPathMap.put(firstId, file.toPath());
            if (firstId > maxId) {
                maxId = firstId;
                maxIdFile = file;
            }
            if (firstId > maxIndexedId) {
                maxIndexedId = firstId - 1L;
            }
            if (firstId >= minIndexedId) continue;
            minIndexedId = firstId;
        }
        if (maxIdFile != null) {
            try (RecordReader reader = RecordReaders.newRecordReader(maxIdFile, this.getAllLogFiles(), this.maxAttributeChars);){
                long eventId = reader.getMaxEventId();
                if (eventId > maxId) {
                    maxId = eventId;
                }
                if (eventId > maxIndexedId) {
                    maxIndexedId = eventId;
                }
            }
            catch (IOException ioe) {
                logger.error("Failed to read Provenance Event File {} due to {}", maxIdFile, (Object)ioe);
                logger.error("", (Throwable)ioe);
            }
        }
        if (maxIndexedId > -1L) {
            this.indexConfig.setMaxIdIndexed(maxIndexedId);
        }
        if (minIndexedId < Long.MAX_VALUE) {
            this.indexConfig.setMinIdIndexed(minIndexedId);
        }
        this.idGenerator.set(maxId + 1L);
        try {
            Set<File> recoveredJournals = this.recoverJournalFiles();
            filesToRecover.addAll(recoveredJournals);
            File greatestMinIdFile = null;
            long greatestMinId = 0L;
            for (File recoveredJournal : recoveredJournals) {
                if (!recoveredJournal.exists()) continue;
                String basename = LuceneUtil.substringBefore(recoveredJournal.getName(), ".");
                try {
                    long minId = Long.parseLong(basename);
                    sortedPathMap.put(minId, recoveredJournal.toPath());
                    if (greatestMinIdFile != null && minId <= greatestMinId) continue;
                    greatestMinId = minId;
                    greatestMinIdFile = recoveredJournal;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (greatestMinIdFile != null) {
                try (RecordReader recordReader = RecordReaders.newRecordReader(greatestMinIdFile, Collections.emptyList(), this.maxAttributeChars);){
                    maxId = recordReader.getMaxEventId();
                }
            }
            this.idGenerator.set(maxId + 1L);
        }
        catch (IOException ioe) {
            logger.error("Failed to recover Journal Files due to {}", (Object)ioe.toString());
            logger.error("", (Throwable)ioe);
        }
        this.idToPathMap.set(Collections.unmodifiableSortedMap(sortedPathMap));
        logger.trace("In recovery, path map: {}", sortedPathMap);
        long recordsRecovered = minIndexedId < Long.MAX_VALUE ? this.idGenerator.get() - minIndexedId : this.idGenerator.get();
        logger.info("Recovered {} records", (Object)recordsRecovered);
        this.recoveryFinished.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        this.closed.set(true);
        this.writeLock.lock();
        try {
            logger.debug("Obtained write lock for close");
            this.scheduledExecService.shutdownNow();
            this.rolloverExecutor.shutdownNow();
            this.queryExecService.shutdownNow();
            this.getIndexManager().close();
            if (this.writers != null) {
                for (RecordWriter writer : this.writers) {
                    writer.close();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isShutdownComplete() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistRecord(Iterable<ProvenanceEventRecord> records) {
        long totalJournalSize;
        this.readLock.lock();
        try {
            long idx;
            RecordWriter[] recordWriters;
            RecordWriter writer;
            long bytesWritten = 0L;
            boolean locked = false;
            do {
                recordWriters = this.writers;
                int numDirty = this.dirtyWriterCount.get();
                if (numDirty < recordWriters.length) continue;
                throw new IllegalStateException("Cannot update repository because all partitions are unusable at this time. Writing to the repository would cause corruption. This most often happens as a result of the repository running out of disk space or the JVM running out of memory.");
            } while (!(locked = (writer = recordWriters[(int)((idx = this.writerIndex.getAndIncrement()) % (long)recordWriters.length)]).tryLock()));
            try {
                try {
                    long recordsWritten = 0L;
                    for (ProvenanceEventRecord nextRecord : records) {
                        StorageSummary persistedEvent = writer.writeRecord(nextRecord);
                        bytesWritten += persistedEvent.getSerializedLength();
                        ++recordsWritten;
                        logger.trace("Wrote record with ID {} to {}", (Object)persistedEvent.getEventId(), (Object)writer);
                    }
                    writer.flush();
                    if (this.alwaysSync) {
                        writer.sync();
                    }
                    totalJournalSize = this.bytesWrittenSinceRollover.addAndGet(bytesWritten);
                    this.recordsWrittenSinceRollover.getAndIncrement();
                    this.updateCounts.add((Object)new TimedCountSize(recordsWritten, bytesWritten));
                }
                catch (Throwable t) {
                    writer.markDirty();
                    this.dirtyWriterCount.incrementAndGet();
                    this.streamStartTime.set(0L);
                    throw t;
                }
                finally {
                    writer.unlock();
                }
            }
            catch (IOException ioe) {
                logger.error("Failed to persist Provenance Event due to {}.", (Object)ioe.toString());
                logger.error("", (Throwable)ioe);
                this.eventReporter.reportEvent(Severity.ERROR, EVENT_CATEGORY, "Failed to persist Provenance Event due to " + ioe.toString());
                this.readLock.unlock();
                try {
                    this.writeLock.lock();
                    try {
                        logger.debug("Obtained write lock to rollover due to IOException on write");
                        this.rollover(true);
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to Rollover Provenance Event Repository file due to {}", (Object)e.toString());
                    logger.error("", (Throwable)e);
                    this.eventReporter.reportEvent(Severity.ERROR, EVENT_CATEGORY, "Failed to Rollover Provenance Event Log due to " + e.toString());
                }
                finally {
                    this.readLock.lock();
                }
                this.readLock.unlock();
                return;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (totalJournalSize >= this.configuration.getMaxEventFileCapacity()) {
            this.writeLock.lock();
            try {
                logger.debug("Obtained write lock to perform rollover based on file size");
                if (this.bytesWrittenSinceRollover.get() >= this.configuration.getMaxEventFileCapacity()) {
                    try {
                        this.rollover(false);
                    }
                    catch (IOException e) {
                        logger.error("Failed to Rollover Provenance Event Repository file due to {}", (Object)e.toString());
                        logger.error("", (Throwable)e);
                        this.eventReporter.reportEvent(Severity.ERROR, EVENT_CATEGORY, "Failed to Rollover Provenance Event Log due to " + e.toString());
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private List<File> getLogFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (Path path : this.idToPathMap.get().values()) {
            files.add(path.toFile());
        }
        if (files.isEmpty()) {
            return files;
        }
        return files;
    }

    public long getSize(List<File> logFiles, long timeCutoff) {
        long bytesUsed = 0L;
        for (File file : logFiles) {
            long lastModified = file.lastModified();
            if (lastModified > 0L && lastModified < timeCutoff) continue;
            bytesUsed += file.length();
        }
        return bytesUsed += this.indexConfig.getIndexSize();
    }

    synchronized void purgeOldEvents() throws IOException {
        while (!this.recoveryFinished.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<File> toPurge = new ArrayList<File>();
        long timeCutoff = System.currentTimeMillis() - this.configuration.getMaxRecordLife(TimeUnit.MILLISECONDS);
        List<File> sortedByBasename = this.getLogFiles();
        long bytesUsed = this.getSize(sortedByBasename, timeCutoff);
        for (Path path : this.idToPathMap.get().values()) {
            File file = path.toFile();
            long lastModified = file.lastModified();
            if (lastModified <= 0L || lastModified >= timeCutoff) continue;
            toPurge.add(file);
        }
        Comparator<File> sortByBasenameComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String baseName1 = LuceneUtil.substringBefore(o1.getName(), ".");
                String baseName2 = LuceneUtil.substringBefore(o2.getName(), ".");
                Long id1 = null;
                Long id2 = null;
                try {
                    id1 = Long.parseLong(baseName1);
                }
                catch (NumberFormatException nfe) {
                    id1 = null;
                }
                try {
                    id2 = Long.parseLong(baseName2);
                }
                catch (NumberFormatException nfe) {
                    id2 = null;
                }
                if (id1 == null && id2 == null) {
                    return 0;
                }
                if (id1 == null) {
                    return 1;
                }
                if (id2 == null) {
                    return -1;
                }
                return Long.compare(id1, id2);
            }
        };
        if ((float)bytesUsed > (float)this.configuration.getMaxStorageCapacity() * 0.9f) {
            Collections.sort(sortedByBasename, sortByBasenameComparator);
            for (File file : sortedByBasename) {
                toPurge.add(file);
                if (!((float)(bytesUsed -= file.length()) < (float)this.configuration.getMaxStorageCapacity() * 0.88f)) continue;
                break;
            }
        }
        Collections.sort(toPurge, sortByBasenameComparator);
        logger.debug("Purging old event files: {}", toPurge);
        LinkedHashSet linkedHashSet = new LinkedHashSet(toPurge);
        LinkedHashSet<String> removed = new LinkedHashSet<String>();
        for (File file : linkedHashSet) {
            String baseName = LuceneUtil.substringBefore(file.getName(), ".");
            ExpirationAction currentAction = null;
            try {
                Iterator<ExpirationAction> iterator = this.expirationActions.iterator();
                while (iterator.hasNext()) {
                    ExpirationAction action;
                    currentAction = action = iterator.next();
                    if (action.hasBeenPerformed(file)) continue;
                    File fileBeforeAction = file;
                    StopWatch stopWatch = new StopWatch(true);
                    file = action.execute(file);
                    stopWatch.stop();
                    logger.info("Successfully performed Expiration Action {} on Provenance Event file {} in {}", new Object[]{action, fileBeforeAction, stopWatch.getDuration()});
                }
                removed.add(baseName);
            }
            catch (FileNotFoundException fnf) {
                logger.warn("Failed to perform Expiration Action {} on Provenance Event file {} because the file no longer exists; will not perform additional Expiration Actions on this file", currentAction, (Object)file);
                removed.add(baseName);
            }
            catch (Throwable t) {
                logger.warn("Failed to perform Expiration Action {} on Provenance Event file {} due to {}; will not perform additional Expiration Actions on this file at this time", new Object[]{currentAction, file, t.toString()});
                logger.warn("", t);
                this.eventReporter.reportEvent(Severity.WARNING, EVENT_CATEGORY, "Failed to perform Expiration Action " + currentAction + " on Provenance Event file " + file + " due to " + t.toString() + "; will not perform additional Expiration Actions on this file at this time");
            }
        }
        boolean updated = false;
        while (!updated) {
            SortedMap<Long, Path> existingPathMap = this.idToPathMap.get();
            TreeMap<Long, Path> newPathMap = new TreeMap<Long, Path>(new PathMapComparator());
            newPathMap.putAll(existingPathMap);
            Iterator itr = newPathMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                String filename = ((Path)entry.getValue()).toFile().getName();
                String baseName = LuceneUtil.substringBefore(filename, ".");
                if (!removed.contains(baseName)) continue;
                itr.remove();
            }
            updated = this.idToPathMap.compareAndSet(existingPathMap, newPathMap);
            logger.debug("After expiration, path map: {}", newPathMap);
        }
        this.purgeExpiredIndexes();
    }

    private void purgeExpiredIndexes() throws IOException {
        List<File> indexDirs = this.getAllIndexDirectories();
        if (indexDirs.size() < 2) {
            this.firstEventTimestamp = this.determineFirstEventTimestamp();
            return;
        }
        long latestTimestampOfFirstIndex = this.getIndexTimestamp(indexDirs.get(1));
        List<File> logFiles = this.getSortedLogFiles();
        if (logFiles.isEmpty()) {
            this.firstEventTimestamp = System.currentTimeMillis();
            return;
        }
        File firstLogFile = logFiles.get(0);
        long earliestEventTime = System.currentTimeMillis();
        long maxEventId = -1L;
        try (RecordReader reader = RecordReaders.newRecordReader(firstLogFile, null, Integer.MAX_VALUE);){
            StandardProvenanceEventRecord event = reader.nextRecord();
            earliestEventTime = event.getEventTime();
            maxEventId = reader.getMaxEventId();
        }
        catch (IOException ioe) {
            logger.warn("Unable to determine the maximum ID for Provenance Event Log File {}; values reported for the number of events in the Provenance Repository may be inaccurate.", (Object)firstLogFile);
        }
        if (latestTimestampOfFirstIndex <= earliestEventTime) {
            File indexingDirectory = indexDirs.get(0);
            this.getIndexManager().removeIndex(indexingDirectory);
            this.indexConfig.removeIndexDirectory(indexingDirectory);
            this.deleteDirectory(indexingDirectory);
            if (maxEventId > -1L) {
                this.indexConfig.setMinIdIndexed(maxEventId + 1L);
            }
        }
        this.firstEventTimestamp = earliestEventTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long determineFirstEventTimestamp() {
        List<File> logFiles = this.getSortedLogFiles();
        if (logFiles.isEmpty()) {
            return 0L;
        }
        Iterator<File> iterator = logFiles.iterator();
        while (iterator.hasNext()) {
            File logFile = iterator.next();
            try {
                RecordReader reader = RecordReaders.newRecordReader(logFile, null, Integer.MAX_VALUE);
                try {
                    StandardProvenanceEventRecord event = reader.nextRecord();
                    if (event == null) continue;
                    long l = event.getEventTime();
                    return l;
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Failed to obtain timestamp of first event from Provenance Event Log File {}", (Object)logFile);
            }
        }
        return 0L;
    }

    private void deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                this.deleteDirectory(child);
                continue;
            }
            if (child.delete()) continue;
            logger.warn("Unable to remove index directory {}; this directory should be cleaned up manually", (Object)child.getAbsolutePath());
        }
        if (!dir.delete()) {
            logger.warn("Unable to remove index directory {}; this directory should be cleaned up manually", (Object)dir);
        }
    }

    private List<File> getAllIndexDirectories() {
        ArrayList<File> allIndexDirs = new ArrayList<File>();
        for (File storageDir : this.configuration.getStorageDirectories().values()) {
            File[] indexDirs = storageDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return INDEX_PATTERN.matcher(name).matches();
                }
            });
            if (indexDirs == null) continue;
            for (File indexDir : indexDirs) {
                allIndexDirs.add(indexDir);
            }
        }
        Collections.sort(allIndexDirs, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long time1 = PersistentProvenanceRepository.this.getIndexTimestamp(o1);
                long time2 = PersistentProvenanceRepository.this.getIndexTimestamp(o2);
                return Long.compare(time1, time2);
            }
        });
        return allIndexDirs;
    }

    private long getIndexTimestamp(File indexDirectory) {
        String name = indexDirectory.getName();
        int dashIndex = name.lastIndexOf("-");
        return Long.parseLong(name.substring(dashIndex + 1));
    }

    public void waitForRollover() {
        int count = this.rolloverCompletions.get();
        while (this.rolloverCompletions.get() == count) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected int getJournalCount() {
        int journalFileCount = 0;
        for (File storageDir : this.configuration.getStorageDirectories().values()) {
            File journalsDir = new File(storageDir, "journals");
            File[] journalFiles = journalsDir.listFiles();
            if (journalFiles == null) continue;
            journalFileCount += journalFiles.length;
        }
        return journalFileCount;
    }

    void rolloverWithLock(boolean force) throws IOException {
        this.writeLock.lock();
        try {
            this.rollover(force);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected long getRolloverRetryMillis() {
        return 10000L;
    }

    private void rollover(boolean force) throws IOException {
        if (!this.configuration.isAllowRollover()) {
            return;
        }
        if (force || (long)this.recordsWrittenSinceRollover.get() > 0L || this.dirtyWriterCount.get() > 0) {
            final ArrayList<File> journalsToMerge = new ArrayList<File>();
            for (RecordWriter writer : this.writers) {
                if (writer.isClosed()) continue;
                File writerFile = writer.getFile();
                journalsToMerge.add(writerFile);
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close {} due to {}", (Object)writer, (Object)ioe.toString());
                    if (!logger.isDebugEnabled()) continue;
                    logger.warn("", (Throwable)ioe);
                }
            }
            if (logger.isDebugEnabled()) {
                if (journalsToMerge.isEmpty()) {
                    logger.debug("No journals to merge; all RecordWriters were already closed");
                } else {
                    logger.debug("Going to merge {} files for journals starting with ID {}", (Object)journalsToMerge.size(), (Object)LuceneUtil.substringBefore(((File)journalsToMerge.get(0)).getName(), "."));
                }
            }
            long storageDirIdx = this.storageDirectoryIndex.getAndIncrement();
            ArrayList<File> storageDirs = new ArrayList<File>(this.configuration.getStorageDirectories().values());
            final File storageDir = (File)storageDirs.get((int)(storageDirIdx % (long)storageDirs.size()));
            ScheduledFuture<?> future = null;
            if (!journalsToMerge.isEmpty()) {
                final AtomicReference futureReference = new AtomicReference();
                final AtomicInteger retryAttempts = new AtomicInteger(5);
                final int recordsWritten = this.recordsWrittenSinceRollover.getAndSet(0);
                Runnable rolloverRunnable = new Runnable(){

                    @Override
                    public void run() {
                        File fileRolledOver = null;
                        try {
                            try {
                                fileRolledOver = PersistentProvenanceRepository.this.mergeJournals(journalsToMerge, PersistentProvenanceRepository.getMergeFile(journalsToMerge, storageDir), PersistentProvenanceRepository.this.eventReporter);
                            }
                            catch (IOException ioe) {
                                logger.error("Failed to merge Journal Files {} into a Provenance Log File due to {}", (Object)journalsToMerge, (Object)ioe.toString());
                                logger.error("", (Throwable)ioe);
                            }
                            if (fileRolledOver != null) {
                                File file = fileRolledOver;
                                boolean updated = false;
                                Long fileFirstEventId = Long.valueOf(LuceneUtil.substringBefore(fileRolledOver.getName(), "."));
                                while (!updated) {
                                    SortedMap<Long, Path> existingPathMap = PersistentProvenanceRepository.this.idToPathMap.get();
                                    TreeMap<Long, Path> newIdToPathMap = new TreeMap<Long, Path>(new PathMapComparator());
                                    newIdToPathMap.putAll(existingPathMap);
                                    newIdToPathMap.put(fileFirstEventId, file.toPath());
                                    updated = PersistentProvenanceRepository.this.idToPathMap.compareAndSet(existingPathMap, newIdToPathMap);
                                }
                                TimedCountSize countSize = (TimedCountSize)PersistentProvenanceRepository.this.updateCounts.getAggregateValue(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
                                logger.info("Successfully Rolled over Provenance Event file containing {} records. In the past 5 minutes, {} events have been written to the Provenance Repository, totaling {}", new Object[]{recordsWritten, countSize.getCount(), FormatUtils.formatDataSize((double)countSize.getSize())});
                            }
                            if (fileRolledOver != null || retryAttempts.decrementAndGet() == 0) {
                                Future future;
                                if (fileRolledOver == null && retryAttempts.get() == 0) {
                                    logger.error("Failed to merge Journal Files {} after {} attempts.", (Object)journalsToMerge, (Object)5);
                                }
                                PersistentProvenanceRepository.this.rolloverCompletions.getAndIncrement();
                                while ((future = (Future)futureReference.get()) == null) {
                                    try {
                                        Thread.sleep(10L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                future.cancel(false);
                            } else {
                                logger.warn("Couldn't merge journals. Will try again. journalsToMerge: {}, storageDir: {}", (Object)journalsToMerge, (Object)storageDir);
                            }
                        }
                        catch (Exception e) {
                            logger.error("Failed to merge journals. Will try again. journalsToMerge: {}, storageDir: {}, cause: {}", new Object[]{journalsToMerge, storageDir, e.toString()});
                            logger.error("", (Throwable)e);
                        }
                    }
                };
                future = this.rolloverExecutor.scheduleWithFixedDelay(rolloverRunnable, 0L, this.getRolloverRetryMillis(), TimeUnit.MILLISECONDS);
                futureReference.set(future);
            }
            this.streamStartTime.set(System.currentTimeMillis());
            this.bytesWrittenSinceRollover.set(0L);
            int journalFileCount = this.getJournalCount();
            long repoSize = this.getSize(this.getLogFiles(), 0L);
            int journalCountThreshold = this.configuration.getJournalCount() * 5;
            long sizeThreshold = (long)((float)this.configuration.getMaxStorageCapacity() * 0.99f);
            if (journalFileCount > journalCountThreshold || repoSize > sizeThreshold) {
                long stopTheWorldStart = System.nanoTime();
                logger.warn("The rate of the dataflow is exceeding the provenance recording rate. Slowing down flow to accommodate. Currently, there are {} journal files ({} bytes) and threshold for blocking is {} ({} bytes)", new Object[]{journalFileCount, repoSize, journalCountThreshold, sizeThreshold});
                this.eventReporter.reportEvent(Severity.WARNING, EVENT_CATEGORY, "The rate of the dataflow is exceeding the provenance recording rate. Slowing down flow to accommodate");
                while (journalFileCount > journalCountThreshold || repoSize > sizeThreshold) {
                    if (this.closed.get()) {
                        if (future == null) break;
                        future.cancel(true);
                        break;
                    }
                    if (repoSize > sizeThreshold) {
                        logger.debug("Provenance Repository has exceeded its size threshold; will trigger purging of oldest events");
                        this.purgeOldEvents();
                        journalFileCount = this.getJournalCount();
                        repoSize = this.getSize(this.getLogFiles(), 0L);
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    logger.debug("Provenance Repository is still behind. Keeping flow slowed down to accommodate. Currently, there are {} journal files ({} bytes) and threshold for blocking is {} ({} bytes)", new Object[]{journalFileCount, repoSize, journalCountThreshold, sizeThreshold});
                    journalFileCount = this.getJournalCount();
                    repoSize = this.getSize(this.getLogFiles(), 0L);
                }
                long stopTheWorldNanos = System.nanoTime() - stopTheWorldStart;
                this.backpressurePauseMillis.add((Object)new TimestampedLong(Long.valueOf(stopTheWorldNanos)));
                TimestampedLong pauseNanosLastFiveMinutes = (TimestampedLong)this.backpressurePauseMillis.getAggregateValue(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
                logger.info("Provenance Repository has now caught up with rolling over journal files. Current number of journal files to be rolled over is {}. Provenance Repository Back Pressure paused Session commits for {} ({} total in the last 5 minutes).", new Object[]{journalFileCount, FormatUtils.formatNanos((long)stopTheWorldNanos, (boolean)true), FormatUtils.formatNanos((long)pauseNanosLastFiveMinutes.getValue(), (boolean)true)});
            }
            this.writers = this.createWriters(this.configuration, this.idGenerator.get());
            this.dirtyWriterCount.set(0);
            this.streamStartTime.set(System.currentTimeMillis());
            this.recordsWrittenSinceRollover.getAndSet(0);
        }
    }

    protected Set<File> recoverJournalFiles() throws IOException {
        if (!this.configuration.isAllowRollover()) {
            return Collections.emptySet();
        }
        HashMap<String, ArrayList<File>> journalMap = new HashMap<String, ArrayList<File>>();
        ArrayList<File> storageDirs = new ArrayList<File>(this.configuration.getStorageDirectories().values());
        for (File storageDir : storageDirs) {
            File[] journalFiles;
            File journalDir = new File(storageDir, "journals");
            if (!journalDir.exists() || (journalFiles = journalDir.listFiles()) == null) continue;
            for (File journalFile : journalFiles) {
                if (journalFile.isDirectory()) continue;
                String basename = LuceneUtil.substringBefore(journalFile.getName(), ".");
                ArrayList<File> files = (ArrayList<File>)journalMap.get(basename);
                if (files == null) {
                    files = new ArrayList<File>();
                    journalMap.put(basename, files);
                }
                files.add(journalFile);
            }
        }
        HashSet<File> mergedFiles = new HashSet<File>();
        for (List journalFileSet : journalMap.values()) {
            long storageDirIdx;
            File storageDir;
            File mergedFile = this.mergeJournals(journalFileSet, PersistentProvenanceRepository.getMergeFile(journalFileSet, storageDir = (File)storageDirs.get((int)((storageDirIdx = this.storageDirectoryIndex.getAndIncrement()) % (long)storageDirs.size()))), this.eventReporter);
            if (mergedFile == null) continue;
            mergedFiles.add(mergedFile);
        }
        return mergedFiles;
    }

    static File getMergeFile(List<File> journalFiles, File storageDir) {
        String canonicalBaseName = null;
        for (File journal : journalFiles) {
            String basename = LuceneUtil.substringBefore(journal.getName(), ".");
            if (canonicalBaseName == null) {
                canonicalBaseName = basename;
            }
            if (canonicalBaseName.equals(basename)) continue;
            throw new IllegalArgumentException("Cannot merge journal files because they do not contain the same basename, which means that they are not correlated properly");
        }
        File mergedFile = new File(storageDir, canonicalBaseName + FILE_EXTENSION);
        return mergedFile;
    }

    protected List<File> filterUnavailableFiles(List<File> journalFiles) {
        return journalFiles.stream().filter(file -> file.exists()).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    File mergeJournals(List<File> journalFiles, File suggestedMergeFile, EventReporter eventReporter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IndexingAction createIndexingAction() {
        return new IndexingAction(this.configuration.getSearchableFields(), this.configuration.getSearchableAttributes());
    }

    private StandardProvenanceEventRecord truncateAttributes(StandardProvenanceEventRecord original) {
        boolean requireTruncation = false;
        for (String updatedAttr : original.getUpdatedAttributes().values()) {
            if (updatedAttr == null || updatedAttr.length() <= this.maxAttributeChars) continue;
            requireTruncation = true;
            break;
        }
        if (!requireTruncation) {
            for (String previousAttr : original.getPreviousAttributes().values()) {
                if (previousAttr == null || previousAttr.length() <= this.maxAttributeChars) continue;
                requireTruncation = true;
                break;
            }
        }
        if (!requireTruncation) {
            return original;
        }
        StandardProvenanceEventRecord.Builder builder = new StandardProvenanceEventRecord.Builder().fromEvent((ProvenanceEventRecord)original);
        builder.setAttributes(this.truncateAttributes(original.getPreviousAttributes()), this.truncateAttributes(original.getUpdatedAttributes()));
        StandardProvenanceEventRecord truncated = builder.build();
        truncated.setEventId(original.getEventId());
        return truncated;
    }

    private Map<String, String> truncateAttributes(Map<String, String> original) {
        HashMap<String, String> truncatedAttrs = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : original.entrySet()) {
            String value = entry.getValue() != null && entry.getValue().length() > this.maxAttributeChars ? entry.getValue().substring(0, this.maxAttributeChars) : entry.getValue();
            truncatedAttrs.put(entry.getKey(), value);
        }
        return truncatedAttrs;
    }

    public List<SearchableField> getSearchableFields() {
        return new ArrayList<SearchableField>(this.configuration.getSearchableFields());
    }

    public List<SearchableField> getSearchableAttributes() {
        return new ArrayList<SearchableField>(this.configuration.getSearchableAttributes());
    }

    QueryResult queryEvents(Query query, NiFiUser user) throws IOException {
        QuerySubmission submission = this.submitQuery(query, user);
        QueryResult result = submission.getResult();
        while (!result.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
        logger.info("{} got {} hits", (Object)query, (Object)result.getTotalHitCount());
        return result;
    }

    public QuerySubmission submitQuery(Query query, NiFiUser user) {
        String userId = user == null ? null : user.getIdentity();
        int numQueries = this.querySubmissionMap.size();
        if (numQueries > 10) {
            throw new IllegalStateException("Cannot process query because there are currently " + numQueries + " queries whose results have not been deleted due to poorly behaving clients not issuing DELETE requests. Please try again later.");
        }
        if (query.getEndDate() != null && query.getStartDate() != null && query.getStartDate().getTime() > query.getEndDate().getTime()) {
            throw new IllegalArgumentException("Query End Time cannot be before Query Start Time");
        }
        if (query.getSearchTerms().isEmpty() && query.getStartDate() == null && query.getEndDate() == null) {
            AsyncQuerySubmission result = new AsyncQuerySubmission(query, 1, userId);
            if (this.latestRecords.getSize() >= query.getMaxResults()) {
                Long minIndexedId;
                List<ProvenanceEventRecord> latestList = this.filterUnauthorizedEvents(this.latestRecords.asList(), user);
                List<ProvenanceEventRecord> trimmed = latestList.size() > query.getMaxResults() ? latestList.subList(latestList.size() - query.getMaxResults(), latestList.size()) : latestList;
                Long maxEventId = this.getMaxEventId();
                if (maxEventId == null) {
                    result.getResult().update(Collections.emptyList(), 0L);
                    maxEventId = 0L;
                }
                if ((minIndexedId = this.indexConfig.getMinIdIndexed()) == null) {
                    minIndexedId = 0L;
                }
                long totalNumDocs = maxEventId - minIndexedId;
                result.getResult().update(trimmed, totalNumDocs);
            } else {
                this.queryExecService.submit(new GetMostRecentRunnable(query, result, user));
            }
            this.querySubmissionMap.put(query.getIdentifier(), result);
            return result;
        }
        AtomicInteger retrievalCount = new AtomicInteger(0);
        List<File> indexDirectories = this.indexConfig.getIndexDirectories(query.getStartDate() == null ? null : Long.valueOf(query.getStartDate().getTime()), query.getEndDate() == null ? null : Long.valueOf(query.getEndDate().getTime()));
        AsyncQuerySubmission result = new AsyncQuerySubmission(query, indexDirectories.size(), userId);
        this.querySubmissionMap.put(query.getIdentifier(), result);
        if (indexDirectories.isEmpty()) {
            result.getResult().update(Collections.emptyList(), 0L);
        } else {
            for (File indexDir : indexDirectories) {
                result.addQueryExecution(this.queryExecService.submit(new QueryRunnable(query, result, user, indexDir, retrievalCount)));
            }
        }
        return result;
    }

    public Optional<ProvenanceEventRecord> getLatestCachedEvent(String componentId) throws IOException {
        return Optional.empty();
    }

    Iterator<ProvenanceEventRecord> queryLucene(final org.apache.lucene.search.Query luceneQuery) throws IOException {
        List<File> indexFiles = this.indexConfig.getIndexDirectories();
        final AtomicLong hits = new AtomicLong(0L);
        ArrayList<Future> futures = new ArrayList<Future>();
        for (final File indexDirectory : indexFiles) {
            Callable<List<Document>> callable = new Callable<List<Document>>(){

                @Override
                public List<Document> call() {
                    ArrayList<Document> localScoreDocs = new ArrayList<Document>();
                    try (DirectoryReader directoryReader2 = DirectoryReader.open((Directory)FSDirectory.open((Path)indexDirectory.toPath()));){
                        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader2);
                        TopDocs topDocs = searcher.search(luceneQuery, 10000000);
                        logger.info("For {}, Top Docs has {} hits; reading Lucene results", (Object)indexDirectory, (Object)topDocs.scoreDocs.length);
                        if (topDocs.totalHits.value > 0L) {
                            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                                int docId = scoreDoc.doc;
                                Document d = directoryReader2.document(docId);
                                localScoreDocs.add(d);
                            }
                        }
                        hits.addAndGet(localScoreDocs.size());
                    }
                    catch (IndexNotFoundException directoryReader2) {
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                    return localScoreDocs;
                }
            };
            Future future = this.queryExecService.submit(callable);
            futures.add(future);
        }
        logger.info("Merging results of Lucene query ({} hits)", (Object)hits.get());
        List scoreDocs = null;
        int idx = 0;
        for (Future future : futures) {
            try {
                List docs = (List)future.get();
                if (idx++ == 0) {
                    scoreDocs = docs;
                    continue;
                }
                scoreDocs.addAll(docs);
                docs.clear();
            }
            catch (InterruptedException | ExecutionException ee) {
                throw new RuntimeException(ee);
            }
        }
        logger.info("Finished querying Lucene; there are {} docs; sorting for retrieval", (Object)scoreDocs.size());
        LuceneUtil.sortDocsForRetrieval(scoreDocs);
        logger.info("Finished sorting for retrieval. Returning Iterator.");
        final Iterator docItr = scoreDocs.iterator();
        final Collection<Path> allLogFiles = this.getAllLogFiles();
        return new Iterator<ProvenanceEventRecord>(){
            int count = 0;
            RecordReader reader = null;
            String lastStorageFilename = null;
            long lastByteOffset = 0L;

            @Override
            public boolean hasNext() {
                return docItr.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public ProvenanceEventRecord next() {
                if (this.count++ > 0) {
                    docItr.remove();
                }
                Document doc = (Document)docItr.next();
                String storageFilename = doc.getField("storage-filename").stringValue();
                long byteOffset = doc.getField("storage-fileOffset").numericValue().longValue();
                try {
                    List<File> potentialFiles;
                    if (this.reader != null && storageFilename.equals(this.lastStorageFilename) && byteOffset > this.lastByteOffset) {
                        try {
                            StandardProvenanceEventRecord record;
                            this.reader.skipTo(byteOffset);
                            StandardProvenanceEventRecord standardProvenanceEventRecord = record = this.reader.nextRecord();
                            return standardProvenanceEventRecord;
                        }
                        catch (IOException e) {
                            block27: {
                                if (!this.hasNext()) break block27;
                                ProvenanceEventRecord provenanceEventRecord = this.next();
                                this.lastStorageFilename = storageFilename;
                                this.lastByteOffset = byteOffset;
                                return provenanceEventRecord;
                            }
                            ProvenanceEventRecord provenanceEventRecord = null;
                            this.lastStorageFilename = storageFilename;
                            this.lastByteOffset = byteOffset;
                            return provenanceEventRecord;
                        }
                    }
                    if (this.reader != null) {
                        try {
                            this.reader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if ((potentialFiles = LuceneUtil.getProvenanceLogFiles(storageFilename, allLogFiles)).isEmpty()) {
                        if (this.hasNext()) {
                            ProvenanceEventRecord provenanceEventRecord = this.next();
                            return provenanceEventRecord;
                        }
                        ProvenanceEventRecord provenanceEventRecord = null;
                        return provenanceEventRecord;
                    }
                    if (potentialFiles.size() > 1) {
                        if (this.hasNext()) {
                            ProvenanceEventRecord provenanceEventRecord = this.next();
                            return provenanceEventRecord;
                        }
                        ProvenanceEventRecord provenanceEventRecord = null;
                        return provenanceEventRecord;
                    }
                    for (File file : potentialFiles) {
                        try {
                            this.reader = RecordReaders.newRecordReader(file, allLogFiles, PersistentProvenanceRepository.this.maxAttributeChars);
                        }
                        catch (IOException ioe) {
                            continue;
                        }
                        try {
                            StandardProvenanceEventRecord record;
                            this.reader.skip(byteOffset);
                            StandardProvenanceEventRecord standardProvenanceEventRecord = record = this.reader.nextRecord();
                            return standardProvenanceEventRecord;
                        }
                        catch (IOException e) {
                            continue;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                    return null;
                                }
                            }
                        }
                    }
                }
                finally {
                    this.lastStorageFilename = storageFilename;
                    this.lastByteOffset = byteOffset;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    Lineage computeLineage(String flowFileUuid, NiFiUser user) throws IOException {
        return this.computeLineage(Collections.singleton(flowFileUuid), user, LineageComputationType.FLOWFILE_LINEAGE, null, 0L, Long.MAX_VALUE);
    }

    private Lineage computeLineage(Collection<String> flowFileUuids, NiFiUser user, LineageComputationType computationType, Long eventId, Long startTimestamp, Long endTimestamp) throws IOException {
        AsyncLineageSubmission submission = this.submitLineageComputation(flowFileUuids, user, computationType, eventId, startTimestamp, endTimestamp);
        StandardLineageResult result = submission.getResult();
        while (!result.isFinished()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
        return new FlowFileLineage((Collection)result.getNodes(), (Collection)result.getEdges());
    }

    public ComputeLineageSubmission submitLineageComputation(long eventId, NiFiUser user) {
        ProvenanceEventRecord event;
        try {
            event = this.getEvent(eventId);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve Provenance Event with ID " + eventId + " to calculate data lineage due to: " + e, (Throwable)e);
            AsyncLineageSubmission result = new AsyncLineageSubmission(LineageComputationType.FLOWFILE_LINEAGE, Long.valueOf(eventId), Collections.emptySet(), 1, user == null ? null : user.getIdentity());
            result.getResult().setError("Failed to retrieve Provenance Event with ID " + eventId + ". See logs for more information.");
            return result;
        }
        if (event == null) {
            AsyncLineageSubmission result = new AsyncLineageSubmission(LineageComputationType.FLOWFILE_LINEAGE, Long.valueOf(eventId), Collections.emptySet(), 1, user == null ? null : user.getIdentity());
            result.getResult().setError("Could not find Provenance Event with ID " + eventId);
            this.lineageSubmissionMap.put(result.getLineageIdentifier(), result);
            return result;
        }
        return this.submitLineageComputation(Collections.singleton(event.getFlowFileUuid()), user, LineageComputationType.FLOWFILE_LINEAGE, eventId, event.getLineageStartDate(), Long.MAX_VALUE);
    }

    public AsyncLineageSubmission submitLineageComputation(String flowFileUuid, NiFiUser user) {
        return this.submitLineageComputation(Collections.singleton(flowFileUuid), user, LineageComputationType.FLOWFILE_LINEAGE, null, 0L, Long.MAX_VALUE);
    }

    private AsyncLineageSubmission submitLineageComputation(Collection<String> flowFileUuids, NiFiUser user, LineageComputationType computationType, Long eventId, long startTimestamp, long endTimestamp) {
        List<File> indexDirs = this.indexConfig.getIndexDirectories(startTimestamp, endTimestamp);
        AsyncLineageSubmission result = new AsyncLineageSubmission(computationType, eventId, flowFileUuids, indexDirs.size(), user == null ? null : user.getIdentity());
        this.lineageSubmissionMap.put(result.getLineageIdentifier(), result);
        for (File indexDir : indexDirs) {
            this.queryExecService.submit(new ComputeLineageRunnable(flowFileUuids, user, result, indexDir));
        }
        return result;
    }

    public AsyncLineageSubmission submitExpandChildren(long eventId, NiFiUser user) {
        String userId = user == null ? null : user.getIdentity();
        try {
            ProvenanceEventRecord event = this.getEvent(eventId);
            if (event == null) {
                AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_CHILDREN, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
                this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
                submission.getResult().update(Collections.emptyList(), 0L);
                return submission;
            }
            switch (event.getEventType()) {
                case CLONE: 
                case FORK: 
                case JOIN: 
                case REPLAY: {
                    return this.submitLineageComputation(event.getChildUuids(), user, LineageComputationType.EXPAND_CHILDREN, eventId, event.getEventTime(), Long.MAX_VALUE);
                }
            }
            AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_CHILDREN, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
            this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
            submission.getResult().setError("Event ID " + eventId + " indicates an event of type " + event.getEventType() + " so its children cannot be expanded");
            return submission;
        }
        catch (IOException ioe) {
            AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_CHILDREN, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
            this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
            if (ioe.getMessage() == null) {
                submission.getResult().setError(ioe.toString());
            } else {
                submission.getResult().setError(ioe.getMessage());
            }
            return submission;
        }
    }

    public AsyncLineageSubmission submitExpandParents(long eventId, NiFiUser user) {
        String userId = user == null ? null : user.getIdentity();
        try {
            ProvenanceEventRecord event = this.getEvent(eventId);
            if (event == null) {
                AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_PARENTS, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
                this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
                submission.getResult().update(Collections.emptyList(), 0L);
                return submission;
            }
            switch (event.getEventType()) {
                case CLONE: 
                case FORK: 
                case JOIN: 
                case REPLAY: {
                    return this.submitLineageComputation(event.getParentUuids(), user, LineageComputationType.EXPAND_PARENTS, eventId, event.getLineageStartDate(), event.getEventTime());
                }
            }
            AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_PARENTS, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
            this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
            submission.getResult().setError("Event ID " + eventId + " indicates an event of type " + event.getEventType() + " so its parents cannot be expanded");
            return submission;
        }
        catch (IOException ioe) {
            AsyncLineageSubmission submission = new AsyncLineageSubmission(LineageComputationType.EXPAND_PARENTS, Long.valueOf(eventId), Collections.emptyList(), 1, userId);
            this.lineageSubmissionMap.put(submission.getLineageIdentifier(), submission);
            if (ioe.getMessage() == null) {
                submission.getResult().setError(ioe.toString());
            } else {
                submission.getResult().setError(ioe.getMessage());
            }
            return submission;
        }
    }

    public AsyncLineageSubmission retrieveLineageSubmission(String lineageIdentifier, NiFiUser user) {
        AsyncLineageSubmission submission = (AsyncLineageSubmission)this.lineageSubmissionMap.get(lineageIdentifier);
        String userId = submission.getSubmitterIdentity();
        if (user == null && userId == null) {
            return submission;
        }
        if (user == null) {
            throw new AccessDeniedException("Cannot retrieve Provenance Lineage Submission because no user id was provided in the lineage request.");
        }
        if (userId == null || userId.equals(user.getIdentity())) {
            return submission;
        }
        throw new AccessDeniedException("Cannot retrieve Provenance Lineage Submission because " + user.getIdentity() + " is not the user who submitted the request.");
    }

    public QuerySubmission retrieveQuerySubmission(String queryIdentifier, NiFiUser user) {
        QuerySubmission submission = (QuerySubmission)this.querySubmissionMap.get(queryIdentifier);
        String userId = submission.getSubmitterIdentity();
        if (user == null && userId == null) {
            return submission;
        }
        if (user == null) {
            throw new AccessDeniedException("Cannot retrieve Provenance Query Submission because no user id was provided in the provenance request.");
        }
        if (userId == null || userId.equals(user.getIdentity())) {
            return submission;
        }
        throw new AccessDeniedException("Cannot retrieve Provenance Query Submission because " + user.getIdentity() + " is not the user who submitted the request.");
    }

    public ProvenanceEventRecord getEvent(long id) throws IOException {
        List<ProvenanceEventRecord> records = this.getEvents(id, 1);
        if (records.isEmpty()) {
            return null;
        }
        ProvenanceEventRecord record = records.get(0);
        if (record.getEventId() != id) {
            return null;
        }
        return record;
    }

    public ProvenanceEventRecord getEvent(long id, NiFiUser user) throws IOException {
        ProvenanceEventRecord event = this.getEvent(id);
        if (event == null) {
            return null;
        }
        this.authorize(event, user);
        return event;
    }

    private boolean needToRollover() {
        long writtenSinceRollover = this.bytesWrittenSinceRollover.get();
        if (writtenSinceRollover >= this.maxPartitionBytes) {
            return true;
        }
        return this.dirtyWriterCount.get() > 0 || writtenSinceRollover > 0L && System.currentTimeMillis() > this.streamStartTime.get() + this.maxPartitionMillis;
    }

    private List<File> getSortedLogFiles() {
        ArrayList<Path> paths = new ArrayList<Path>(this.getAllLogFiles());
        Collections.sort(paths, new Comparator<Path>(){

            @Override
            public int compare(Path o1, Path o2) {
                return Long.compare(PersistentProvenanceRepository.this.getFirstEventId(o1.toFile()), PersistentProvenanceRepository.this.getFirstEventId(o2.toFile()));
            }
        });
        ArrayList<File> files = new ArrayList<File>(paths.size());
        for (Path path : paths) {
            files.add(path.toFile());
        }
        return files;
    }

    public ProvenanceEventRepository getProvenanceEventRepository() {
        return this;
    }

    private long getFirstEventId(File logFile) {
        String name = logFile.getName();
        int dotIndex = name.indexOf(".");
        return Long.parseLong(name.substring(0, dotIndex));
    }

    public Collection<Path> getAllLogFiles() {
        SortedMap<Long, Path> map = this.idToPathMap.get();
        return map == null ? new ArrayList() : map.values();
    }

    public Long getMaxEventId() {
        return this.indexConfig.getMaxIdIndexed();
    }

    private class RemoveExpiredQueryResults
    implements Runnable {
        private RemoveExpiredQueryResults() {
        }

        @Override
        public void run() {
            try {
                Date now = new Date();
                Iterator queryIterator = PersistentProvenanceRepository.this.querySubmissionMap.entrySet().iterator();
                while (queryIterator.hasNext()) {
                    Map.Entry entry = queryIterator.next();
                    StandardQueryResult result = ((AsyncQuerySubmission)entry.getValue()).getResult();
                    if (!((AsyncQuerySubmission)entry.getValue()).isCanceled() && (!result.isFinished() || !result.getExpiration().before(now))) continue;
                    queryIterator.remove();
                }
                Iterator lineageIterator = PersistentProvenanceRepository.this.lineageSubmissionMap.entrySet().iterator();
                while (lineageIterator.hasNext()) {
                    Map.Entry entry = lineageIterator.next();
                    StandardLineageResult result = ((AsyncLineageSubmission)entry.getValue()).getResult();
                    if (!((AsyncLineageSubmission)entry.getValue()).isCanceled() && (!result.isFinished() || !result.getExpiration().before(now))) continue;
                    lineageIterator.remove();
                }
            }
            catch (Throwable t) {
                logger.error("Failed to expire Provenance Query Results due to {}", (Object)t.toString());
                logger.error("", t);
            }
        }
    }

    private static class PathMapComparator
    implements Comparator<Long> {
        private PathMapComparator() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return Long.compare(o1, o2);
        }
    }

    private class GetMostRecentRunnable
    implements Runnable {
        private final Query query;
        private final AsyncQuerySubmission submission;
        private final NiFiUser user;

        public GetMostRecentRunnable(Query query, AsyncQuerySubmission submission, NiFiUser user) {
            this.query = query;
            this.submission = submission;
            this.user = user;
        }

        @Override
        public void run() {
            Long maxEventId = PersistentProvenanceRepository.this.indexConfig.getMaxIdIndexed();
            if (maxEventId == null) {
                this.submission.getResult().update(Collections.emptyList(), 0L);
                return;
            }
            int maxResults = this.query.getMaxResults();
            long startIndex = Math.max(maxEventId - (long)this.query.getMaxResults(), 0L);
            try {
                Long minIndexedId = PersistentProvenanceRepository.this.indexConfig.getMinIdIndexed();
                if (minIndexedId == null) {
                    minIndexedId = 0L;
                }
                long totalNumDocs = maxEventId - minIndexedId;
                List<ProvenanceEventRecord> mostRecent = PersistentProvenanceRepository.this.getEvents(startIndex, maxResults, this.user);
                this.submission.getResult().update(mostRecent, totalNumDocs);
            }
            catch (IOException ioe) {
                logger.error("Failed to retrieve records from Provenance Repository: " + ioe.toString());
                if (logger.isDebugEnabled()) {
                    logger.error("", (Throwable)ioe);
                }
                if (ioe.getMessage() == null) {
                    this.submission.getResult().setError("Failed to retrieve records from Provenance Repository: " + ioe.toString());
                }
                this.submission.getResult().setError("Failed to retrieve records from Provenance Repository: " + ioe.getMessage());
            }
        }
    }

    private class QueryRunnable
    implements Runnable {
        private final Query query;
        private final AsyncQuerySubmission submission;
        private final NiFiUser user;
        private final File indexDir;
        private final AtomicInteger retrievalCount;

        public QueryRunnable(Query query, AsyncQuerySubmission submission, NiFiUser user, File indexDir, AtomicInteger retrievalCount) {
            this.query = query;
            this.submission = submission;
            this.user = user;
            this.indexDir = indexDir;
            this.retrievalCount = retrievalCount;
        }

        @Override
        public void run() {
            try {
                IndexSearch search = new IndexSearch(PersistentProvenanceRepository.this, this.indexDir, PersistentProvenanceRepository.this.getIndexManager(), PersistentProvenanceRepository.this.maxAttributeChars);
                StandardQueryResult queryResult = search.search(this.query, this.user, this.retrievalCount, PersistentProvenanceRepository.this.firstEventTimestamp);
                this.submission.getResult().update((Collection)queryResult.getMatchingEvents(), queryResult.getTotalHitCount());
            }
            catch (Throwable t) {
                logger.error("Failed to query Provenance Repository Index {} due to {}", (Object)this.indexDir, (Object)t.toString());
                if (logger.isDebugEnabled()) {
                    logger.error("", t);
                }
                if (t.getMessage() == null) {
                    this.submission.getResult().setError(t.toString());
                }
                this.submission.getResult().setError(t.getMessage());
            }
        }
    }

    private class ComputeLineageRunnable
    implements Runnable {
        private final Collection<String> flowFileUuids;
        private final NiFiUser user;
        private final File indexDir;
        private final AsyncLineageSubmission submission;

        public ComputeLineageRunnable(Collection<String> flowFileUuids, NiFiUser user, AsyncLineageSubmission submission, File indexDir) {
            this.flowFileUuids = flowFileUuids;
            this.user = user;
            this.submission = submission;
            this.indexDir = indexDir;
        }

        @Override
        public void run() {
            if (this.submission.isCanceled()) {
                return;
            }
            try {
                DocumentToEventConverter converter = new DocumentToEventConverter(){

                    @Override
                    public Set<ProvenanceEventRecord> convert(TopDocs topDocs, IndexReader indexReader) throws IOException {
                        EventAuthorizer authorizer = EventAuthorizer.GRANT_ALL;
                        DocsReader docsReader = new DocsReader();
                        return docsReader.read(topDocs, authorizer, indexReader, PersistentProvenanceRepository.this.getAllLogFiles(), new AtomicInteger(0), Integer.MAX_VALUE, PersistentProvenanceRepository.this.maxAttributeChars);
                    }
                };
                Set<ProvenanceEventRecord> matchingRecords = LineageQuery.computeLineageForFlowFiles(PersistentProvenanceRepository.this.getIndexManager(), this.indexDir, null, this.flowFileUuids, converter);
                StandardLineageResult result = this.submission.getResult();
                result.update(PersistentProvenanceRepository.this.replaceUnauthorizedWithPlaceholders(matchingRecords, this.user), (long)matchingRecords.size());
                logger.info("Successfully created Lineage for FlowFiles with UUIDs {} in {} milliseconds; Lineage contains {} nodes and {} edges", new Object[]{this.flowFileUuids, result.getComputationTime(TimeUnit.MILLISECONDS), result.getNodes().size(), result.getEdges().size()});
            }
            catch (Throwable t) {
                logger.error("Failed to query provenance repository due to {}", (Object)t.toString());
                if (logger.isDebugEnabled()) {
                    logger.error("", t);
                }
                if (t.getMessage() == null) {
                    this.submission.getResult().setError(t.toString());
                }
                this.submission.getResult().setError(t.getMessage());
            }
        }
    }
}

