/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.IOException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.EncryptedSchemaRecordReader;
import org.apache.nifi.provenance.EncryptedSchemaRecordWriter;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.RepositoryConfiguration;
import org.apache.nifi.provenance.WriteAheadProvenanceRepository;
import org.apache.nifi.provenance.serialization.RecordReaders;
import org.apache.nifi.provenance.store.EventFileManager;
import org.apache.nifi.provenance.store.RecordReaderFactory;
import org.apache.nifi.provenance.store.RecordWriterFactory;
import org.apache.nifi.provenance.toc.StandardTocWriter;
import org.apache.nifi.provenance.toc.TocUtil;
import org.apache.nifi.repository.encryption.AesGcmByteArrayRepositoryEncryptor;
import org.apache.nifi.repository.encryption.RepositoryEncryptor;
import org.apache.nifi.repository.encryption.configuration.EncryptedRepositoryType;
import org.apache.nifi.repository.encryption.configuration.EncryptionMetadataHeader;
import org.apache.nifi.repository.encryption.configuration.kms.StandardRepositoryKeyProviderFactory;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.util.NiFiProperties;

public class EncryptedWriteAheadProvenanceRepository
extends WriteAheadProvenanceRepository {
    private NiFiProperties niFiProperties;
    private RepositoryEncryptor<byte[], byte[]> repositoryEncryptor;

    public EncryptedWriteAheadProvenanceRepository() {
    }

    public EncryptedWriteAheadProvenanceRepository(NiFiProperties niFiProperties) {
        super(RepositoryConfiguration.create(niFiProperties));
        this.niFiProperties = niFiProperties;
        StandardRepositoryKeyProviderFactory repositoryKeyProviderFactory = new StandardRepositoryKeyProviderFactory();
        KeyProvider keyProvider = repositoryKeyProviderFactory.getKeyProvider(EncryptedRepositoryType.PROVENANCE, niFiProperties);
        this.repositoryEncryptor = new AesGcmByteArrayRepositoryEncryptor(keyProvider, EncryptionMetadataHeader.PROVENANCE);
    }

    @Override
    public synchronized void initialize(EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory, IdentifierLookup idLookup) throws IOException {
        RecordWriterFactory recordWriterFactory = (file, idGenerator, compressed, createToc) -> {
            StandardTocWriter tocWriter = createToc ? new StandardTocWriter(TocUtil.getTocFile(file), false, false) : null;
            String keyId = this.niFiProperties.getProvenanceRepoEncryptionKeyId();
            return new EncryptedSchemaRecordWriter(file, idGenerator, tocWriter, compressed, 32768, idLookup, this.repositoryEncryptor, keyId);
        };
        EventFileManager fileManager = new EventFileManager();
        RecordReaderFactory recordReaderFactory = (file, logs, maxChars) -> {
            fileManager.obtainReadLock(file);
            try {
                EncryptedSchemaRecordReader tempReader = (EncryptedSchemaRecordReader)RecordReaders.newRecordReader(file, logs, maxChars);
                tempReader.setRepositoryEncryptor(this.repositoryEncryptor);
                EncryptedSchemaRecordReader encryptedSchemaRecordReader = tempReader;
                return encryptedSchemaRecordReader;
            }
            finally {
                fileManager.releaseReadLock(file);
            }
        };
        super.init(recordWriterFactory, recordReaderFactory, eventReporter, authorizer, resourceFactory, fileManager);
    }
}

