/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.EventIdFirstSchemaRecordWriter;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.repository.encryption.RepositoryEncryptor;

public class EncryptedSchemaRecordWriter
extends EventIdFirstSchemaRecordWriter {
    public static final String SERIALIZATION_NAME = "EncryptedSchemaRecordWriter";
    public static final int SERIALIZATION_VERSION = 1;
    private final RepositoryEncryptor<byte[], byte[]> repositoryEncryptor;
    private final String keyId;

    public EncryptedSchemaRecordWriter(File file, AtomicLong idGenerator, TocWriter writer, boolean compressed, int uncompressedBlockSize, IdentifierLookup idLookup, RepositoryEncryptor<byte[], byte[]> repositoryEncryptor, String keyId) throws IOException {
        super(file, idGenerator, writer, compressed, uncompressedBlockSize, idLookup);
        this.repositoryEncryptor = repositoryEncryptor;
        this.keyId = keyId;
    }

    @Override
    protected byte[] serializeEvent(ProvenanceEventRecord event) throws IOException {
        byte[] serialized = super.serializeEvent(event);
        String eventId = event.getBestEventIdentifier();
        return (byte[])this.repositoryEncryptor.encrypt((Object)serialized, eventId, this.keyId);
    }

    @Override
    protected int getSerializationVersion() {
        return 1;
    }

    @Override
    protected String getSerializationName() {
        return SERIALIZATION_NAME;
    }

    public String toString() {
        return "EncryptedSchemaRecordWriter[keyId=" + this.keyId + ", encryptor=" + this.repositoryEncryptor + "]";
    }
}

