/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.search.SearchableField;

public class IndexingAction {
    private final Set<SearchableField> searchableEventFields;
    private final Set<SearchableField> searchableAttributeFields;

    public IndexingAction(List<SearchableField> searchableEventFields, List<SearchableField> searchableAttributes) {
        this.searchableEventFields = Collections.unmodifiableSet(new HashSet<SearchableField>(searchableEventFields));
        this.searchableAttributeFields = Collections.unmodifiableSet(new HashSet<SearchableField>(searchableAttributes));
    }

    private void addField(Document doc, SearchableField field, String value, Field.Store store) {
        if (value == null || !field.isAttribute() && !this.searchableEventFields.contains(field)) {
            return;
        }
        doc.add((IndexableField)new StringField(field.getSearchableFieldName(), value.toLowerCase(), store));
    }

    public void index(StandardProvenanceEventRecord record, IndexWriter indexWriter, Integer blockIndex) throws IOException {
        Document doc = new Document();
        this.addField(doc, SearchableFields.FlowFileUUID, record.getFlowFileUuid(), Field.Store.NO);
        this.addField(doc, SearchableFields.Filename, LuceneUtil.truncateIndexField(record.getAttribute(CoreAttributes.FILENAME.key())), Field.Store.NO);
        this.addField(doc, SearchableFields.ComponentID, record.getComponentId(), Field.Store.NO);
        this.addField(doc, SearchableFields.AlternateIdentifierURI, record.getAlternateIdentifierUri(), Field.Store.NO);
        this.addField(doc, SearchableFields.EventType, record.getEventType().name(), Field.Store.NO);
        this.addField(doc, SearchableFields.Relationship, record.getRelationship(), Field.Store.NO);
        this.addField(doc, SearchableFields.Details, record.getDetails(), Field.Store.NO);
        this.addField(doc, SearchableFields.ContentClaimSection, record.getContentClaimSection(), Field.Store.NO);
        this.addField(doc, SearchableFields.ContentClaimContainer, record.getContentClaimContainer(), Field.Store.NO);
        this.addField(doc, SearchableFields.ContentClaimIdentifier, record.getContentClaimIdentifier(), Field.Store.NO);
        this.addField(doc, SearchableFields.SourceQueueIdentifier, record.getSourceQueueIdentifier(), Field.Store.NO);
        this.addField(doc, SearchableFields.TransitURI, record.getTransitUri(), Field.Store.NO);
        for (SearchableField searchableField : this.searchableAttributeFields) {
            this.addField(doc, searchableField, LuceneUtil.truncateIndexField(record.getAttribute(searchableField.getSearchableFieldName())), Field.Store.NO);
        }
        String storageFilename = LuceneUtil.substringBefore(record.getStorageFilename(), ".");
        if (!doc.getFields().isEmpty()) {
            String sourceIdentifier;
            int lastColon;
            String sourceFlowFileUUID;
            doc.add((IndexableField)new LongPoint(SearchableFields.LineageStartDate.getSearchableFieldName(), new long[]{record.getLineageStartDate()}));
            doc.add((IndexableField)new LongPoint(SearchableFields.EventTime.getSearchableFieldName(), new long[]{record.getEventTime()}));
            doc.add((IndexableField)new LongPoint(SearchableFields.FileSize.getSearchableFieldName(), new long[]{record.getFileSize()}));
            doc.add((IndexableField)new StringField("storage-filename", storageFilename, Field.Store.YES));
            if (blockIndex == null) {
                doc.add((IndexableField)new LongPoint("storage-fileOffset", new long[]{record.getStorageByteOffset()}));
                doc.add((IndexableField)new StoredField("storage-fileOffset", record.getStorageByteOffset()));
            } else {
                doc.add((IndexableField)new IntPoint("block-index", new int[]{blockIndex}));
                doc.add((IndexableField)new StoredField("block-index", blockIndex.intValue()));
                doc.add((IndexableField)new LongPoint(SearchableFields.Identifier.getSearchableFieldName(), new long[]{record.getEventId()}));
                doc.add((IndexableField)new StoredField(SearchableFields.Identifier.getSearchableFieldName(), record.getEventId()));
            }
            ProvenanceEventType eventType = record.getEventType();
            if (eventType == ProvenanceEventType.FORK || eventType == ProvenanceEventType.CLONE || eventType == ProvenanceEventType.REPLAY) {
                for (String uuid : record.getChildUuids()) {
                    if (uuid.equals(record.getFlowFileUuid())) continue;
                    this.addField(doc, SearchableFields.FlowFileUUID, uuid, Field.Store.NO);
                }
            } else if (eventType == ProvenanceEventType.JOIN) {
                for (String uuid : record.getParentUuids()) {
                    if (uuid.equals(record.getFlowFileUuid())) continue;
                    this.addField(doc, SearchableFields.FlowFileUUID, uuid, Field.Store.NO);
                }
            } else if (eventType == ProvenanceEventType.RECEIVE && record.getSourceSystemFlowFileIdentifier() != null && (sourceFlowFileUUID = (lastColon = (sourceIdentifier = record.getSourceSystemFlowFileIdentifier()).lastIndexOf(":")) > -1 && lastColon < sourceIdentifier.length() - 2 ? sourceIdentifier.substring(lastColon + 1) : null) != null) {
                this.addField(doc, SearchableFields.FlowFileUUID, sourceFlowFileUUID, Field.Store.NO);
            }
            indexWriter.addDocument((Iterable)doc);
        }
    }
}

