/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.toc;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.nifi.provenance.toc.TocWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTocWriter
implements TocWriter {
    private static final Logger logger = LoggerFactory.getLogger(StandardTocWriter.class);
    public static final byte VERSION = 2;
    private final File file;
    private final FileOutputStream fos;
    private final boolean alwaysSync;
    private int index = -1;

    public StandardTocWriter(File file, boolean compressionFlag, boolean alwaysSync) throws IOException {
        File tocDir = file.getParentFile();
        if (!tocDir.exists()) {
            Files.createDirectories(tocDir.toPath(), new FileAttribute[0]);
        }
        this.file = file;
        this.fos = new FileOutputStream(file);
        this.alwaysSync = alwaysSync;
        byte[] header = new byte[]{2, (byte)(compressionFlag ? 1 : 0)};
        this.fos.write(header);
        this.fos.flush();
        if (alwaysSync) {
            this.sync();
        }
    }

    @Override
    public void addBlockOffset(long offset, long firstEventId) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(this.fos);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeLong(offset);
        dos.writeLong(firstEventId);
        dos.flush();
        ++this.index;
        logger.debug("Adding block {} at offset {}", (Object)this.index, (Object)offset);
        if (this.alwaysSync) {
            this.sync();
        }
    }

    @Override
    public void sync() throws IOException {
        this.fos.getFD().sync();
    }

    @Override
    public int getCurrentBlockIndex() {
        return this.index;
    }

    @Override
    public void close() throws IOException {
        if (this.alwaysSync) {
            this.fos.getFD().sync();
        }
        this.fos.close();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public String toString() {
        return "TOC Writer for " + this.file;
    }
}

