/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.nifi.provenance.RepositoryConfiguration;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.apache.nifi.provenance.index.EventIndexWriter;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.lucene.LuceneEventIndexSearcher;
import org.apache.nifi.provenance.lucene.LuceneEventIndexWriter;
import org.apache.nifi.provenance.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardIndexManager
implements IndexManager {
    private static final Logger logger = LoggerFactory.getLogger(StandardIndexManager.class);
    private final Object countMutex = new Object();
    private final Map<File, IndexWriterCount> writerCounts = new HashMap<File, IndexWriterCount>();
    private final Map<File, Integer> searcherCounts = new HashMap<File, Integer>();
    private final ExecutorService searchExecutor;
    private final RepositoryConfiguration repoConfig;

    public StandardIndexManager(RepositoryConfiguration repoConfig) {
        this.repoConfig = repoConfig;
        this.searchExecutor = Executors.newFixedThreadPool(repoConfig.getQueryThreadPoolSize(), new NamedThreadFactory("Search Lucene Index", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        logger.debug("Shutting down SimpleIndexManager search executor");
        this.searchExecutor.shutdown();
        try {
            if (!this.searchExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.searchExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.searchExecutor.shutdownNow();
        }
        Object object = this.countMutex;
        synchronized (object) {
            HashSet<File> closed = new HashSet<File>();
            for (Map.Entry<File, IndexWriterCount> entry : this.writerCounts.entrySet()) {
                IndexWriterCount count = entry.getValue();
                if (count.getCount() >= 1) continue;
                count.close();
                closed.add(entry.getKey());
            }
            closed.forEach(this.writerCounts::remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventIndexSearcher borrowIndexSearcher(File indexDir) throws IOException {
        DirectoryReader directoryReader;
        IndexWriterCount writerCount;
        File absoluteFile = indexDir.getAbsoluteFile();
        Object object = this.countMutex;
        synchronized (object) {
            writerCount = this.writerCounts.remove(absoluteFile);
            if (writerCount == null) {
                Integer searcherCount = this.searcherCounts.remove(absoluteFile);
                int updatedSearcherCount = searcherCount == null ? 1 : searcherCount + 1;
                this.searcherCounts.put(absoluteFile, updatedSearcherCount);
                logger.debug("Index Searcher being borrowed for {}. No Active Writer so incrementing Searcher Count to {}", (Object)absoluteFile, (Object)updatedSearcherCount);
            } else {
                int updatedWriterCount = writerCount.getCount() + 1;
                this.writerCounts.put(absoluteFile, new IndexWriterCount(writerCount.getWriter(), writerCount.getAnalyzer(), writerCount.getDirectory(), updatedWriterCount, writerCount.isCloseableWhenUnused()));
                logger.debug("Index Searcher being borrowed for {}. An Active Writer exists so incrementing Writer Count to {}", (Object)absoluteFile, (Object)updatedWriterCount);
            }
        }
        if (writerCount == null) {
            boolean directoryExists = indexDir.exists();
            if (!directoryExists) {
                throw new FileNotFoundException("Cannot search Provenance Index Directory " + indexDir.getAbsolutePath() + " because the directory does not exist");
            }
            logger.trace("Creating index searcher for {}", (Object)indexDir);
            FSDirectory directory = FSDirectory.open((Path)indexDir.toPath());
            directoryReader = DirectoryReader.open((Directory)directory);
        } else {
            EventIndexWriter eventIndexWriter = writerCount.getWriter();
            directoryReader = DirectoryReader.open((IndexWriter)eventIndexWriter.getIndexWriter(), (boolean)false, (boolean)false);
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader, (Executor)this.searchExecutor);
        logger.trace("Created index searcher {} for {}", (Object)searcher, (Object)indexDir);
        return new LuceneEventIndexSearcher(searcher, indexDir, null, directoryReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnIndexSearcher(EventIndexSearcher searcher) {
        IndexWriterCount count;
        File indexDirectory = searcher.getIndexDirectory();
        logger.debug("Closing index searcher {} for {}", (Object)searcher, (Object)indexDirectory);
        StandardIndexManager.closeQuietly(searcher);
        logger.debug("Closed index searcher {}", (Object)searcher);
        boolean closeWriter = false;
        Object object = this.countMutex;
        synchronized (object) {
            File absoluteFile = searcher.getIndexDirectory().getAbsoluteFile();
            count = this.writerCounts.get(absoluteFile);
            if (count == null) {
                int updatedSearcherCount;
                Integer searcherCount = this.searcherCounts.remove(absoluteFile);
                int n = updatedSearcherCount = searcherCount == null ? 0 : searcherCount - 1;
                if (updatedSearcherCount <= 0) {
                    this.searcherCounts.remove(absoluteFile);
                } else {
                    this.searcherCounts.put(absoluteFile, updatedSearcherCount);
                }
                logger.debug("Returning EventIndexSearcher for {}; there is no active writer for this searcher so will not decrement writerCounts. Decrementing Searcher Count to {}", (Object)absoluteFile, (Object)updatedSearcherCount);
                return;
            }
            if (count.getCount() <= 1) {
                boolean close = count.isCloseableWhenUnused();
                logger.debug("Decrementing count for Index Writer for {} to {}{}", new Object[]{indexDirectory, count.getCount() - 1, close ? "; closing writer" : ""});
                if (close) {
                    this.writerCounts.remove(absoluteFile);
                    closeWriter = true;
                } else {
                    this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, count.isCloseableWhenUnused()));
                }
            } else {
                this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, count.isCloseableWhenUnused()));
            }
        }
        if (closeWriter) {
            try {
                this.close(count);
            }
            catch (Exception e) {
                logger.warn("Failed to close Index Writer {} due to {}", new Object[]{count.getWriter(), e.toString(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIndex(File indexDirectory) {
        IndexWriterCount writerCount;
        File absoluteFile = indexDirectory.getAbsoluteFile();
        logger.debug("Attempting to remove index {} from SimpleIndexManager", (Object)absoluteFile);
        Object object = this.countMutex;
        synchronized (object) {
            Integer numSearchers = this.searcherCounts.get(absoluteFile);
            if (numSearchers != null && numSearchers > 0) {
                logger.debug("Not allowing removal of index {} because the active searcher count for this directory is {}", (Object)absoluteFile, (Object)numSearchers);
                return false;
            }
            writerCount = this.writerCounts.remove(absoluteFile);
            if (writerCount == null) {
                logger.debug("Allowing removal of index {} because there is no IndexWriterCount for this directory", (Object)absoluteFile);
                return true;
            }
            if (writerCount.getCount() > 0) {
                logger.debug("Not allowing removal of index {} because the active writer count for this directory is {}", (Object)absoluteFile, (Object)writerCount.getCount());
                this.writerCounts.put(absoluteFile, writerCount);
                return false;
            }
        }
        try {
            logger.debug("Removing index {} from SimpleIndexManager and closing the writer", (Object)absoluteFile);
            this.close(writerCount);
        }
        catch (Exception e) {
            logger.error("Failed to close Index Writer for {} while removing Index from the repository;this directory may need to be cleaned up manually.", (Object)absoluteFile, (Object)e);
        }
        return true;
    }

    private IndexWriterCount createWriter(File indexDirectory) throws IOException {
        ArrayList<Object> closeables = new ArrayList<Object>();
        FSDirectory directory = FSDirectory.open((Path)indexDirectory.toPath());
        closeables.add(directory);
        try {
            StandardAnalyzer analyzer = new StandardAnalyzer();
            closeables.add(analyzer);
            IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
            ConcurrentMergeScheduler concurrentMergeScheduler = new ConcurrentMergeScheduler();
            int mergeThreads = this.repoConfig.getConcurrentMergeThreads();
            concurrentMergeScheduler.setMaxMergesAndThreads(mergeThreads, mergeThreads);
            config.setMergeScheduler((MergeScheduler)concurrentMergeScheduler);
            IndexWriter indexWriter = new IndexWriter((Directory)directory, config);
            LuceneEventIndexWriter eventIndexWriter = new LuceneEventIndexWriter(indexWriter, indexDirectory);
            IndexWriterCount writerCount = new IndexWriterCount(eventIndexWriter, (Analyzer)analyzer, (Directory)directory, 1, false);
            logger.debug("Providing new index writer for {}", (Object)indexDirectory);
            return writerCount;
        }
        catch (IOException ioe) {
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (IOException ioe2) {
                    ioe.addSuppressed(ioe2);
                }
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventIndexWriter borrowIndexWriter(File indexDirectory) throws IOException {
        IndexWriterCount writerCount;
        File absoluteFile = indexDirectory.getAbsoluteFile();
        logger.trace("Borrowing index writer for {}", (Object)indexDirectory);
        Object object = this.countMutex;
        synchronized (object) {
            writerCount = this.writerCounts.get(absoluteFile);
            if (writerCount == null) {
                writerCount = this.createWriter(indexDirectory);
                this.writerCounts.put(absoluteFile, writerCount);
            } else {
                logger.trace("Providing existing index writer for {} and incrementing count to {}", (Object)indexDirectory, (Object)(writerCount.getCount() + 1));
                this.writerCounts.put(absoluteFile, new IndexWriterCount(writerCount.getWriter(), writerCount.getAnalyzer(), writerCount.getDirectory(), writerCount.getCount() + 1, writerCount.isCloseableWhenUnused()));
            }
            if (this.writerCounts.size() > this.repoConfig.getStorageDirectories().size() * 2) {
                logger.debug("Index Writer returned; writer count map now has size {}; writerCount = {}; full writerCounts map = {}", new Object[]{this.writerCounts.size(), writerCount, this.writerCounts});
            }
        }
        return writerCount.getWriter();
    }

    @Override
    public void returnIndexWriter(EventIndexWriter writer) {
        this.returnIndexWriter(writer, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnIndexWriter(EventIndexWriter writer, boolean commit, boolean isCloseable) {
        block20: {
            File indexDirectory = writer.getDirectory();
            File absoluteFile = indexDirectory.getAbsoluteFile();
            logger.trace("Returning Index Writer for {} to IndexManager", (Object)indexDirectory);
            boolean unused = false;
            boolean close = isCloseable;
            try {
                IndexWriterCount count;
                Object object = this.countMutex;
                synchronized (object) {
                    count = this.writerCounts.get(absoluteFile);
                    if (count != null && count.isCloseableWhenUnused()) {
                        close = true;
                    }
                    if (count == null) {
                        logger.warn("Index Writer {} was returned to IndexManager for {}, but this writer is not known. This could potentially lead to a resource leak", (Object)writer, (Object)indexDirectory);
                        writer.close();
                    } else if (count.getCount() <= 1) {
                        unused = true;
                        if (close) {
                            logger.debug("Decrementing count for Index Writer for {} to {}; closing writer", (Object)indexDirectory, (Object)(count.getCount() - 1));
                            this.writerCounts.remove(absoluteFile);
                        } else {
                            logger.trace("Decrementing count for Index Writer for {} to {}", (Object)indexDirectory, (Object)(count.getCount() - 1));
                            this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, close));
                        }
                    } else {
                        if (close) {
                            logger.debug("Decrementing count for Index Writer for {} to {} and marking as closeable when no longer in use", (Object)indexDirectory, (Object)(count.getCount() - 1));
                        } else {
                            logger.trace("Decrementing count for Index Writer for {} to {}", (Object)indexDirectory, (Object)(count.getCount() - 1));
                        }
                        this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, close));
                    }
                    if (this.writerCounts.size() > this.repoConfig.getStorageDirectories().size() * 2) {
                        logger.debug("Index Writer returned; writer count map now has size {}; writer = {}, commit = {}, isCloseable = {}, writerCount = {}; full writerCounts Map = {}", new Object[]{this.writerCounts.size(), writer, commit, isCloseable, count, this.writerCounts});
                    }
                }
                if (!unused) break block20;
                try {
                    if (commit) {
                        writer.commit();
                    }
                }
                finally {
                    if (close) {
                        logger.info("Index Writer for {} has been returned to Index Manager and is no longer in use. Closing Index Writer", (Object)indexDirectory);
                        this.close(count);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Failed to close Index Writer {} due to {}", new Object[]{writer, e.toString(), e});
            }
        }
    }

    protected void close(IndexWriterCount count) throws IOException {
        logger.debug("Closing Index Writer for {}...", (Object)count.getWriter().getDirectory());
        count.close();
        logger.debug("Finished closing Index Writer for {}...", (Object)count.getWriter().getDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getWriterCount() {
        Object object = this.countMutex;
        synchronized (object) {
            return this.writerCounts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSearcherCount() {
        Object object = this.countMutex;
        synchronized (object) {
            return this.searcherCounts.size();
        }
    }

    private static void closeQuietly(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close {} due to {}", (Object)closeable, (Object)e);
            }
        }
    }

    protected static class IndexWriterCount
    implements Closeable {
        private final EventIndexWriter writer;
        private final Analyzer analyzer;
        private final Directory directory;
        private final int count;
        private final boolean closeableWhenUnused;

        public IndexWriterCount(EventIndexWriter writer, Analyzer analyzer, Directory directory, int count, boolean closeableWhenUnused) {
            this.writer = writer;
            this.analyzer = analyzer;
            this.directory = directory;
            this.count = count;
            this.closeableWhenUnused = closeableWhenUnused;
        }

        public boolean isCloseableWhenUnused() {
            return this.closeableWhenUnused;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Directory getDirectory() {
            return this.directory;
        }

        public EventIndexWriter getWriter() {
            return this.writer;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void close() throws IOException {
            StandardIndexManager.closeQuietly(new Closeable[]{this.writer, this.analyzer, this.directory});
        }

        public String toString() {
            return "IndexWriterCount[count=" + this.count + ", writer=" + this.writer + ", closeableWhenUnused=" + this.closeableWhenUnused + "]";
        }
    }
}

