/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.index.lucene;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.index.lucene.CachedQuery;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.SearchTerm;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.util.RingBuffer;

public class LatestEventsPerProcessorQuery
implements CachedQuery {
    private static final String COMPONENT_ID_FIELD_NAME = SearchableFields.ComponentID.getSearchableFieldName();
    private final ConcurrentMap<String, RingBuffer<Long>> latestRecords = new ConcurrentHashMap<String, RingBuffer<Long>>();

    @Override
    public void update(ProvenanceEventRecord event, StorageSummary storageSummary) {
        String componentId = event.getComponentId();
        RingBuffer ringBuffer = this.latestRecords.computeIfAbsent(componentId, id -> new RingBuffer(1000));
        ringBuffer.add((Object)storageSummary.getEventId());
    }

    public List<Long> getLatestEventIds(String componentId) {
        RingBuffer ringBuffer = (RingBuffer)this.latestRecords.get(componentId);
        if (ringBuffer == null) {
            return Collections.emptyList();
        }
        return ringBuffer.asList();
    }

    @Override
    public Optional<List<Long>> evaluate(Query query) {
        if (query.getMaxResults() > 1000) {
            return Optional.empty();
        }
        List terms = query.getSearchTerms();
        if (terms.size() != 1) {
            return Optional.empty();
        }
        SearchTerm term = (SearchTerm)terms.get(0);
        if (!COMPONENT_ID_FIELD_NAME.equals(term.getSearchableField().getSearchableFieldName())) {
            return Optional.empty();
        }
        if (query.getEndDate() != null || query.getStartDate() != null) {
            return Optional.empty();
        }
        RingBuffer ringBuffer = (RingBuffer)this.latestRecords.get(term.getValue());
        if (ringBuffer == null || ringBuffer.getSize() < query.getMaxResults()) {
            return Optional.empty();
        }
        List eventIds = ringBuffer.asList();
        if (eventIds.size() > query.getMaxResults()) {
            eventIds = eventIds.subList(0, query.getMaxResults());
        }
        return Optional.of(eventIds);
    }

    public String toString() {
        return "Latest Events Per Processor";
    }
}

