/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.index.lucene;

import java.io.File;

public class IndexLocation {
    private final File indexDirectory;
    private final long indexStartTimestamp;
    private final String partitionName;

    public IndexLocation(File indexDirectory, long indexStartTimestamp, String partitionName) {
        this.indexDirectory = indexDirectory;
        this.indexStartTimestamp = indexStartTimestamp;
        this.partitionName = partitionName;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public long getIndexStartTimestamp() {
        return this.indexStartTimestamp;
    }

    public long getIndexEndTimestamp() {
        long lastMod = this.indexDirectory.lastModified();
        if (lastMod == 0L) {
            return System.currentTimeMillis();
        }
        return lastMod;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public int hashCode() {
        return 31 + 41 * this.indexDirectory.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexLocation)) {
            return false;
        }
        IndexLocation other = (IndexLocation)obj;
        return this.indexDirectory.equals(other.getIndexDirectory());
    }

    public String toString() {
        return "IndexLocation[directory=" + this.indexDirectory + "]";
    }
}

