/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.serialization.CompressableRecordReader;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.stream.io.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRecordReader
extends CompressableRecordReader {
    public static final int SERIALIZATION_VERISON = 9;
    public static final String SERIALIZATION_NAME = "org.apache.nifi.provenance.PersistentProvenanceRepository";
    private static final Logger logger = LoggerFactory.getLogger(StandardRecordReader.class);
    private static final Pattern UUID_PATTERN = Pattern.compile("[a-fA-F0-9]{8}\\-([a-fA-F0-9]{4}\\-){3}[a-fA-F0-9]{12}");

    public StandardRecordReader(InputStream in, String filename, int maxAttributeChars) throws IOException {
        this(in, filename, null, maxAttributeChars);
    }

    public StandardRecordReader(InputStream in, String filename, TocReader tocReader, int maxAttributeChars) throws IOException {
        super(in, filename, tocReader, maxAttributeChars);
        logger.trace("Creating RecordReader for {}", (Object)filename);
    }

    private StandardProvenanceEventRecord readPreVersion6Record(DataInputStream dis, int serializationVersion) throws IOException {
        long startOffset = this.getBytesConsumed();
        StandardProvenanceEventRecord.Builder builder = new StandardProvenanceEventRecord.Builder();
        long eventId = dis.readLong();
        if (serializationVersion == 4) {
            dis.readUTF();
        }
        String eventTypeName = dis.readUTF();
        ProvenanceEventType eventType = ProvenanceEventType.valueOf((String)eventTypeName);
        builder.setEventType(eventType);
        builder.setEventTime(dis.readLong());
        if (serializationVersion > 3) {
            builder.setEventDuration(dis.readLong());
        }
        dis.readLong();
        long fileSize = dis.readLong();
        builder.setComponentId(this.readNullableString(dis));
        builder.setComponentType(this.readNullableString(dis));
        builder.setFlowFileUUID(this.readNullableString(dis));
        int numParents = dis.readInt();
        for (int i = 0; i < numParents; ++i) {
            builder.addParentUuid(dis.readUTF());
        }
        if (serializationVersion > 2) {
            int numChildren = dis.readInt();
            for (int i = 0; i < numChildren; ++i) {
                builder.addChildUuid(dis.readUTF());
            }
        }
        String sourceSystemUri = this.readNullableString(dis);
        if (serializationVersion > 3) {
            builder.setSourceSystemFlowFileIdentifier(this.readNullableString(dis));
        }
        String destinationSystemUri = this.readNullableString(dis);
        if (sourceSystemUri != null) {
            builder.setTransitUri(sourceSystemUri);
        } else if (destinationSystemUri != null) {
            builder.setTransitUri(destinationSystemUri);
        }
        this.readNullableString(dis);
        builder.setAlternateIdentifierUri(this.readNullableString(dis));
        Map<String, String> attrs = this.readAttributes(dis, false);
        builder.setFlowFileEntryDate(System.currentTimeMillis());
        builder.setLineageStartDate(-1L);
        builder.setAttributes(Collections.emptyMap(), attrs);
        builder.setCurrentContentClaim(null, null, null, null, fileSize);
        builder.setStorageLocation(this.getFilename(), startOffset);
        StandardProvenanceEventRecord record = builder.build();
        record.setEventId(eventId);
        return record;
    }

    @Override
    public StandardProvenanceEventRecord nextRecord(DataInputStream dis, int serializationVersion) throws IOException {
        if (serializationVersion > 9) {
            throw new IllegalArgumentException("Unable to deserialize record because the version is " + serializationVersion + " and supported versions are 1-9");
        }
        if (serializationVersion < 6) {
            return this.readPreVersion6Record(dis, serializationVersion);
        }
        long startOffset = this.getBytesConsumed();
        StandardProvenanceEventRecord.Builder builder = new StandardProvenanceEventRecord.Builder();
        long eventId = dis.readLong();
        String eventTypeName = dis.readUTF();
        ProvenanceEventType eventType = ProvenanceEventType.valueOf((String)eventTypeName);
        builder.setEventType(eventType);
        builder.setEventTime(dis.readLong());
        Long flowFileEntryDate = dis.readLong();
        builder.setEventDuration(dis.readLong());
        if (serializationVersion < 9) {
            int numLineageIdentifiers = dis.readInt();
            for (int i = 0; i < numLineageIdentifiers; ++i) {
                this.readUUID(dis, serializationVersion);
            }
        }
        long lineageStartDate = dis.readLong();
        if (serializationVersion < 7) {
            long fileSize = dis.readLong();
            builder.setCurrentContentClaim(null, null, null, null, fileSize);
        }
        builder.setComponentId(this.readNullableString(dis));
        builder.setComponentType(this.readNullableString(dis));
        String uuid = this.readUUID(dis, serializationVersion);
        builder.setFlowFileUUID(uuid);
        builder.setDetails(this.readNullableString(dis));
        if (serializationVersion >= 7) {
            Map<String, String> previousAttrs = this.readAttributes(dis, false);
            Map<String, String> attrUpdates = this.readAttributes(dis, true);
            builder.setAttributes(previousAttrs, attrUpdates);
            boolean hasContentClaim = dis.readBoolean();
            if (hasContentClaim) {
                builder.setCurrentContentClaim(dis.readUTF(), dis.readUTF(), dis.readUTF(), Long.valueOf(dis.readLong()), dis.readLong());
            } else {
                builder.setCurrentContentClaim(null, null, null, null, 0L);
            }
            boolean hasPreviousClaim = dis.readBoolean();
            if (hasPreviousClaim) {
                builder.setPreviousContentClaim(dis.readUTF(), dis.readUTF(), dis.readUTF(), Long.valueOf(dis.readLong()), dis.readLong());
            }
            builder.setSourceQueueIdentifier(this.readNullableString(dis));
        } else {
            Map<String, String> attrs = this.readAttributes(dis, false);
            builder.setAttributes(Collections.emptyMap(), attrs);
        }
        if (eventType == ProvenanceEventType.FORK || eventType == ProvenanceEventType.JOIN || eventType == ProvenanceEventType.CLONE || eventType == ProvenanceEventType.REPLAY) {
            int numParents = dis.readInt();
            for (int i = 0; i < numParents; ++i) {
                builder.addParentUuid(this.readUUID(dis, serializationVersion));
            }
            int numChildren = dis.readInt();
            for (int i = 0; i < numChildren; ++i) {
                builder.addChildUuid(this.readUUID(dis, serializationVersion));
            }
        } else if (eventType == ProvenanceEventType.RECEIVE) {
            builder.setTransitUri(this.readNullableString(dis));
            builder.setSourceSystemFlowFileIdentifier(this.readNullableString(dis));
        } else if (eventType == ProvenanceEventType.FETCH) {
            builder.setTransitUri(this.readNullableString(dis));
        } else if (eventType == ProvenanceEventType.SEND) {
            builder.setTransitUri(this.readNullableString(dis));
        } else if (eventType == ProvenanceEventType.ADDINFO) {
            builder.setAlternateIdentifierUri(this.readNullableString(dis));
        } else if (eventType == ProvenanceEventType.ROUTE) {
            builder.setRelationship(this.readNullableString(dis));
        }
        builder.setFlowFileEntryDate(flowFileEntryDate.longValue());
        builder.setLineageStartDate(lineageStartDate);
        builder.setStorageLocation(this.getFilename(), startOffset);
        StandardProvenanceEventRecord record = builder.build();
        record.setEventId(eventId);
        return record;
    }

    private Map<String, String> readAttributes(DataInputStream dis, boolean valueNullable) throws IOException {
        int numAttributes = dis.readInt();
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (int i = 0; i < numAttributes; ++i) {
            String value;
            String key = this.readLongString(dis);
            String string = value = valueNullable ? this.readLongNullableString(dis) : this.readLongString(dis);
            String truncatedValue = value == null ? null : (value.length() > this.getMaxAttributeLength() ? value.substring(0, this.getMaxAttributeLength()) : value);
            attrs.put(key, truncatedValue);
        }
        return attrs;
    }

    private String readUUID(DataInputStream in, int serializationVersion) throws IOException {
        if (serializationVersion < 8) {
            long msb = in.readLong();
            long lsb = in.readLong();
            return new UUID(msb, lsb).toString();
        }
        String uuid = in.readUTF();
        if (!UUID_PATTERN.matcher(uuid).matches()) {
            throw new IOException("Failed to parse Provenance Event Record: expected a UUID but got: " + uuid);
        }
        return uuid;
    }

    private String readNullableString(DataInputStream in) throws IOException {
        boolean valueExists = in.readBoolean();
        if (valueExists) {
            return in.readUTF();
        }
        return null;
    }

    private String readLongNullableString(DataInputStream in) throws IOException {
        boolean valueExists = in.readBoolean();
        if (valueExists) {
            return this.readLongString(in);
        }
        return null;
    }

    private String readLongString(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] strBytes = new byte[length];
        StreamUtils.fillBuffer((InputStream)in, (byte[])strBytes);
        return new String(strBytes, "UTF-8");
    }
}

