/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.schema.EventIdFirstHeaderSchema;
import org.apache.nifi.provenance.schema.LookupTableEventRecord;
import org.apache.nifi.provenance.schema.LookupTableEventSchema;
import org.apache.nifi.provenance.serialization.CompressableRecordWriter;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.repository.schema.FieldMapRecord;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.SchemaRecordWriter;

public class EventIdFirstSchemaRecordWriter
extends CompressableRecordWriter {
    private static final RecordSchema eventSchema = LookupTableEventSchema.EVENT_SCHEMA;
    private static final RecordSchema contentClaimSchema = new RecordSchema(eventSchema.getField("Content Claim").getSubFields());
    private static final RecordSchema previousContentClaimSchema = new RecordSchema(eventSchema.getField("Previous Content Claim").getSubFields());
    private static final RecordSchema headerSchema = EventIdFirstHeaderSchema.SCHEMA;
    public static final int SERIALIZATION_VERSION = 1;
    public static final String SERIALIZATION_NAME = "EventIdFirstSchemaRecordWriter";
    private final IdentifierLookup idLookup;
    private final SchemaRecordWriter schemaRecordWriter = new SchemaRecordWriter();
    private final AtomicInteger recordCount = new AtomicInteger(0);
    private final Map<String, Integer> componentIdMap;
    private final Map<String, Integer> componentTypeMap;
    private final Map<String, Integer> queueIdMap;
    private static final Map<String, Integer> eventTypeMap = new HashMap<String, Integer>();
    private static final List<String> eventTypeNames = new ArrayList<String>();
    private long firstEventId;
    private long systemTimeOffset;

    public EventIdFirstSchemaRecordWriter(File file, AtomicLong idGenerator, TocWriter writer, boolean compressed, int uncompressedBlockSize, IdentifierLookup idLookup) throws IOException {
        super(file, idGenerator, writer, compressed, uncompressedBlockSize);
        this.idLookup = idLookup;
        this.componentIdMap = idLookup.invertComponentIdentifiers();
        this.componentTypeMap = idLookup.invertComponentTypes();
        this.queueIdMap = idLookup.invertQueueIdentifiers();
    }

    @Override
    public Map<ProvenanceEventRecord, StorageSummary> writeRecords(Iterable<ProvenanceEventRecord> events) throws IOException {
        if (this.isDirty()) {
            throw new IOException("Cannot update Provenance Repository because this Record Writer has already failed to write to the Repository");
        }
        int heapThreshold = 1000000;
        HashMap<ProvenanceEventRecord, StorageSummary> storageSummaries = new HashMap<ProvenanceEventRecord, StorageSummary>();
        LinkedHashMap<ProvenanceEventRecord, byte[]> serializedEvents = new LinkedHashMap<ProvenanceEventRecord, byte[]>();
        int totalBytes = 0;
        for (ProvenanceEventRecord event : events) {
            byte[] serialized = this.serializeEvent(event);
            serializedEvents.put(event, serialized);
            if ((totalBytes += serialized.length) < 1000000) continue;
            this.storeEvents(serializedEvents, storageSummaries);
            this.recordCount.addAndGet(serializedEvents.size());
            serializedEvents.clear();
            totalBytes = 0;
        }
        this.storeEvents(serializedEvents, storageSummaries);
        this.recordCount.addAndGet(serializedEvents.size());
        return storageSummaries;
    }

    protected byte[] serializeEvent(ProvenanceEventRecord event) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dataOutputStream = new DataOutputStream(baos);){
                this.writeRecord(event, 0L, dataOutputStream);
                dataOutputStream.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    private synchronized void storeEvents(Map<ProvenanceEventRecord, byte[]> serializedEvents, Map<ProvenanceEventRecord, StorageSummary> summaryMap) throws IOException {
        for (Map.Entry<ProvenanceEventRecord, byte[]> entry : serializedEvents.entrySet()) {
            long endBytes;
            long startBytes;
            long recordIdentifier;
            ProvenanceEventRecord event = entry.getKey();
            byte[] serialized = entry.getValue();
            try {
                recordIdentifier = event.getEventId() == -1L ? this.getIdGenerator().getAndIncrement() : event.getEventId();
                startBytes = this.getBytesWritten();
                this.ensureStreamState(recordIdentifier, startBytes);
                DataOutputStream out = this.getBufferedOutputStream();
                int recordIdOffset = (int)(recordIdentifier - this.firstEventId);
                out.writeInt(recordIdOffset);
                out.writeInt(serialized.length);
                out.write(serialized);
                endBytes = this.getBytesWritten();
            }
            catch (IOException ioe) {
                this.markDirty();
                throw ioe;
            }
            long serializedLength = endBytes - startBytes;
            TocWriter tocWriter = this.getTocWriter();
            Integer blockIndex = tocWriter == null ? null : Integer.valueOf(tocWriter.getCurrentBlockIndex());
            File file = this.getFile();
            String storageLocation = file.getParentFile().getName() + "/" + file.getName();
            StorageSummary storageSummary = new StorageSummary(recordIdentifier, storageLocation, blockIndex, serializedLength, endBytes);
            summaryMap.put(event, storageSummary);
        }
    }

    @Override
    public StorageSummary writeRecord(ProvenanceEventRecord record) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRecordsWritten() {
        return this.recordCount.get();
    }

    protected Record createRecord(ProvenanceEventRecord event, long eventId) {
        return new LookupTableEventRecord(event, eventId, eventSchema, contentClaimSchema, previousContentClaimSchema, this.firstEventId, this.systemTimeOffset, this.componentIdMap, this.componentTypeMap, this.queueIdMap, eventTypeMap);
    }

    @Override
    protected void writeRecord(ProvenanceEventRecord event, long eventId, DataOutputStream out) throws IOException {
        Record eventRecord = this.createRecord(event, eventId);
        this.schemaRecordWriter.writeRecord(eventRecord, (OutputStream)out);
    }

    @Override
    protected synchronized void writeHeader(long firstEventId, DataOutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        eventSchema.writeTo((OutputStream)baos);
        out.writeInt(baos.size());
        baos.writeTo(out);
        baos.reset();
        headerSchema.writeTo((OutputStream)baos);
        out.writeInt(baos.size());
        baos.writeTo(out);
        this.firstEventId = firstEventId;
        this.systemTimeOffset = System.currentTimeMillis();
        HashMap<String, Object> headerValues = new HashMap<String, Object>();
        headerValues.put("First Event ID", firstEventId);
        headerValues.put("Timestamp Offset", this.systemTimeOffset);
        headerValues.put("Component Identifiers", this.idLookup.getComponentIdentifiers());
        headerValues.put("Component Types", this.idLookup.getComponentTypes());
        headerValues.put("Queue Identifiers", this.idLookup.getQueueIdentifiers());
        headerValues.put("Event Types", eventTypeNames);
        FieldMapRecord headerInfo = new FieldMapRecord(headerSchema, headerValues);
        this.schemaRecordWriter.writeRecord((Record)headerInfo, (OutputStream)out);
    }

    @Override
    protected int getSerializationVersion() {
        return 1;
    }

    @Override
    protected String getSerializationName() {
        return SERIALIZATION_NAME;
    }

    static {
        int count = 0;
        for (ProvenanceEventType eventType : ProvenanceEventType.values()) {
            eventTypeMap.put(eventType.name(), count++);
            eventTypeNames.add(eventType.name());
        }
    }
}

