/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.util;

import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectoryUtils {
    public static final Pattern INDEX_DIRECTORY_NAME_PATTERN = Pattern.compile("(?:lucene-\\d+-)?index-(.*)");
    public static final FileFilter INDEX_FILE_FILTER = f -> INDEX_DIRECTORY_NAME_PATTERN.matcher(f.getName()).matches();
    public static final FileFilter EVENT_FILE_FILTER = f -> f.getName().endsWith(".prov") || f.getName().endsWith(".prov.gz");
    public static final Comparator<File> SMALLEST_ID_FIRST = (a, b) -> Long.compare(DirectoryUtils.getMinId(a), DirectoryUtils.getMinId(b));
    public static final Comparator<File> LARGEST_ID_FIRST = SMALLEST_ID_FIRST.reversed();
    public static final Comparator<File> OLDEST_INDEX_FIRST = (a, b) -> Long.compare(DirectoryUtils.getIndexTimestamp(a), DirectoryUtils.getIndexTimestamp(b));
    public static final Comparator<File> NEWEST_INDEX_FIRST = OLDEST_INDEX_FIRST.reversed();

    public static long getMinId(File file) {
        String filename = file.getName();
        int firstDotIndex = filename.indexOf(".");
        if (firstDotIndex < 1) {
            return -1L;
        }
        String firstEventId = filename.substring(0, firstDotIndex);
        try {
            return Long.parseLong(firstEventId);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static long getIndexTimestamp(File file) {
        String filename = file.getName();
        Matcher matcher = INDEX_DIRECTORY_NAME_PATTERN.matcher(filename);
        if (!matcher.matches()) {
            return -1L;
        }
        try {
            return Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static long getSize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        File[] children = file.listFiles();
        if (children == null || children.length == 0) {
            return 0L;
        }
        long total = 0L;
        for (File child : children) {
            total += DirectoryUtils.getSize(child);
        }
        return total;
    }
}

