/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store.iterator;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.store.RecordReaderFactory;
import org.apache.nifi.provenance.store.iterator.EventIterator;

public class SequentialRecordReaderEventIterator
implements EventIterator {
    private final Iterator<File> fileIterator;
    private final RecordReaderFactory readerFactory;
    private final long minimumEventId;
    private final int maxAttributeChars;
    private boolean closed = false;
    private RecordReader reader;

    public SequentialRecordReaderEventIterator(List<File> filesToRead, RecordReaderFactory readerFactory, long minimumEventId, int maxAttributeChars) {
        this.fileIterator = filesToRead.iterator();
        this.readerFactory = readerFactory;
        this.minimumEventId = minimumEventId;
        this.maxAttributeChars = maxAttributeChars;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public Optional<ProvenanceEventRecord> nextEvent() throws IOException {
        StandardProvenanceEventRecord event;
        block5: {
            if (this.closed) {
                throw new IOException("EventIterator is already closed");
            }
            if (this.reader == null && !this.rotateReader()) {
                return Optional.empty();
            }
            do {
                try {
                    event = this.reader.nextRecord();
                }
                catch (EOFException eof) {
                    event = null;
                }
                if (event != null) break block5;
            } while (this.rotateReader());
            return Optional.empty();
        }
        return Optional.of(event);
    }

    private boolean rotateReader() throws IOException {
        boolean readerExists;
        boolean bl = readerExists = this.reader != null;
        if (readerExists) {
            this.reader.close();
        }
        boolean multipleReadersOpened = false;
        while (true) {
            if (!this.fileIterator.hasNext()) {
                return false;
            }
            File eventFile = this.fileIterator.next();
            try {
                this.reader = this.readerFactory.newRecordReader(eventFile, Collections.emptyList(), this.maxAttributeChars);
            }
            catch (EOFException | FileNotFoundException e) {
                multipleReadersOpened = true;
                continue;
            }
            break;
        }
        if (!readerExists && !multipleReadersOpened) {
            this.reader.skipToEvent(this.minimumEventId);
        }
        return true;
    }
}

