/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.serialization.RecordReaders;

public class DumpEventFile {
    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("java " + DumpEventFile.class.getName() + " <Event File to Dump>");
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            DumpEventFile.printUsage();
            return;
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            System.out.println("Cannot find file " + file.getAbsolutePath());
            return;
        }
        try (RecordReader reader = RecordReaders.newRecordReader(file, Collections.emptyList(), 65535);){
            StandardProvenanceEventRecord event;
            int index = 0;
            while ((event = reader.nextRecord()) != null) {
                long byteOffset = reader.getBytesConsumed();
                String string = DumpEventFile.stringify((ProvenanceEventRecord)event, index++, byteOffset);
                System.out.println(string);
            }
        }
    }

    private static String stringify(ProvenanceEventRecord event, int index, long byteOffset) {
        StringBuilder sb = new StringBuilder();
        sb.append("Event Index in File = ").append(index).append(", Byte Offset = ").append(byteOffset);
        sb.append("\n\t").append("Event ID = ").append(event.getEventId());
        sb.append("\n\t").append("Event Type = ").append(event.getEventType());
        sb.append("\n\t").append("Event Time = ").append(new Date(event.getEventTime()));
        sb.append("\n\t").append("Event UUID = ").append(event.getFlowFileUuid());
        sb.append("\n\t").append("Component ID = ").append(event.getComponentId());
        sb.append("\n\t").append("Event ID = ").append(event.getComponentType());
        sb.append("\n\t").append("Transit URI = ").append(event.getTransitUri());
        sb.append("\n\t").append("Parent IDs = ").append(event.getParentUuids());
        sb.append("\n\t").append("Child IDs = ").append(event.getChildUuids());
        sb.append("\n\t").append("Previous Attributes = ").append(event.getPreviousAttributes());
        sb.append("\n\t").append("Updated Attributes = ").append(event.getUpdatedAttributes());
        return sb.toString();
    }
}

