/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.schema.EventRecordFields;
import org.apache.nifi.provenance.schema.LookupTableEventRecordFields;
import org.apache.nifi.provenance.schema.LookupTableEventSchema;
import org.apache.nifi.repository.schema.FieldMapRecord;
import org.apache.nifi.repository.schema.NamedValue;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;

public class LookupTableEventRecord
implements Record {
    private final RecordSchema schema;
    private final ProvenanceEventRecord event;
    private final long eventId;
    private final Record contentClaimRecord;
    private final Record previousClaimRecord;
    private final long eventIdStartOffset;
    private final long startTimeOffset;
    private final Map<String, Integer> componentIdMap;
    private final Map<String, Integer> componentTypeMap;
    private final Map<String, Integer> queueIdMap;
    private final Map<String, Integer> eventTypeMap;

    public LookupTableEventRecord(ProvenanceEventRecord event, long eventId, RecordSchema schema, RecordSchema contentClaimSchema, RecordSchema previousContentClaimSchema, long eventIdStartOffset, long startTimeOffset, Map<String, Integer> componentIdMap, Map<String, Integer> componentTypeMap, Map<String, Integer> queueIdMap, Map<String, Integer> eventTypeMap) {
        this.schema = schema;
        this.event = event;
        this.eventId = eventId;
        this.previousClaimRecord = LookupTableEventRecord.createPreviousContentClaimRecord(previousContentClaimSchema, event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), event.getPreviousContentClaimOffset(), event.getPreviousFileSize());
        this.contentClaimRecord = LookupTableEventRecord.createContentClaimRecord(contentClaimSchema, event.getContentClaimContainer(), event.getContentClaimSection(), event.getContentClaimIdentifier(), event.getContentClaimOffset(), event.getFileSize());
        this.eventIdStartOffset = eventIdStartOffset;
        this.startTimeOffset = startTimeOffset;
        this.componentIdMap = componentIdMap;
        this.componentTypeMap = componentTypeMap;
        this.queueIdMap = queueIdMap;
        this.eventTypeMap = eventTypeMap;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    private static Record createPreviousContentClaimRecord(RecordSchema contentClaimSchema, String container, String section, String identifier, Long offset, Long size) {
        if (container == null || section == null || identifier == null) {
            return null;
        }
        HashMap<RecordField, Object> fieldValues = new HashMap<RecordField, Object>();
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_CONTAINER, container);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_SECTION, section);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_IDENTIFIER, identifier);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_OFFSET, offset);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_SIZE, size);
        return new FieldMapRecord(fieldValues, contentClaimSchema);
    }

    private static Record createContentClaimRecord(RecordSchema contentClaimSchema, String container, String section, String identifier, Long offset, Long size) {
        if (container == null || section == null || identifier == null) {
            Map<RecordField, String> lookupValues = Collections.singletonMap(LookupTableEventRecordFields.NO_VALUE, "No Value");
            List<RecordField> noValueFields = Collections.singletonList(contentClaimSchema.getField("No Value"));
            return new FieldMapRecord(lookupValues, new RecordSchema(noValueFields));
        }
        HashMap<RecordField, Object> fieldValues = new HashMap<RecordField, Object>();
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_CONTAINER, container);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_SECTION, section);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_IDENTIFIER, identifier);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_OFFSET, offset);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_SIZE, size);
        List explicitClaimFields = contentClaimSchema.getField("Explicit Value").getSubFields();
        FieldMapRecord explicitClaimRecord = new FieldMapRecord(fieldValues, new RecordSchema(explicitClaimFields));
        return explicitClaimRecord;
    }

    private static String readLookupValue(Object recordValue, List<String> lookup) {
        if (recordValue == null) {
            return null;
        }
        if (recordValue instanceof Boolean) {
            return null;
        }
        if (recordValue instanceof Integer) {
            Integer indexValue = (Integer)recordValue;
            int index = indexValue;
            if (index > lookup.size() - 1) {
                return null;
            }
            return lookup.get(index);
        }
        if (recordValue instanceof String) {
            return (String)recordValue;
        }
        return null;
    }

    private NamedValue createLookupValue(String literalValue, Map<String, Integer> lookup) {
        if (literalValue == null) {
            Map<RecordField, String> lookupValues = Collections.singletonMap(LookupTableEventRecordFields.NO_VALUE, "No Value");
            FieldMapRecord record = new FieldMapRecord(lookupValues, LookupTableEventSchema.NO_VALUE_SCHEMA);
            NamedValue namedValue = new NamedValue("No Value", (Object)record);
            return namedValue;
        }
        Integer index = lookup.get(literalValue);
        if (index == null) {
            Map<RecordField, String> lookupValues = Collections.singletonMap(LookupTableEventRecordFields.EXPLICIT_STRING, literalValue);
            FieldMapRecord record = new FieldMapRecord(lookupValues, LookupTableEventSchema.EXPLICIT_STRING_SCHEMA);
            NamedValue namedValue = new NamedValue("Explicit Value", (Object)record);
            return namedValue;
        }
        Map<RecordField, Integer> lookupValues = Collections.singletonMap(LookupTableEventRecordFields.LOOKUP_VALUE, index);
        FieldMapRecord record = new FieldMapRecord(lookupValues, LookupTableEventSchema.LOOKUP_VALUE_SCHEMA);
        NamedValue namedValue = new NamedValue("Lookup Value", (Object)record);
        return namedValue;
    }

    private NamedValue createExplicitSameOrNoneValue(Record newValue, Record oldValue, Supplier<Record> recordSupplier) {
        if (newValue == null || "No Value".equals(((RecordField)newValue.getSchema().getFields().get(0)).getFieldName())) {
            Map<RecordField, String> lookupValues = Collections.singletonMap(LookupTableEventRecordFields.NO_VALUE, "No Value");
            FieldMapRecord record = new FieldMapRecord(lookupValues, LookupTableEventSchema.NO_VALUE_SCHEMA);
            NamedValue namedValue = new NamedValue("No Value", (Object)record);
            return namedValue;
        }
        if (newValue.equals(oldValue)) {
            Map<RecordField, String> lookupValues = Collections.singletonMap(LookupTableEventRecordFields.UNCHANGED_VALUE, "Unchanged");
            FieldMapRecord record = new FieldMapRecord(lookupValues, LookupTableEventSchema.UNCHANGED_VALUE_SCHEMA);
            NamedValue namedValue = new NamedValue("Unchanged", (Object)record);
            return namedValue;
        }
        Record record = recordSupplier.get();
        NamedValue namedValue = new NamedValue("Explicit Value", (Object)record);
        return namedValue;
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Event ID": {
                return (int)(this.eventId - this.eventIdStartOffset);
            }
            case "Alternate Identifier": {
                return this.event.getAlternateIdentifierUri();
            }
            case "Child UUIDs": {
                return this.event.getChildUuids();
            }
            case "Component ID": {
                return this.createLookupValue(this.event.getComponentId(), this.componentIdMap);
            }
            case "Component Type": {
                return this.createLookupValue(this.event.getComponentType(), this.componentTypeMap);
            }
            case "Content Claim": {
                return this.createExplicitSameOrNoneValue(this.contentClaimRecord, this.previousClaimRecord, () -> this.contentClaimRecord);
            }
            case "Event Details": {
                return this.event.getDetails();
            }
            case "Event Duration": {
                return (int)this.event.getEventDuration();
            }
            case "Event Time": {
                return (int)(this.event.getEventTime() - this.startTimeOffset);
            }
            case "Event Type": {
                return this.eventTypeMap.get(this.event.getEventType().name());
            }
            case "FlowFile Entry Date": {
                return (int)(this.event.getFlowFileEntryDate() - this.startTimeOffset);
            }
            case "Lineage Start Date": {
                return (int)(this.event.getLineageStartDate() - this.startTimeOffset);
            }
            case "Parent UUIDs": {
                return this.event.getParentUuids();
            }
            case "Previous Attributes": {
                return this.event.getPreviousAttributes();
            }
            case "Previous Content Claim": {
                return this.previousClaimRecord;
            }
            case "Relationship": {
                return this.event.getRelationship();
            }
            case "Source Queue Identifier": {
                return this.createLookupValue(this.event.getSourceQueueIdentifier(), this.queueIdMap);
            }
            case "Source System FlowFile Identifier": {
                return this.event.getSourceSystemFlowFileIdentifier();
            }
            case "Transit URI": {
                return this.event.getTransitUri();
            }
            case "Updated Attributes": {
                return this.event.getUpdatedAttributes();
            }
            case "FlowFile UUID": {
                return this.event.getAttribute(CoreAttributes.UUID.key());
            }
        }
        return null;
    }

    private static Long addLong(Integer optionalValue, long requiredValue) {
        if (optionalValue == null) {
            return null;
        }
        return optionalValue.longValue() + requiredValue;
    }

    public static StandardProvenanceEventRecord getEvent(Record record, String storageFilename, long storageByteOffset, int maxAttributeLength, long eventIdStartOffset, long startTimeOffset, List<String> componentIds, List<String> componentTypes, List<String> queueIds, List<String> eventTypes) {
        ProvenanceEventType eventType;
        Map<String, String> previousAttributes = LookupTableEventRecord.truncateAttributes((Map)record.getFieldValue("Previous Attributes"), maxAttributeLength);
        Map<String, String> updatedAttributes = LookupTableEventRecord.truncateAttributes((Map)record.getFieldValue("Updated Attributes"), maxAttributeLength);
        List childUuids = (List)record.getFieldValue("Child UUIDs");
        List parentUuids = (List)record.getFieldValue("Parent UUIDs");
        StandardProvenanceEventRecord.Builder builder = new StandardProvenanceEventRecord.Builder();
        builder.setAlternateIdentifierUri((String)record.getFieldValue("Alternate Identifier"));
        builder.setChildUuids(childUuids);
        builder.setDetails((String)record.getFieldValue("Event Details"));
        builder.setParentUuids(parentUuids);
        builder.setPreviousAttributes(previousAttributes);
        builder.setRelationship((String)record.getFieldValue("Relationship"));
        builder.setSourceSystemFlowFileIdentifier((String)record.getFieldValue("Source System FlowFile Identifier"));
        builder.setTransitUri((String)record.getFieldValue("Transit URI"));
        builder.setUpdatedAttributes(updatedAttributes);
        builder.setComponentId(LookupTableEventRecord.readLookupValue(record.getFieldValue("Component ID"), componentIds));
        builder.setComponentType(LookupTableEventRecord.readLookupValue(record.getFieldValue("Component Type"), componentTypes));
        builder.setSourceQueueIdentifier(LookupTableEventRecord.readLookupValue(record.getFieldValue("Source Queue Identifier"), queueIds));
        Integer eventTypeOrdinal = (Integer)record.getFieldValue("Event Type");
        if (eventTypeOrdinal == null || eventTypeOrdinal > eventTypes.size() || eventTypeOrdinal < 0) {
            eventType = ProvenanceEventType.UNKNOWN;
        } else {
            try {
                eventType = ProvenanceEventType.valueOf((String)eventTypes.get(eventTypeOrdinal));
            }
            catch (Exception e) {
                eventType = ProvenanceEventType.UNKNOWN;
            }
        }
        builder.setEventType(eventType);
        String uuid = null;
        switch (eventType) {
            case CLONE: 
            case FORK: 
            case REPLAY: {
                if (parentUuids == null || parentUuids.isEmpty()) break;
                uuid = (String)parentUuids.get(0);
                break;
            }
            case JOIN: {
                if (childUuids == null || childUuids.isEmpty()) break;
                uuid = (String)childUuids.get(0);
            }
        }
        if (uuid == null) {
            String string = uuid = updatedAttributes == null ? null : updatedAttributes.get(CoreAttributes.UUID.key());
            if (uuid == null) {
                uuid = previousAttributes == null ? null : previousAttributes.get(CoreAttributes.UUID.key());
            }
        }
        builder.setFlowFileUUID(uuid);
        builder.setEventDuration((long)((Integer)record.getFieldValue("Event Duration")).intValue());
        builder.setEventTime(LookupTableEventRecord.addLong((Integer)record.getFieldValue("Event Time"), startTimeOffset).longValue());
        builder.setFlowFileEntryDate(LookupTableEventRecord.addLong((Integer)record.getFieldValue("FlowFile Entry Date"), startTimeOffset).longValue());
        builder.setLineageStartDate(LookupTableEventRecord.addLong((Integer)record.getFieldValue("Lineage Start Date"), startTimeOffset).longValue());
        Integer eventId = (Integer)record.getFieldValue("Event ID");
        if (eventId != null) {
            builder.setEventId(eventId.longValue() + eventIdStartOffset);
        }
        builder.setStorageLocation(storageFilename, storageByteOffset);
        Record previousClaimRecord = (Record)record.getFieldValue("Previous Content Claim");
        if (previousClaimRecord != null) {
            builder.setPreviousContentClaim((String)previousClaimRecord.getFieldValue("Content Claim Container"), (String)previousClaimRecord.getFieldValue("Content Claim Section"), (String)previousClaimRecord.getFieldValue("Content Claim Identifier"), (Long)previousClaimRecord.getFieldValue("Content Claim Offset"), ((Long)previousClaimRecord.getFieldValue("Content Claim Size")).longValue());
        }
        Object contentClaimObject = record.getFieldValue("Content Claim");
        builder.setCurrentContentClaim(null, null, null, null, 0L);
        if (contentClaimObject != null) {
            if (contentClaimObject instanceof String) {
                String contentClaimDescription;
                switch (contentClaimDescription = (String)contentClaimObject) {
                    case "Unchanged": {
                        builder.setCurrentContentClaim((String)previousClaimRecord.getFieldValue("Content Claim Container"), (String)previousClaimRecord.getFieldValue("Content Claim Section"), (String)previousClaimRecord.getFieldValue("Content Claim Identifier"), (Long)previousClaimRecord.getFieldValue("Content Claim Offset"), ((Long)previousClaimRecord.getFieldValue("Content Claim Size")).longValue());
                    }
                }
            } else if (contentClaimObject instanceof Record) {
                Record currentClaimRecord = (Record)contentClaimObject;
                builder.setCurrentContentClaim((String)currentClaimRecord.getFieldValue("Content Claim Container"), (String)currentClaimRecord.getFieldValue("Content Claim Section"), (String)currentClaimRecord.getFieldValue("Content Claim Identifier"), (Long)currentClaimRecord.getFieldValue("Content Claim Offset"), ((Long)currentClaimRecord.getFieldValue("Content Claim Size")).longValue());
            }
        }
        return builder.build();
    }

    private static Map<String, String> truncateAttributes(Map<String, String> attributes, int maxAttributeLength) {
        if (attributes == null) {
            return null;
        }
        boolean anyExceedsLength = attributes.values().stream().filter(value -> value != null).anyMatch(value -> value.length() > maxAttributeLength);
        if (!anyExceedsLength) {
            return attributes;
        }
        HashMap<String, String> truncated = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (value2 == null || value2.length() <= maxAttributeLength) {
                truncated.put(key, value2);
                continue;
            }
            truncated.put(key, value2.substring(0, maxAttributeLength));
        }
        return truncated;
    }
}

