/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.Closeable;
import java.io.File;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneEventIndexSearcher
implements EventIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(LuceneEventIndexSearcher.class);
    private final IndexSearcher indexSearcher;
    private final File indexDirectory;
    private final Directory directory;
    private final DirectoryReader directoryReader;
    private int usageCounter = 0;
    private boolean closed = false;

    public LuceneEventIndexSearcher(IndexSearcher indexSearcher, File indexDirectory, Directory directory, DirectoryReader directoryReader) {
        this.indexSearcher = indexSearcher;
        this.indexDirectory = indexDirectory;
        this.directory = directory;
        this.directoryReader = directoryReader;
    }

    @Override
    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    @Override
    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.usageCounter == 0) {
            this.closeQuietly((Closeable)this.directoryReader);
            this.closeQuietly((Closeable)this.directory);
        }
    }

    public synchronized void incrementUsageCounter() {
        ++this.usageCounter;
    }

    public synchronized void decrementUsageCounter() {
        --this.usageCounter;
        if (this.usageCounter == 0 && this.closed) {
            this.closeQuietly((Closeable)this.directoryReader);
            this.closeQuietly((Closeable)this.directory);
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close {} due to {}", (Object)closeable, (Object)e);
        }
    }
}

