/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.schema.LookupTableEventRecord;
import org.apache.nifi.provenance.serialization.CompressableRecordReader;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.repository.schema.FieldCache;
import org.apache.nifi.repository.schema.NoOpFieldCache;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.SchemaRecordReader;
import org.apache.nifi.stream.io.LimitingInputStream;
import org.apache.nifi.stream.io.StreamUtils;

public class EventIdFirstSchemaRecordReader
extends CompressableRecordReader {
    private RecordSchema schema;
    private SchemaRecordReader recordReader;
    private List<String> componentIds;
    private List<String> componentTypes;
    private List<String> queueIds;
    private List<String> eventTypes;
    private long firstEventId;
    private long systemTimeOffset;

    RecordSchema getSchema() {
        return this.schema;
    }

    SchemaRecordReader getRecordReader() {
        return this.recordReader;
    }

    List<String> getComponentIds() {
        return this.componentIds;
    }

    List<String> getComponentTypes() {
        return this.componentTypes;
    }

    List<String> getQueueIds() {
        return this.queueIds;
    }

    List<String> getEventTypes() {
        return this.eventTypes;
    }

    long getFirstEventId() {
        return this.firstEventId;
    }

    long getSystemTimeOffset() {
        return this.systemTimeOffset;
    }

    public EventIdFirstSchemaRecordReader(InputStream in, String filename, TocReader tocReader, int maxAttributeChars) throws IOException {
        super(in, filename, tocReader, maxAttributeChars);
    }

    protected void verifySerializationVersion(int serializationVersion) {
        if (serializationVersion > 1) {
            throw new IllegalArgumentException("Unable to deserialize record because the version is " + serializationVersion + " and supported versions are 1-1");
        }
    }

    @Override
    protected synchronized void readHeader(DataInputStream in, int serializationVersion) throws IOException {
        RecordSchema headerSchema;
        this.verifySerializationVersion(serializationVersion);
        int eventSchemaLength = in.readInt();
        byte[] buffer = new byte[eventSchemaLength];
        StreamUtils.fillBuffer((InputStream)in, (byte[])buffer);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);){
            this.schema = RecordSchema.readFrom((InputStream)bais);
        }
        this.recordReader = SchemaRecordReader.fromSchema((RecordSchema)this.schema, (FieldCache)new NoOpFieldCache());
        int headerSchemaLength = in.readInt();
        byte[] headerSchemaBuffer = new byte[headerSchemaLength];
        StreamUtils.fillBuffer((InputStream)in, (byte[])headerSchemaBuffer);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(headerSchemaBuffer);){
            headerSchema = RecordSchema.readFrom((InputStream)bais);
        }
        SchemaRecordReader headerReader = SchemaRecordReader.fromSchema((RecordSchema)headerSchema, (FieldCache)new NoOpFieldCache());
        Record headerRecord = headerReader.readRecord((InputStream)in);
        this.componentIds = (List)headerRecord.getFieldValue("Component Identifiers");
        this.componentTypes = (List)headerRecord.getFieldValue("Component Types");
        this.queueIds = (List)headerRecord.getFieldValue("Queue Identifiers");
        this.eventTypes = (List)headerRecord.getFieldValue("Event Types");
        this.firstEventId = (Long)headerRecord.getFieldValue("First Event ID");
        this.systemTimeOffset = (Long)headerRecord.getFieldValue("Timestamp Offset");
    }

    @Override
    protected StandardProvenanceEventRecord nextRecord(DataInputStream in, int serializationVersion) throws IOException {
        this.verifySerializationVersion(serializationVersion);
        long byteOffset = this.getBytesConsumed();
        long eventId = (long)in.readInt() + this.firstEventId;
        int recordLength = in.readInt();
        return this.readRecord(in, eventId, byteOffset, recordLength);
    }

    private StandardProvenanceEventRecord readRecord(DataInputStream in, long eventId, long startOffset, int recordLength) throws IOException {
        LimitingInputStream limitedIn = new LimitingInputStream((InputStream)in, (long)recordLength);
        Record eventRecord = this.recordReader.readRecord((InputStream)limitedIn);
        if (eventRecord == null) {
            return null;
        }
        StandardProvenanceEventRecord deserializedEvent = LookupTableEventRecord.getEvent(eventRecord, this.getFilename(), startOffset, this.getMaxAttributeLength(), this.firstEventId, this.systemTimeOffset, this.componentIds, this.componentTypes, this.queueIds, this.eventTypes);
        deserializedEvent.setEventId(eventId);
        return deserializedEvent;
    }

    protected boolean isData(InputStream in) throws IOException {
        in.mark(1);
        int nextByte = in.read();
        in.reset();
        return nextByte > -1;
    }

    @Override
    protected Optional<StandardProvenanceEventRecord> readToEvent(long eventId, DataInputStream dis, int serializationVersion) throws IOException {
        this.verifySerializationVersion(serializationVersion);
        while (this.isData(dis)) {
            long startOffset = this.getBytesConsumed();
            long id = (long)dis.readInt() + this.firstEventId;
            int recordLength = dis.readInt();
            if (id >= eventId) {
                StandardProvenanceEventRecord event = this.readRecord(dis, id, startOffset, recordLength);
                return Optional.ofNullable(event);
            }
            StreamUtils.skip((InputStream)dis, (long)recordLength);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getDescription();
    }

    private String getDescription() {
        try {
            return "EventIdFirstSchemaRecordReader, toc: " + this.getTocReader().getFile().getAbsolutePath() + ", journal: " + this.getFilename();
        }
        catch (Exception e) {
            return "EventIdFirstSchemaRecordReader@" + Integer.toHexString(this.hashCode());
        }
    }
}

