/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.schema.EventRecordFields;
import org.apache.nifi.repository.schema.FieldMapRecord;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;

public class EventRecord
implements Record {
    private final RecordSchema schema;
    private final ProvenanceEventRecord event;
    private final long eventId;
    private final Record contentClaimRecord;
    private final Record previousClaimRecord;

    public EventRecord(ProvenanceEventRecord event, long eventId, RecordSchema schema, RecordSchema contentClaimSchema) {
        this.schema = schema;
        this.event = event;
        this.eventId = eventId;
        this.contentClaimRecord = EventRecord.createContentClaimRecord(contentClaimSchema, event.getContentClaimContainer(), event.getContentClaimSection(), event.getContentClaimIdentifier(), event.getContentClaimOffset(), event.getFileSize());
        this.previousClaimRecord = EventRecord.createContentClaimRecord(contentClaimSchema, event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), event.getPreviousContentClaimOffset(), event.getPreviousFileSize());
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    private static Record createContentClaimRecord(RecordSchema contentClaimSchema, String container, String section, String identifier, Long offset, Long size) {
        if (container == null || section == null || identifier == null) {
            return null;
        }
        HashMap<RecordField, Object> fieldValues = new HashMap<RecordField, Object>();
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_CONTAINER, container);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_SECTION, section);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_IDENTIFIER, identifier);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_OFFSET, offset);
        fieldValues.put(EventRecordFields.CONTENT_CLAIM_SIZE, size);
        return new FieldMapRecord(fieldValues, contentClaimSchema);
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Event ID": {
                return this.eventId;
            }
            case "Alternate Identifier": {
                return this.event.getAlternateIdentifierUri();
            }
            case "Child UUIDs": {
                return this.event.getChildUuids();
            }
            case "Component ID": {
                return this.event.getComponentId();
            }
            case "Component Type": {
                return this.event.getComponentType();
            }
            case "Content Claim": {
                return this.contentClaimRecord;
            }
            case "Event Details": {
                return this.event.getDetails();
            }
            case "Event Duration": {
                return this.event.getEventDuration();
            }
            case "Event Time": {
                return this.event.getEventTime();
            }
            case "Event Type": {
                return this.event.getEventType().name();
            }
            case "FlowFile Entry Date": {
                return this.event.getFlowFileEntryDate();
            }
            case "FlowFile UUID": {
                return this.event.getFlowFileUuid();
            }
            case "Lineage Start Date": {
                return this.event.getLineageStartDate();
            }
            case "Parent UUIDs": {
                return this.event.getParentUuids();
            }
            case "Previous Attributes": {
                return this.event.getPreviousAttributes();
            }
            case "Previous Content Claim": {
                return this.previousClaimRecord;
            }
            case "Relationship": {
                return this.event.getRelationship();
            }
            case "Source Queue Identifier": {
                return this.event.getSourceQueueIdentifier();
            }
            case "Source System FlowFile Identifier": {
                return this.event.getSourceSystemFlowFileIdentifier();
            }
            case "Transit URI": {
                return this.event.getTransitUri();
            }
            case "Updated Attributes": {
                return this.event.getUpdatedAttributes();
            }
        }
        return null;
    }

    public static StandardProvenanceEventRecord getEvent(Record record, String storageFilename, long storageByteOffset, int maxAttributeLength) {
        StandardProvenanceEventRecord.Builder builder = new StandardProvenanceEventRecord.Builder();
        builder.setAlternateIdentifierUri((String)record.getFieldValue("Alternate Identifier"));
        builder.setChildUuids((List)record.getFieldValue("Child UUIDs"));
        builder.setComponentId((String)record.getFieldValue("Component ID"));
        builder.setComponentType((String)record.getFieldValue("Component Type"));
        builder.setDetails((String)record.getFieldValue("Event Details"));
        builder.setEventDuration(((Long)record.getFieldValue("Event Duration")).longValue());
        builder.setEventTime(((Long)record.getFieldValue("Event Time")).longValue());
        builder.setEventType(ProvenanceEventType.valueOf((String)((String)record.getFieldValue("Event Type"))));
        builder.setFlowFileEntryDate(((Long)record.getFieldValue("FlowFile Entry Date")).longValue());
        builder.setFlowFileUUID((String)record.getFieldValue("FlowFile UUID"));
        builder.setLineageStartDate(((Long)record.getFieldValue("Lineage Start Date")).longValue());
        builder.setParentUuids((List)record.getFieldValue("Parent UUIDs"));
        builder.setPreviousAttributes(EventRecord.truncateAttributes((Map)record.getFieldValue("Previous Attributes"), maxAttributeLength));
        builder.setRelationship((String)record.getFieldValue("Relationship"));
        builder.setSourceQueueIdentifier((String)record.getFieldValue("Source Queue Identifier"));
        builder.setSourceSystemFlowFileIdentifier((String)record.getFieldValue("Source System FlowFile Identifier"));
        builder.setTransitUri((String)record.getFieldValue("Transit URI"));
        builder.setUpdatedAttributes(EventRecord.truncateAttributes((Map)record.getFieldValue("Updated Attributes"), maxAttributeLength));
        Long eventId = (Long)record.getFieldValue("Event ID");
        if (eventId != null) {
            builder.setEventId(eventId.longValue());
        }
        builder.setStorageLocation(storageFilename, storageByteOffset);
        Record currentClaimRecord = (Record)record.getFieldValue("Content Claim");
        if (currentClaimRecord == null) {
            builder.setCurrentContentClaim(null, null, null, null, 0L);
        } else {
            builder.setCurrentContentClaim((String)currentClaimRecord.getFieldValue("Content Claim Container"), (String)currentClaimRecord.getFieldValue("Content Claim Section"), (String)currentClaimRecord.getFieldValue("Content Claim Identifier"), (Long)currentClaimRecord.getFieldValue("Content Claim Offset"), ((Long)currentClaimRecord.getFieldValue("Content Claim Size")).longValue());
        }
        Record previousClaimRecord = (Record)record.getFieldValue("Previous Content Claim");
        if (previousClaimRecord != null) {
            builder.setPreviousContentClaim((String)previousClaimRecord.getFieldValue("Content Claim Container"), (String)previousClaimRecord.getFieldValue("Content Claim Section"), (String)previousClaimRecord.getFieldValue("Content Claim Identifier"), (Long)previousClaimRecord.getFieldValue("Content Claim Offset"), ((Long)previousClaimRecord.getFieldValue("Content Claim Size")).longValue());
        }
        return builder.build();
    }

    private static Map<String, String> truncateAttributes(Map<String, String> attributes, int maxAttributeLength) {
        if (attributes == null) {
            return null;
        }
        boolean anyExceedsLength = attributes.values().stream().filter(value -> value != null).anyMatch(value -> value.length() > maxAttributeLength);
        if (!anyExceedsLength) {
            return attributes;
        }
        HashMap<String, String> truncated = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (value2 == null || value2.length() <= maxAttributeLength) {
                truncated.put(key, value2);
                continue;
            }
            truncated.put(key, value2.substring(0, maxAttributeLength));
        }
        return truncated;
    }
}

