/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet.record;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.parquet.filter.OffsetRecordFilter;
import org.apache.nifi.parquet.stream.NifiParquetInputFile;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.io.InputFile;

public class ParquetRecordReader
implements RecordReader {
    private GenericRecord lastParquetRecord;
    private final RecordSchema recordSchema;
    private final InputStream inputStream;
    private final ParquetReader<GenericRecord> parquetReader;
    private final Long recordsToRead;
    private long recordsRead = 0L;

    public ParquetRecordReader(InputStream inputStream, long inputLength, Configuration configuration, Map<String, String> variables) throws IOException {
        if (inputLength < 0L) {
            throw new IllegalArgumentException("Invalid input length of '" + inputLength + "'. This record reader requires knowing the length of the InputStream and cannot be used in some cases where the length may not be known.");
        }
        Long offset = Optional.ofNullable(variables.get("record.offset")).map(Long::parseLong).orElse(null);
        String recordCount = variables.get("record.count");
        this.recordsToRead = offset != null && recordCount != null ? Long.valueOf(Long.parseLong(recordCount)) : null;
        long fileStartOffset = Optional.ofNullable(variables.get("parquet.file.range.startOffset")).map(Long::parseLong).orElse(0L);
        long fileEndOffset = Optional.ofNullable(variables.get("parquet.file.range.endOffset")).map(Long::parseLong).orElse(Long.MAX_VALUE);
        this.inputStream = inputStream;
        NifiParquetInputFile inputFile = new NifiParquetInputFile(inputStream, inputLength);
        ParquetReader.Builder builder = AvroParquetReader.builder((InputFile)inputFile).withConf(configuration).withFileRange(fileStartOffset, fileEndOffset);
        if (offset != null) {
            builder.withFilter(FilterCompat.get((UnboundRecordFilter)OffsetRecordFilter.offset(offset)));
        }
        this.parquetReader = builder.build();
        this.lastParquetRecord = this.readNextRecord();
        if (this.lastParquetRecord == null) {
            throw new EOFException("Unable to obtain schema because no records were available");
        }
        this.recordSchema = AvroTypeUtil.createSchema((Schema)this.lastParquetRecord.getSchema());
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException {
        if (this.lastParquetRecord == null) {
            return null;
        }
        Map values = AvroTypeUtil.convertAvroRecordToMap((GenericRecord)this.lastParquetRecord, (RecordSchema)this.recordSchema);
        MapRecord record = new MapRecord(this.recordSchema, values);
        this.lastParquetRecord = this.readNextRecord();
        return record;
    }

    public RecordSchema getSchema() {
        return this.recordSchema;
    }

    public void close() throws IOException {
        try {
            this.parquetReader.close();
        }
        finally {
            this.inputStream.close();
        }
    }

    private GenericRecord readNextRecord() throws IOException {
        if (this.recordsToRead != null && this.recordsRead == this.recordsToRead) {
            return null;
        }
        GenericRecord result = (GenericRecord)this.parquetReader.read();
        ++this.recordsRead;
        return result;
    }
}

