/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.parquet.io.DelegatingSeekableInputStream;

public class NifiSeekableInputStream
extends DelegatingSeekableInputStream {
    private final ByteCountingInputStream input;

    public NifiSeekableInputStream(ByteCountingInputStream input) {
        super((InputStream)input);
        this.input = input;
        this.input.mark(8192);
    }

    public long getPos() {
        return this.input.getBytesConsumed();
    }

    public void seek(long newPos) throws IOException {
        long currentPos = this.getPos();
        if (newPos == currentPos) {
            return;
        }
        if (newPos < currentPos) {
            this.input.reset();
            this.input.mark(8192);
        }
        StreamUtils.skip((InputStream)this.input, (long)(newPos - this.getPos()));
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("Mark/reset is not supported");
    }

    public synchronized void reset() {
        throw new UnsupportedOperationException("Mark/reset is not supported");
    }
}

