/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.parquet.stream.NifiSeekableInputStream;
import org.apache.nifi.stream.io.ByteCountingInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class NifiParquetInputFile
implements InputFile {
    private final long length;
    private final ByteCountingInputStream input;

    public NifiParquetInputFile(InputStream input, long length) {
        if (input == null) {
            throw new IllegalArgumentException("InputStream is required");
        }
        if (!input.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark/reset to be used with NifiParquetInputFile");
        }
        this.input = new ByteCountingInputStream(input);
        this.length = length;
    }

    public long getLength() throws IOException {
        return this.length;
    }

    public SeekableInputStream newStream() throws IOException {
        return new NifiSeekableInputStream(this.input);
    }
}

