/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet.record;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.parquet.stream.NifiParquetInputFile;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.io.InputFile;

public class ParquetRecordReader
implements RecordReader {
    private GenericRecord lastParquetRecord;
    private RecordSchema recordSchema;
    private final InputStream inputStream;
    private final InputFile inputFile;
    private final ParquetReader<GenericRecord> parquetReader;

    public ParquetRecordReader(InputStream inputStream, long inputLength, Configuration configuration) throws IOException {
        if (inputLength < 0L) {
            throw new IllegalArgumentException("Invalid input length of '" + inputLength + "'. This record reader requires knowing the length of the InputStream and cannot be used in some cases where the length may not be known.");
        }
        this.inputStream = inputStream;
        this.inputFile = new NifiParquetInputFile(inputStream, inputLength);
        this.parquetReader = AvroParquetReader.builder((InputFile)this.inputFile).withConf(configuration).build();
        this.lastParquetRecord = (GenericRecord)this.parquetReader.read();
        if (this.lastParquetRecord == null) {
            throw new EOFException("Unable to obtain schema because no records were available");
        }
        this.recordSchema = AvroTypeUtil.createSchema((Schema)this.lastParquetRecord.getSchema());
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException {
        if (this.lastParquetRecord == null) {
            return null;
        }
        Map values = AvroTypeUtil.convertAvroRecordToMap((GenericRecord)this.lastParquetRecord, (RecordSchema)this.recordSchema);
        MapRecord record = new MapRecord(this.recordSchema, values);
        this.lastParquetRecord = (GenericRecord)this.parquetReader.read();
        return record;
    }

    public RecordSchema getSchema() {
        return this.recordSchema;
    }

    public void close() throws IOException {
        try {
            this.parquetReader.close();
        }
        finally {
            this.inputStream.close();
        }
    }
}

