/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.server;

import com.google.protobuf.Message;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.SSLEngine;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.opentelemetry.io.StandardRequestContentListener;
import org.apache.nifi.processors.opentelemetry.server.HttpRequestHandler;

public class HttpProtocolNegotiationHandler
extends ApplicationProtocolNegotiationHandler {
    private static final String DEFAULT_APPLICATION_PROTOCOL = "http/1.1";
    private static final int DEFAULT_MAXIMUM_CONTENT_LENGTH = 0xA00000;
    private static final boolean SERVER_CONNECTION = true;
    private final ComponentLog log;
    private final BlockingQueue<Message> messages;

    public HttpProtocolNegotiationHandler(ComponentLog log, BlockingQueue<Message> messages) {
        super(DEFAULT_APPLICATION_PROTOCOL);
        this.log = log;
        this.messages = messages;
    }

    protected void configurePipeline(ChannelHandlerContext channelHandlerContext, String protocol) {
        ChannelPipeline pipeline = channelHandlerContext.pipeline();
        StandardRequestContentListener requestContentListener = new StandardRequestContentListener(this.log, this.messages);
        String applicationProtocol = this.getApplicationProtocol(channelHandlerContext);
        HttpRequestHandler httpRequestHandler = new HttpRequestHandler(this.log, requestContentListener);
        if ("h2".equals(applicationProtocol)) {
            DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
            InboundHttp2ToHttpAdapter frameListener = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(true).validateHttpHeaders(false).maxContentLength(0xA00000).build();
            HttpToHttp2ConnectionHandler connectionHandler = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)frameListener).connection((Http2Connection)connection).build();
            pipeline.addLast(new ChannelHandler[]{connectionHandler, httpRequestHandler});
        } else if (DEFAULT_APPLICATION_PROTOCOL.equals(applicationProtocol)) {
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpContentCompressor(), new HttpServerExpectContinueHandler(), new HttpObjectAggregator(0xA00000), httpRequestHandler});
        } else {
            throw new IllegalStateException(String.format("Application Protocol [%s] not supported", applicationProtocol));
        }
    }

    private String getApplicationProtocol(ChannelHandlerContext channelHandlerContext) {
        SslHandler sslHandler = (SslHandler)channelHandlerContext.pipeline().get(SslHandler.class);
        SSLEngine sslEngine = sslHandler.engine();
        String negotiatedApplicationProtocol = sslEngine.getApplicationProtocol();
        String applicationProtocol = negotiatedApplicationProtocol == null || negotiatedApplicationProtocol.isEmpty() ? DEFAULT_APPLICATION_PROTOCOL : negotiatedApplicationProtocol;
        return applicationProtocol;
    }
}

