/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.opentelemetry.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.opentelemetry.encoding.ResponseBodyWriter;
import org.apache.nifi.processors.opentelemetry.encoding.StandardResponseBodyWriter;
import org.apache.nifi.processors.opentelemetry.io.RequestContentListener;
import org.apache.nifi.processors.opentelemetry.protocol.GrpcHeader;
import org.apache.nifi.processors.opentelemetry.protocol.GrpcStatusCode;
import org.apache.nifi.processors.opentelemetry.protocol.ServiceRequestDescription;
import org.apache.nifi.processors.opentelemetry.protocol.ServiceResponse;
import org.apache.nifi.processors.opentelemetry.protocol.ServiceResponseStatus;
import org.apache.nifi.processors.opentelemetry.protocol.StandardServiceRequestDescription;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryContentEncoding;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryContentType;
import org.apache.nifi.processors.opentelemetry.protocol.TelemetryRequestType;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final ResponseBodyWriter responseBodyWriter = new StandardResponseBodyWriter();
    private final ComponentLog log;
    private final RequestContentListener requestContentListener;

    public HttpRequestHandler(ComponentLog log, RequestContentListener requestContentListener) {
        this.log = Objects.requireNonNull(log, "Component Log required");
        this.requestContentListener = Objects.requireNonNull(requestContentListener, "Listener required");
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest httpRequest) {
        if (HttpMethod.POST == httpRequest.method()) {
            this.handleHttpPostRequest(channelHandlerContext, httpRequest);
        } else {
            this.sendCloseResponse(channelHandlerContext, (HttpRequest)httpRequest, HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
    }

    private void handleHttpPostRequest(ChannelHandlerContext channelHandlerContext, FullHttpRequest httpRequest) {
        HttpHeaders headers = httpRequest.headers();
        String requestContentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        TelemetryContentType telemetryContentType = this.getTelemetryContentType(requestContentType);
        if (telemetryContentType == null) {
            this.sendCloseResponse(channelHandlerContext, (HttpRequest)httpRequest, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
        } else {
            String uri = httpRequest.uri();
            TelemetryRequestType telemetryRequestType = this.getTelemetryRequestType(uri, telemetryContentType);
            if (telemetryRequestType == null) {
                this.sendCloseResponse(channelHandlerContext, (HttpRequest)httpRequest, HttpResponseStatus.NOT_FOUND);
            } else {
                this.handleHttpPostRequestTypeSupported(channelHandlerContext, httpRequest, telemetryRequestType, telemetryContentType);
            }
        }
    }

    private void handleHttpPostRequestTypeSupported(ChannelHandlerContext channelHandlerContext, FullHttpRequest httpRequest, TelemetryRequestType telemetryRequestType, TelemetryContentType telemetryContentType) {
        HttpHeaders headers = httpRequest.headers();
        String requestContentEncoding = headers.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
        TelemetryContentEncoding telemetryContentEncoding = this.getTelemetryContentEncoding(requestContentEncoding);
        InetSocketAddress remoteAddress = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
        StandardServiceRequestDescription serviceRequestDescription = new StandardServiceRequestDescription(telemetryContentEncoding, telemetryContentType, telemetryRequestType, remoteAddress);
        ByteBuf content = httpRequest.content();
        int readableBytes = content.readableBytes();
        TelemetryContentType contentType = serviceRequestDescription.getContentType();
        this.log.debug("HTTP Content Received: Client Address [{}] Content-Type [{}] Bytes [{}]", new Object[]{remoteAddress, contentType.getContentType(), readableBytes});
        ByteBuffer contentBuffer = content.nioBuffer();
        ServiceResponse serviceResponse = this.requestContentListener.onRequest(contentBuffer, serviceRequestDescription);
        this.sendResponse(channelHandlerContext, httpRequest, serviceRequestDescription, serviceResponse);
    }

    private TelemetryContentEncoding getTelemetryContentEncoding(String requestContentEncoding) {
        TelemetryContentEncoding telemetryContentEncoding = TelemetryContentEncoding.NONE;
        String contentEncoding = requestContentEncoding == null ? "" : requestContentEncoding;
        for (TelemetryContentEncoding currentEncoding : TelemetryContentEncoding.values()) {
            if (!currentEncoding.getContentEncoding().contentEquals(contentEncoding)) continue;
            telemetryContentEncoding = currentEncoding;
            break;
        }
        return telemetryContentEncoding;
    }

    private TelemetryRequestType getTelemetryRequestType(String path, TelemetryContentType telemetryContentType) {
        TelemetryRequestType telemetryRequestType = null;
        for (TelemetryRequestType currentType : TelemetryRequestType.values()) {
            String requestTypePath = TelemetryContentType.APPLICATION_GRPC == telemetryContentType ? currentType.getGrpcPath() : currentType.getPath();
            if (!requestTypePath.contentEquals(path)) continue;
            telemetryRequestType = currentType;
            break;
        }
        return telemetryRequestType;
    }

    private TelemetryContentType getTelemetryContentType(String requestContentType) {
        TelemetryContentType telemetryContentType = null;
        for (TelemetryContentType currentType : TelemetryContentType.values()) {
            if (!currentType.getContentType().equals(requestContentType)) continue;
            telemetryContentType = currentType;
            break;
        }
        return telemetryContentType;
    }

    private GrpcStatusCode getGrpcStatusCode(ServiceResponseStatus serviceResponseStatus) {
        GrpcStatusCode grpcStatusCode = ServiceResponseStatus.SUCCESS == serviceResponseStatus ? GrpcStatusCode.OK : (ServiceResponseStatus.INVALID == serviceResponseStatus ? GrpcStatusCode.INVALID_ARGUMENT : (ServiceResponseStatus.PARTIAL_SUCCESS == serviceResponseStatus ? GrpcStatusCode.OK : (ServiceResponseStatus.UNAVAILABLE == serviceResponseStatus ? GrpcStatusCode.UNAVAILABLE : GrpcStatusCode.UNKNOWN)));
        return grpcStatusCode;
    }

    private void sendCloseResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, HttpResponseStatus httpResponseStatus) {
        SocketAddress remoteAddress = channelHandlerContext.channel().remoteAddress();
        HttpMethod method = httpRequest.method();
        String uri = httpRequest.uri();
        HttpVersion httpVersion = httpRequest.protocolVersion();
        this.log.debug("HTTP Request Closed: Client Address [{}] Method [{}] URI [{}] Version [{}] HTTP {}", new Object[]{remoteAddress, method, uri, httpVersion, httpResponseStatus.code()});
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, httpResponseStatus);
        this.setStreamId(httpRequest.headers(), (FullHttpResponse)response);
        ChannelFuture future = channelHandlerContext.writeAndFlush((Object)response);
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void sendResponse(ChannelHandlerContext channelHandlerContext, FullHttpRequest httpRequest, ServiceRequestDescription serviceRequestDescription, ServiceResponse serviceResponse) {
        SocketAddress remoteAddress = channelHandlerContext.channel().remoteAddress();
        HttpMethod method = httpRequest.method();
        String uri = httpRequest.uri();
        HttpVersion httpVersion = httpRequest.protocolVersion();
        ServiceResponseStatus serviceResponseStatus = serviceResponse.getServiceResponseStatus();
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)serviceResponseStatus.getStatusCode());
        this.log.debug("HTTP Request Completed: Client Address [{}] Method [{}] URI [{}] Version [{}] HTTP {}", new Object[]{remoteAddress, method, uri, httpVersion, httpResponseStatus.code()});
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, httpResponseStatus);
        this.setStreamId(httpRequest.headers(), (FullHttpResponse)response);
        TelemetryContentType telemetryContentType = serviceRequestDescription.getContentType();
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)telemetryContentType.getContentType());
        if (TelemetryContentType.APPLICATION_GRPC == telemetryContentType) {
            GrpcStatusCode grpcStatusCode = this.getGrpcStatusCode(serviceResponseStatus);
            response.headers().setInt((CharSequence)GrpcHeader.GRPC_STATUS.getHeader(), grpcStatusCode.getCode());
        }
        byte[] responseBody = this.responseBodyWriter.getResponseBody(serviceRequestDescription, serviceResponse);
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, responseBody.length);
        response.content().writeBytes(responseBody);
        channelHandlerContext.writeAndFlush((Object)response);
    }

    private void setStreamId(HttpHeaders requestHeaders, FullHttpResponse response) {
        String streamId = requestHeaders.get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId != null) {
            response.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
    }
}

