/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mqtt.common;

public enum MqttVersion {
    MQTT_VERSION_3_AUTO(0, "v3 AUTO"),
    MQTT_VERSION_3_1(3, "v3.1.0"),
    MQTT_VERSION_3_1_1(4, "v3.1.1"),
    MQTT_VERSION_5_0(5, "v5.0");

    private final int versionCode;
    private final String displayName;

    private MqttVersion(int versionCode, String displayName) {
        this.versionCode = versionCode;
        this.displayName = displayName;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static MqttVersion fromVersionCode(int versionCode) {
        for (MqttVersion version : MqttVersion.values()) {
            if (version.getVersionCode() != versionCode) continue;
            return version;
        }
        throw new IllegalArgumentException("Unable to map MqttVersionCode from version code: " + versionCode);
    }
}

