/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.mongodb;

import com.mongodb.MongoClientURI;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class Validation {
    public static final Validator DOCUMENT_VALIDATOR = new Validator(){

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            builder.subject(subject).input(value);
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
                return builder.valid(true).explanation("Contains Expression Language").build();
            }
            String reason = null;
            try {
                new MongoClientURI(value);
            }
            catch (Exception e) {
                reason = e.getLocalizedMessage();
            }
            return builder.explanation(reason).valid(reason == null).build();
        }
    };
}

