/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mongodb.AbstractMongoQueryProcessor;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;

@Tags(value={"mongodb", "read", "get"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@CapabilityDescription(value="Creates FlowFiles from documents in MongoDB loaded by a user-specified query.")
@WritesAttributes(value={@WritesAttribute(attribute="mongo.database.name", description="The database where the results came from."), @WritesAttribute(attribute="mongo.collection.name", description="The collection where the results came from.")})
public class GetMongo
extends AbstractMongoQueryProcessor {
    public static final PropertyDescriptor SEND_EMPTY_RESULTS = new PropertyDescriptor.Builder().name("get-mongo-send-empty").displayName("Send Empty Result").description("If a query executes successfully, but returns no results, send an empty JSON document signifying no result.").allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(false).build();
    static final AllowableValue YES_PP = new AllowableValue("true", "True");
    static final AllowableValue NO_PP = new AllowableValue("false", "False");
    static final PropertyDescriptor USE_PRETTY_PRINTING = new PropertyDescriptor.Builder().name("use-pretty-printing").displayName("Pretty Print Results JSON").description("Choose whether or not to pretty print the JSON from the results of the query. Choosing 'True' can greatly increase the space requirements on disk depending on the complexity of the JSON document").required(true).defaultValue(YES_PP.getValue()).allowableValues(new AllowableValue[]{YES_PP, NO_PP}).addValidator(Validator.VALID).build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    private ComponentLog logger;
    private boolean sendEmpty;

    @OnScheduled
    public void onScheduled(PropertyContext context) {
        this.sendEmpty = context.getProperty(SEND_EMPTY_RESULTS).asBoolean();
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    private String buildBatch(List<Document> documents, String jsonTypeSetting, String prettyPrintSetting) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < documents.size(); ++index) {
            Document document = documents.get(index);
            String asJson = jsonTypeSetting.equals("Standard") ? this.getObjectWriter(this.objectMapper, prettyPrintSetting).writeValueAsString((Object)document) : document.toJson(JsonWriterSettings.builder().indent(true).build());
            builder.append(asJson).append(documents.size() > 1 && index + 1 < documents.size() ? ", " : "");
        }
        return "[" + builder.toString() + "]";
    }

    private ObjectWriter getObjectWriter(ObjectMapper mapper, String ppSetting) {
        return ppSetting.equals(YES_PP.getValue()) ? mapper.writerWithDefaultPrettyPrinter() : mapper.writer();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        Document query;
        FlowFile input = null;
        this.logger = this.getLogger();
        if (context.hasIncomingConnection() && (input = session.get()) == null && context.hasNonLoopConnection()) {
            return;
        }
        try {
            query = this.getQuery(context, session, input);
        }
        catch (Exception ex) {
            this.getLogger().error("Error parsing query.", (Throwable)ex);
            if (input != null) {
                session.transfer(input, REL_FAILURE);
            }
            return;
        }
        String jsonTypeSetting = context.getProperty(JSON_TYPE).getValue();
        String usePrettyPrint = context.getProperty(USE_PRETTY_PRINTING).getValue();
        Charset charset = Charset.forName(context.getProperty(CHARSET).evaluateAttributeExpressions(input).getValue());
        Document projection = context.getProperty(PROJECTION).isSet() ? Document.parse((String)context.getProperty(PROJECTION).evaluateAttributeExpressions(input).getValue()) : null;
        Document sort = context.getProperty(SORT).isSet() ? Document.parse((String)context.getProperty(SORT).evaluateAttributeExpressions(input).getValue()) : null;
        String dateFormat = context.getProperty(DATE_FORMAT).evaluateAttributeExpressions(input).getValue();
        this.configureMapper(jsonTypeSetting, dateFormat);
        MongoCollection<Document> collection = this.getCollection(context, input);
        FindIterable it = collection.find((Bson)query);
        Map<String, String> attributes = this.getAttributes(context, input, query, collection);
        if (projection != null) {
            it.projection((Bson)projection);
        }
        if (sort != null) {
            it.sort((Bson)sort);
        }
        if (context.getProperty(LIMIT).isSet()) {
            it.limit(context.getProperty(LIMIT).evaluateAttributeExpressions(input).asInteger().intValue());
        }
        if (context.getProperty(BATCH_SIZE).isSet()) {
            it.batchSize(context.getProperty(BATCH_SIZE).evaluateAttributeExpressions(input).asInteger().intValue());
        }
        long sent = 0L;
        try (MongoCursor cursor = it.iterator();){
            this.configureMapper(jsonTypeSetting, dateFormat);
            if (context.getProperty(RESULTS_PER_FLOWFILE).isSet()) {
                int sizePerBatch = context.getProperty(RESULTS_PER_FLOWFILE).evaluateAttributeExpressions(input).asInteger();
                ArrayList<Object> batch = new ArrayList<Document>();
                while (cursor.hasNext()) {
                    batch.add((Document)cursor.next());
                    if (batch.size() == sizePerBatch) {
                        try {
                            this.writeBatch(this.buildBatch(batch, jsonTypeSetting, usePrettyPrint), input, context, session, attributes, REL_SUCCESS);
                            batch = new ArrayList();
                        }
                        catch (Exception e) {
                            this.logger.error("Error building batch", (Throwable)e);
                        }
                    }
                    ++sent;
                }
                if (batch.size() > 0) {
                    try {
                        this.writeBatch(this.buildBatch(batch, jsonTypeSetting, usePrettyPrint), input, context, session, attributes, REL_SUCCESS);
                    }
                    catch (Exception e) {
                        this.logger.error("Error building batch", (Throwable)e);
                    }
                }
            } else {
                while (cursor.hasNext()) {
                    FlowFile outgoingFlowFile = input == null ? session.create() : session.create(input);
                    outgoingFlowFile = session.write(outgoingFlowFile, out -> {
                        if (jsonTypeSetting.equals("Standard")) {
                            out.write(this.getObjectWriter(this.objectMapper, usePrettyPrint).writeValueAsString(cursor.next()).getBytes(charset));
                        } else {
                            out.write(((Document)cursor.next()).toJson().getBytes(charset));
                        }
                    });
                    outgoingFlowFile = session.putAllAttributes(outgoingFlowFile, attributes);
                    session.getProvenanceReporter().receive(outgoingFlowFile, this.getURI(context));
                    session.transfer(outgoingFlowFile, REL_SUCCESS);
                    ++sent;
                }
            }
            if (input != null) {
                session.transfer(input, REL_ORIGINAL);
            }
            if (sent == 0L && this.sendEmpty) {
                FlowFile empty = input != null ? session.create(input) : session.create();
                empty = session.putAllAttributes(empty, attributes);
                session.transfer(empty, REL_SUCCESS);
            }
        }
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.addAll(descriptors);
        _propertyDescriptors.add(JSON_TYPE);
        _propertyDescriptors.add(USE_PRETTY_PRINTING);
        _propertyDescriptors.add(CHARSET);
        _propertyDescriptors.add(QUERY);
        _propertyDescriptors.add(QUERY_ATTRIBUTE);
        _propertyDescriptors.add(PROJECTION);
        _propertyDescriptors.add(SORT);
        _propertyDescriptors.add(LIMIT);
        _propertyDescriptors.add(BATCH_SIZE);
        _propertyDescriptors.add(RESULTS_PER_FLOWFILE);
        _propertyDescriptors.add(DATE_FORMAT);
        _propertyDescriptors.add(SSL_CONTEXT_SERVICE);
        _propertyDescriptors.add(CLIENT_AUTH);
        _propertyDescriptors.add(SEND_EMPTY_RESULTS);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        _relationships.add(REL_ORIGINAL);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

