/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.junit.jupiter.api.Assertions;

public class MockFlowFile
implements FlowFileRecord {
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final long id;
    private final long entryDate;
    private final long creationTime;
    private boolean penalized = false;
    private byte[] data = new byte[0];
    private long lastEnqueuedDate = 0L;
    private long enqueuedIndex = 0L;

    public MockFlowFile(long id) {
        this.creationTime = System.nanoTime();
        this.id = id;
        this.lastEnqueuedDate = this.entryDate = System.currentTimeMillis();
        this.attributes.put(CoreAttributes.FILENAME.key(), System.nanoTime() + ".mockFlowFile");
        this.attributes.put(CoreAttributes.PATH.key(), "target");
        String uuid = UUID.randomUUID().toString();
        this.attributes.put(CoreAttributes.UUID.key(), uuid);
    }

    public MockFlowFile(long id, FlowFile toCopy) {
        this.creationTime = System.nanoTime();
        this.id = id;
        this.entryDate = toCopy.getEntryDate();
        Map attributesToCopy = toCopy.getAttributes();
        Object filename = (String)attributesToCopy.get(CoreAttributes.FILENAME.key());
        if (filename == null) {
            filename = System.nanoTime() + ".mockFlowFile";
        }
        this.attributes.put(CoreAttributes.FILENAME.key(), (String)filename);
        String path = (String)attributesToCopy.get(CoreAttributes.PATH.key());
        if (path == null) {
            path = "target";
        }
        this.attributes.put(CoreAttributes.PATH.key(), path);
        String uuid = (String)attributesToCopy.get(CoreAttributes.UUID.key());
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
        }
        this.attributes.put(CoreAttributes.UUID.key(), uuid);
        this.attributes.putAll(toCopy.getAttributes());
        byte[] dataToCopy = ((MockFlowFile)toCopy).data;
        this.data = new byte[dataToCopy.length];
        System.arraycopy(dataToCopy, 0, this.data, 0, dataToCopy.length);
        this.penalized = toCopy.isPenalized();
    }

    void setPenalized(boolean penalized) {
        this.penalized = penalized;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLineageStartDate() {
        return this.entryDate;
    }

    public int compareTo(FlowFile o) {
        return this.getAttribute(CoreAttributes.UUID.key()).compareTo(o.getAttribute(CoreAttributes.UUID.key()));
    }

    public String getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public long getEntryDate() {
        return this.entryDate;
    }

    public long getId() {
        return this.id;
    }

    public long getSize() {
        return this.data.length;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getContent() {
        return new String(this.getData(), StandardCharsets.UTF_8);
    }

    public InputStream getContentStream() {
        return new ByteArrayInputStream(this.getData());
    }

    public boolean isPenalized() {
        return this.penalized;
    }

    public void putAttributes(Map<String, String> attrs) {
        this.attributes.putAll(attrs);
    }

    public void removeAttributes(Set<String> attrNames) {
        for (String attrName : attrNames) {
            if (CoreAttributes.UUID.key().equals(attrName)) continue;
            this.attributes.remove(attrName);
        }
    }

    public String toString() {
        return "FlowFile[" + this.id + "," + this.getAttribute(CoreAttributes.FILENAME.key()) + "," + this.getSize() + "B]";
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 13).append(this.id).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof FlowFile) {
            return ((FlowFile)obj).getId() == this.id;
        }
        return false;
    }

    public void assertAttributeExists(String attributeName) {
        Assertions.assertTrue((boolean)this.attributes.containsKey(attributeName), (String)("Attribute " + attributeName + " does not exist"));
    }

    public void assertAttributeNotExists(String attributeName) {
        Assertions.assertFalse((boolean)this.attributes.containsKey(attributeName), (String)("Attribute " + attributeName + " should not exist on FlowFile, but exists with value " + this.attributes.get(attributeName)));
    }

    public void assertAttributeEquals(String attributeName, String expectedValue) {
        Assertions.assertEquals((Object)expectedValue, (Object)this.attributes.get(attributeName), (String)("Expected attribute " + attributeName + " to be " + expectedValue + " but instead it was " + this.attributes.get(attributeName)));
    }

    public void assertAttributeNotEquals(String attributeName, String expectedValue) {
        Assertions.assertNotSame((Object)expectedValue, (Object)this.attributes.get(attributeName));
    }

    public void assertContentEquals(File file) throws IOException {
        this.assertContentEquals(file.toPath());
    }

    public void assertContentEquals(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, StandardOpenOption.READ);){
            this.assertContentEquals(in);
        }
    }

    public void assertContentEquals(byte[] data) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            this.assertContentEquals(in);
        }
    }

    public void assertContentEquals(String data) {
        this.assertContentEquals(data, StandardCharsets.UTF_8);
    }

    public void assertContentEquals(String data, String charset) {
        this.assertContentEquals(data, Charset.forName(charset));
    }

    public void assertContentEquals(String data, Charset charset) {
        String value = new String(this.data, charset);
        Assertions.assertEquals((Object)data, (Object)value);
    }

    public void assertContentEquals(InputStream in) throws IOException {
        int bytesRead = 0;
        try (BufferedInputStream buffered = new BufferedInputStream(in);){
            for (int i = 0; i < this.data.length; ++i) {
                int fromStream = buffered.read();
                if (fromStream < 0) {
                    Assertions.fail((String)("FlowFile content is " + this.data.length + " bytes but provided input is only " + bytesRead + " bytes"));
                }
                if ((fromStream & 0xFF) != (this.data[i] & 0xFF)) {
                    Assertions.fail((String)("FlowFile content differs from input at byte " + bytesRead + " with input having value " + (fromStream & 0xFF) + " and FlowFile having value " + (this.data[i] & 0xFF)));
                }
                ++bytesRead;
            }
            int nextByte = buffered.read();
            if (nextByte >= 0) {
                Assertions.fail((String)("Contents of input and FlowFile were the same through byte " + this.data.length + "; however, FlowFile's content ended at this point, and input has more data"));
            }
        }
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public Long getLastQueueDate() {
        return this.lastEnqueuedDate;
    }

    public void setLastEnqueuedDate(long lastEnqueuedDate) {
        this.lastEnqueuedDate = lastEnqueuedDate;
    }

    public long getPenaltyExpirationMillis() {
        return -1L;
    }

    public ContentClaim getContentClaim() {
        return null;
    }

    public long getContentClaimOffset() {
        return 0L;
    }

    public long getLineageStartIndex() {
        return 0L;
    }

    public long getQueueDateIndex() {
        return this.enqueuedIndex;
    }

    public void setEnqueuedIndex(long enqueuedIndex) {
        this.enqueuedIndex = enqueuedIndex;
    }

    public boolean isAttributeEqual(String attributeName, String expectedValue) {
        if (!this.attributes.containsKey(attributeName)) {
            return false;
        }
        String value = this.attributes.get(attributeName);
        return Objects.equals(expectedValue, value);
    }

    public boolean isContentEqual(String expected) {
        return this.isContentEqual(expected, StandardCharsets.UTF_8);
    }

    public boolean isContentEqual(String expected, Charset charset) {
        String value = new String(this.data, charset);
        return Objects.equals(expected, value);
    }

    public boolean isContentEqual(byte[] expected) {
        return Arrays.equals(expected, this.data);
    }
}

